package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.vo.SubcontractaccountPullVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeExendVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;

/**
 * 分包月度报量及申请报告
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subcontractingvolume")
public class SubcontractingvolumeController implements Serializable {
	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IBillCodeApi billCodeApi;
	@Autowired
	private IOrgApi iOrgApi;

	private static final String BILL_CODE = "Subcontractingvolume_Open_Apply_Code";// 此处需要根据实际修改

	@Autowired
	private ISubcontractingvolumeService service;
	@Autowired
	private ISubcontractingvolumedetailService subcontractingvolumedetailService;

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<SubcontractingvolumeVO> saveOrUpdate(@RequestBody SubcontractingvolumeVO saveorUpdateVO) {
		SubcontractingvolumeEntity entity = BeanMapper.map(saveorUpdateVO, SubcontractingvolumeEntity.class);
		if ((entity.getId() == null || entity.getId() == 0) && StringUtils.isAllBlank(entity.getBillCode())) {
			CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,
					InvocationInfoProxy.getTenantid());
			if (billCode.isSuccess()) {
				// entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
				entity.setBillCode(billCode.getData());// 此处需要根据实际修改 删除本行或者上一行
			} else {
				throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
			}
		}
		service.saveOrUpdate(entity, false);
		SubcontractingvolumeVO vo = BeanMapper.map(entity, SubcontractingvolumeVO.class);
		return CommonResponse.success("保存或修改单据成功！", vo);
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<SubcontractingvolumeVO> queryDetail(Long id) {
		SubcontractingvolumeEntity entity = service.selectById(id);
		SubcontractingvolumeVO vo = BeanMapper.map(entity, SubcontractingvolumeVO.class);
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<SubcontractingvolumeVO> vos) {
		service.removeByIds(vos.stream().map(SubcontractingvolumeVO::getId).collect(Collectors.toList()), true);
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @Description queryList 查询列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<SubcontractingvolumeVO>> queryList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
		// param.getParams().put("orgId",new
		// Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

		IPage<SubcontractingvolumeEntity> page = service.queryPage(param, false);
		IPage<SubcontractingvolumeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractingvolumeVO.class));

		return CommonResponse.success("查询列表数据成功！", pageData);
	}

	/**
	 * @Description 导出
	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/excelExport", method = RequestMethod.POST)
	@ResponseBody
	public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		fuzzyFields.add("billCode");
		fuzzyFields.add("contractName");
		fuzzyFields.add("projectName");
		param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.setPageIndex(1);
		param.setPageSize(-1);
		/** 数据隔离 本下 没有组织orgId的删除下面代码 */
		// param.getParams().put("orgId",new
		// Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
		List<SubcontractingvolumeEntity> list = service.queryList(param);
		//时间转换
		List<SubcontractingvolumeVO> subcontractingvolumeVOList = BeanMapper.mapList(list, SubcontractingvolumeVO.class);
		for (int i = 0; i < subcontractingvolumeVOList.size(); i++) {
			SubcontractingvolumeVO subcontractingvolumeVO = subcontractingvolumeVOList.get(i);
			subcontractingvolumeVO.setSort(String.valueOf(i+1));
			if (subcontractingvolumeVO.getReportingTime()!=null){
				subcontractingvolumeVO.setReportingTimeShow(DateUtils.dateSimple2(subcontractingvolumeVO.getReportingTime()));
			}

			String billStateStr = subcontractingvolumeVO.getBillState().toString();
			if (billStateStr != null){
				if("0".equals(billStateStr)){//自由态
					billStateStr = "自由态";
				}else if("1".equals(billStateStr)){//已提交
					billStateStr = "已提交";
				}else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
					billStateStr = "审批中";
				}else if("3".equals(billStateStr)){//审批通过
					billStateStr = "审批通过";
				}else if("4".equals(billStateStr)){//驳回
					billStateStr = "驳回";
				}

				subcontractingvolumeVO.setBillStateStr(billStateStr);
			}
		}
		// todo:字段翻译等等
		Map<String, Object> beans = new HashMap<>();
		beans.put("records", subcontractingvolumeVOList);
		ExcelExport.getInstance().export("subcontractingvolume-export.xlsx", beans, response);
	}

	/**
	 * @Description 参照
	 * @param param
	 * @Return void
	 */
	@RequestMapping(value = "/refSubcontractingvolumeData", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<SubcontractingvolumeVO>> refSubcontractingvolumeData(@RequestParam Integer pageNumber,
			@RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
		QueryParam param = new QueryParam();
		param.setPageSize(pageSize);
		param.setPageIndex(pageNumber);
		param.setSearchText(searchText);
		param.setSearchObject(searchObject);
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		if (StringUtils.isNotEmpty(condition)) {
			/** 处理condition */
			JSONObject _con = JSONObject.parseObject(condition);
		}

		IPage<SubcontractingvolumeEntity> page = service.queryPage(param, false);
		IPage<SubcontractingvolumeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractingvolumeVO.class));

		return CommonResponse.success("查询参照数据成功！", pageData);
	}

	/**
	 * @Description 生成分包月度报量台账列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/toSubcontractaccount", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<SubcontractingvolumeExendVO>> toSubcontractaccount(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();
		/** 租户隔离 */
		param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
		param.getParams().put("orgId",
				new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()
						.stream().map(OrgVO::getId).collect(Collectors.toList())));

		IPage<SubcontractingvolumeEntity> page = service.queryPage(param, false);
		IPage<SubcontractingvolumeExendVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractingvolumeExendVO.class));
		for (SubcontractingvolumeExendVO vo : pageData.getRecords()) {
			QueryWrapper queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("mid", vo.getId());
			queryWrapper.eq("dr", 0);
			List<SubcontractingvolumedetailEntity> line1s = subcontractingvolumedetailService.list(queryWrapper);
			BigDecimal reportedQuantities = new BigDecimal(0.0);
			BigDecimal taxReportedQuantities = new BigDecimal(0.0);
			java.math.BigDecimal approvalQuantity = new BigDecimal(0.0); // 本月审批工程量(除税)
			java.math.BigDecimal taxApprovalQuantity = new BigDecimal(0.0); // 本月审批工程量(含税)
			java.math.BigDecimal cumulativeApproval = new BigDecimal(0.0); // 至本月审批工程量(除税)
			java.math.BigDecimal taxCumulativeApproval = new BigDecimal(0.0); // 至本月审批工程量(含税)
			for (SubcontractingvolumedetailEntity line1 : line1s) {
				reportedQuantities = reportedQuantities.add(line1.getAmounts());
				taxReportedQuantities = taxReportedQuantities.add(line1.getTaxAmounts());

				approvalQuantity = approvalQuantity.add(line1.getAmounts());
				taxApprovalQuantity = taxApprovalQuantity.add(line1.getTaxAmounts());
				cumulativeApproval = cumulativeApproval.add(line1.getCumulativeAmounts());
				taxCumulativeApproval = taxCumulativeApproval.add(line1.getCumulativeTaxAmounts());
			}
			vo.setReportedQuantities(reportedQuantities);
			vo.setTaxReportedQuantities(taxReportedQuantities);

			vo.setApprovalQuantity(approvalQuantity);
			vo.setTaxApprovalQuantity(taxApprovalQuantity);
			vo.setCumulativeApproval(cumulativeApproval);
			vo.setTaxCumulativeApproval(taxCumulativeApproval);

			SubcontractaccountPullVO subcontractaccountPullVO = this.service
					.getSubcontractaccountAmount(vo.getContractId());
			if (subcontractaccountPullVO != null) {
				vo.setCumulativeReporting(subcontractaccountPullVO.getCumulativeReporting());
				vo.setTaxCumulativeReporting(subcontractaccountPullVO.getTaxCumulativeReporting());
			} else {
				vo.setCumulativeReporting(new BigDecimal(0.0));
				vo.setTaxCumulativeReporting(new BigDecimal(0.0));
			}

		}
		return CommonResponse.success("查询列表数据成功！", pageData);
	}
}
