package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.VisaclaimaccountEntity;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.bean.SubcontractvisaEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractvisaService;
import com.ejianc.business.middlemeasurement.vo.SubcontractvisaVO;

/**
 * 分包经济签证月清确认单
 *
 * @author generator
 */
@Controller
@RequestMapping("subcontractvisa")
public class SubcontractvisaController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISubcontractvisaService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> saveOrUpdate(@RequestBody SubcontractvisaVO saveorUpdateVO) {
        SubcontractvisaEntity entity = BeanMapper.map(saveorUpdateVO, SubcontractvisaEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());

            //创建条件构造器
            QueryWrapper<SubcontractvisaEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("contract_id", entity.getContractId());
            queryWrapper.ne("bill_state", 3);//3审批不通过
            List<SubcontractvisaEntity> pro = service.list(queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("同一合同只能存在一份自由态、审批中、审批驳回的\"签证索赔台账\"!");
            }
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                // entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //计算累计金额
        QueryWrapper<SubcontractvisaEntity> wrapper = new QueryWrapper<>();
        //本次签证金额含税
        BigDecimal inCurrentAmount1 = entity.getInCurrentAmount();
        //本次签证金额除税
        BigDecimal exCurrentAmount1 = entity.getExCurrentAmount();
        //本期签证零工含税
        BigDecimal inCurrentOddjob1 = entity.getInCurrentOddjob();
        //本期签证零工除税
        BigDecimal exCurrentOddjob1 = entity.getExCurrentOddjob();

        //累计含税
        BigDecimal amount = BigDecimal.valueOf(0);
        BigDecimal oddjob = BigDecimal.valueOf(0);
        //累计除税
        BigDecimal exAmount = BigDecimal.valueOf(0);
        BigDecimal exOddjob = BigDecimal.valueOf(0);

        wrapper.eq("contract_id", entity.getContractId());
        wrapper.eq("bill_state", 3);//审批通过
        List<SubcontractvisaEntity> list = service.list(wrapper);
        if (list.size() > 0 && list != null) {
            for (int i = 0; i < list.size(); i++) {
                SubcontractvisaEntity subcontractvisaEntity = list.get(i);
                //含税
                BigDecimal inCurrentAmount = subcontractvisaEntity.getInCurrentAmount();
                amount = amount.add(inCurrentAmount);
                BigDecimal inCurrentOddjob = subcontractvisaEntity.getInCurrentOddjob();
                oddjob = oddjob.add(inCurrentOddjob);
                //除税
                BigDecimal exCurrentAmount = subcontractvisaEntity.getExCurrentAmount();
                exAmount = exAmount.add(exCurrentAmount);
                BigDecimal exCurrentOddjob = subcontractvisaEntity.getExCurrentOddjob();
                exOddjob = exOddjob.add(exCurrentOddjob);
            }
        }
        if(inCurrentAmount1 != null){
            amount = amount.add(inCurrentAmount1);
            entity.setInCumulativeAmount(amount);
        }
        if(inCurrentOddjob1 != null){
            oddjob = oddjob.add(inCurrentOddjob1);
            entity.setInCumulativeOddjob(oddjob);
        }
        if(exCurrentAmount1 != null){
            exAmount = exAmount.add(exCurrentAmount1);
            entity.setExCumulativeAmount(exAmount);
        }
        if(exCurrentOddjob1 != null){
            exOddjob = exOddjob.add(exCurrentOddjob1);
            entity.setExCumulativeOddjob(exOddjob);
        }
        //计算合计
        BigDecimal total = new BigDecimal(0);
        if(saveorUpdateVO.getInCurrentAmount() != null){
             total = saveorUpdateVO.getInCurrentAmount().add(saveorUpdateVO.getInCurrentOddjob());
        }
        entity.setTotal(total);
        service.saveOrUpdate(entity, false);
        SubcontractvisaVO vo = BeanMapper.map(entity, SubcontractvisaVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> queryDetail(Long id) {
        SubcontractvisaEntity entity = service.selectById(id);
        SubcontractvisaVO vo = BeanMapper.map(entity, SubcontractvisaVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractvisaVO> vos) {
        service.removeByIds(vos.stream().map(SubcontractvisaVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubcontractvisaVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
         List<String> fuzzyFields = param.getFuzzyFields();
         fuzzyFields.add("code");
         fuzzyFields.add("contract_name");
         fuzzyFields.add("project_name");

        /** 租户隔离 */
        // param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        // param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<SubcontractvisaEntity> page = service.queryPage(param, false);
        IPage<SubcontractvisaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractvisaVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<SubcontractvisaEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SubcontractvisaVO> subcontractvisaVOList = BeanMapper.mapList(list, SubcontractvisaVO.class);
        for (int i = 0; i < list.size(); i++) {
            SubcontractvisaVO vo = subcontractvisaVOList.get(0);
            vo.setSort(String.valueOf(i+1));
            if (vo.getHappenTime()!=null){
                vo.setHappenTime(DateUtil.date(vo.getHappenTime()));
            }
            if (vo.getStartTime()!=null){
                vo.setStartTime(DateUtil.date(vo.getStartTime()));
            }
            if (vo.getEndTime()!=null){
                vo.setEndTime(DateUtil.date(vo.getEndTime()));
            }

            String billStateStr = vo.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                vo.setBillStateStr(billStateStr);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", subcontractvisaVOList);
        ExcelExport.getInstance().export("subcontractvisa-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubcontractvisaData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubcontractvisaVO>> refSubcontractvisaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubcontractvisaEntity> page = service.queryPage(param, false);
        IPage<SubcontractvisaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractvisaVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }
}
