package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 工程计量台账导入导出
 */
@Controller
@RequestMapping("engineermeasurementExport")
public class ExcelEngineermeasurementController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEngineermeasurementdetailService engineermeasurementdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadEngineermeasurement",method = RequestMethod.POST)
    @ResponseBody
    public void downloadEngineermeasurement(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "engineermeasurementdetail-import.xlsx", "工程计量台账模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportEngineermeasurement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportEngineermeasurement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<EngineermeasurementdetailVO> successList = new ArrayList<>();
        List<EngineermeasurementdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);

            if (result != null && result.size() > 0) {
                for (int i = 3; i < result.size(); i++) {
                    EngineermeasurementdetailVO engineermeasurementdetailVO = new EngineermeasurementdetailVO();
                    List<String> datas = result.get(i);
                    engineermeasurementdetailVO.setId(IdWorker.getId());//id
                    engineermeasurementdetailVO.setImageProgress(StringUtils.isNotBlank(datas.get(1)) ? String.valueOf(datas.get(1)) : null); // 形象进度
                    engineermeasurementdetailVO.setIspecificDate(StringUtils.isNotBlank(datas.get(2)) ? DateUtils.Date(datas.get(2)) : null); // 年月日
                    engineermeasurementdetailVO.setCivilEngineering(StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : null); //土建
                    engineermeasurementdetailVO.setInstall(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : null); //  安装
                    engineermeasurementdetailVO.setTotal(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); //  合计
                    engineermeasurementdetailVO.setActualCivilEngineering(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null); // 土建
                    engineermeasurementdetailVO.setActualInstall(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); //安装
                    engineermeasurementdetailVO.setActualTotal(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null);//  合计
                    engineermeasurementdetailVO.setFinancialIncome(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null);// 财务列报收入
                    engineermeasurementdetailVO.setActualCost(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null);// 实际成本
                    engineermeasurementdetailVO.setRightConfirmationRate(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null);// 确权率
                    engineermeasurementdetailVO.setContractApprovalTime(StringUtils.isNotBlank(datas.get(12)) ? DateUtils.Date(datas.get(12)) : null);// 合同审批时间
                    engineermeasurementdetailVO.setActualReportingTime(StringUtils.isNotBlank(datas.get(13)) ? DateUtils.Date(datas.get(13)) : null);// 实际上报时间
                    engineermeasurementdetailVO.setActualApprovalTime(StringUtils.isNotBlank(datas.get(14)) ? DateUtils.Date(datas.get(14)) : null);// 实际审批时间
                    engineermeasurementdetailVO.setAmountAgreedReceivables(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null);// 合同约定应收款金额
                    engineermeasurementdetailVO.setAmountCollected(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : null);// 收款金额
                    engineermeasurementdetailVO.setAmongCivilEngineering(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : null);// 土建
                    engineermeasurementdetailVO.setAmongInstall(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : null);// 安装
                    engineermeasurementdetailVO.setAgreedCollectionTime(StringUtils.isNotBlank(datas.get(19)) ? DateUtils.Date(datas.get(19)) : null);// 合同约定收款时间
                    engineermeasurementdetailVO.setActualCollectionTime(StringUtils.isNotBlank(datas.get(20)) ? DateUtils.Date(datas.get(20)) : null);// 实际收款时间
                    engineermeasurementdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(21)) ? String.valueOf(datas.get(21)) : null); // 备注

                    successList.add(engineermeasurementdetailVO);
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportEngineermeasurementFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportEngineermeasurementFromDatabase(@RequestBody EngineermeasurementVO engineermeasurementVO, HttpServletResponse response) {
        QueryWrapper<EngineermeasurementdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", engineermeasurementVO.getId());
        queryWrapper.eq("dr", 0);
        List<EngineermeasurementdetailEntity> list = engineermeasurementdetailService.list(queryWrapper);
        List<EngineermeasurementdetailVO> engineermeasurementdetailVOList = BeanMapper.mapList(list, EngineermeasurementdetailVO.class);
        if (engineermeasurementdetailVOList != null && engineermeasurementdetailVOList.size() > 0) {
            for (int i = 0; i < engineermeasurementdetailVOList.size(); i++) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = engineermeasurementdetailVOList.get(i);
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() != null) {
                    engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", engineermeasurementdetailVOList);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportEngineermeasurementFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportEngineermeasurementFromPage(@RequestBody List<EngineermeasurementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = list.get(i);
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() != null) {
                    engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }

}
