package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import com.fasterxml.jackson.datatype.jsr310.DecimalUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 项目期中结算台账导入导出
 */
@Controller
@RequestMapping("interimsettlementExport")
public class ExcelInterimsettlementController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInterimsettlementdetailService interimsettlementdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadInterimsettlementdetail",method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "interimsettlementdetail-import.xlsx", "项目期中结算台账模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelInterimsettlement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInterimsettlement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<InterimsettlementdetailVO> successList = new ArrayList<>();
        List<InterimsettlementdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            BigDecimal newApproval = new BigDecimal(0.0);
            BigDecimal newRetention =  new BigDecimal(0.0);
            BigDecimal newActual =  new BigDecimal(0.0);
            BigDecimal newUncollected =  new BigDecimal(0.0);
            BigDecimal newReceivable =  new BigDecimal(0.0);


            QueryWrapper<InterimsettlementdetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_state",3);
            List<InterimsettlementdetailEntity> list = interimsettlementdetailService.list(wrapper);
            if(CollectionUtil.isEmpty(list)){
                throw new RuntimeException("暂无审批通过的数据");
            }

            for (InterimsettlementdetailEntity entity : list) {
                if(entity.getCurrentApproval() != null){
                    newApproval.add(entity.getCurrentApproval());
                }
                if(entity.getCurrentReceivable() != null){
                    newReceivable.add(entity.getCurrentReceivable());
                }
                if(entity.getCurrentActual()!=null){
                    newRetention.add(entity.getCurrentRetention());
                }
                if(entity.getCurrentActual()!=null){
                    newActual.add(entity.getCurrentActual());
                }
                if(entity.getCurrentUncollected()!=null){
                    newUncollected.add(entity.getCurrentUncollected());
                }
            }
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    InterimsettlementdetailVO interimsettlementVO = new InterimsettlementdetailVO();
                    List<String> datas = result.get(i);
                    if(StringUtils.isNotEmpty(datas.get(4))){
                       newApproval.add(new BigDecimal(Double.valueOf(datas.get(4))));
                    }
                    if(StringUtils.isNotEmpty(datas.get(6))){
                        newReceivable.add(new BigDecimal(Double.valueOf(datas.get(6))));
                    }
                    if(StringUtils.isNotEmpty(datas.get(7))){
                        newRetention.add(new BigDecimal(Double.valueOf(datas.get(7))));
                    }
                    if(StringUtils.isNotEmpty(datas.get(8))){
                        newActual.add(new BigDecimal(Double.valueOf(datas.get(8))));
                    }
                    if(StringUtils.isNotEmpty(datas.get(9))){
                        newUncollected.add(new BigDecimal(Double.valueOf(datas.get(9))));
                    }
                    interimsettlementVO.setId(IdWorker.getId());//id
                    interimsettlementVO.setIssueNumber(StringUtils.isNotBlank(datas.get(0)) ? String.valueOf(datas.get(0)) : null); // 期号
                    interimsettlementVO.setCompletionMonth(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 完成工程款月份
                    interimsettlementVO.setApplicationNo(StringUtils.isNotBlank(datas.get(2)) ? String.valueOf(datas.get(2)) : null); //申请单编号
                    interimsettlementVO.setApplicationAmount(StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : null); //  申请金额(元)
                    interimsettlementVO.setCurrentApproval(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : null); //  本期
                    interimsettlementVO.setCumulativeApproval(StringUtils.isNotBlank(datas.get(4)) ? newApproval : null); // 累计
                    interimsettlementVO.setIncome(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); //财务列报收入
                    interimsettlementVO.setCurrentReceivable(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : null);//  本期
                    interimsettlementVO.setCumulativeReceivable(StringUtils.isNotBlank(datas.get(6)) ? newReceivable : null);// 累计
                    interimsettlementVO.setCurrentRetention(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); //  本期
                    interimsettlementVO.setCumulativeRetention(StringUtils.isNotBlank(datas.get(7)) ? newRetention : null); // 累计
                    interimsettlementVO.setCurrentActual(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 本期
                    interimsettlementVO.setCumulativeActual(StringUtils.isNotBlank(datas.get(8)) ? newActual : null); // 累计
                    interimsettlementVO.setCurrentUncollected(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 本期
                    interimsettlementVO.setCumulativeUncollected(StringUtils.isNotBlank(datas.get(9)) ? newUncollected : null); // 累计
                    interimsettlementVO.setActualCollection(StringUtils.isNotBlank(datas.get(10)) ? DateUtils.Date(datas.get(10)) : null);// 实际收款日期
                    interimsettlementVO.setCashFlow(StringUtils.isNotBlank(datas.get(11)) ? String.valueOf(datas.get(11)) : null);// 现金流
                    interimsettlementVO.setRemarks(StringUtils.isNotBlank(datas.get(12)) ? String.valueOf(datas.get(12)) : null); // 备注

                    successList.add(interimsettlementVO);
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportInterimsettlementFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody InterimsettlementVO detailVo, HttpServletResponse response) {
        QueryWrapper<InterimsettlementdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<InterimsettlementdetailEntity> list = interimsettlementdetailService.list(queryWrapper);
        List<InterimsettlementdetailVO> interimsettlementdetailVOList = BeanMapper.mapList(list, InterimsettlementdetailVO.class);
        if (interimsettlementdetailVOList != null && interimsettlementdetailVOList.size() > 0) {
            for (int i = 0; i < interimsettlementdetailVOList.size(); i++) {
                InterimsettlementdetailVO interimsettlementdetailVO = interimsettlementdetailVOList.get(i);
                interimsettlementdetailVO.setSort(String.valueOf(i + 1));
                if (interimsettlementdetailVO.getActualCollection() != null) {
                    interimsettlementdetailVO.setActualCollectionShow(DateUtils.dateSimple(interimsettlementdetailVO.getActualCollection()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", interimsettlementdetailVOList);
        ExcelExport.getInstance().export("interimsettlementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportInterimsettlementdetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<InterimsettlementdetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                InterimsettlementdetailVO interimsettlementdetailVO = list.get(i);
                interimsettlementdetailVO.setSort(String.valueOf(i + 1));
                if (interimsettlementdetailVO.getActualCollection() != null) {
                    interimsettlementdetailVO.setActualCollection(DateUtil.date(interimsettlementdetailVO.getActualCollection()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("interimsettlementdetail-export.xlsx", beans, response);
    }

}
