package com.ejianc.business.middlemeasurement.excel;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.business.middlemeasurement.vo.VisaclaimaccountVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 月度物资采购结算导入导出
 */
@Controller
@RequestMapping("purchasesettlementExport")
public class ExcelPurchasesettlementController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    
    private IPurchasesettlementdetailService purchasesettlementdetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadPurchasesettlement")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "purchasesettlementdetail-import.xlsx", "月度物资采购结算模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportPurchasesettlement", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PurchasesettlementdetailVO> successList = new ArrayList<>();
        List<PurchasesettlementdetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PurchasesettlementdetailVO purchasesettlementdetailVO = new PurchasesettlementdetailVO();
                    purchasesettlementdetailVO.setId(IdWorker.getId());//id
                    purchasesettlementdetailVO.setSource(StringUtils.isNotBlank(datas.get(0)) ? datas.get(0) : null); // 来源
                    purchasesettlementdetailVO.setBillCode(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 材料编码
                    purchasesettlementdetailVO.setBillName(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 材料名称
                    purchasesettlementdetailVO.setBrandModel(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 品牌规格型号
                    purchasesettlementdetailVO.setUnit(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); // 单位
                    purchasesettlementdetailVO.setSupplyQuantity(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : null); // 供货数量
                    purchasesettlementdetailVO.setSupplyTime(StringUtils.isNotBlank(datas.get(6)) ?  DateUtils.Date(datas.get(6)) : null); //供货时间
                    purchasesettlementdetailVO.setUnitPrice(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : null); // 合同单价除税(元)
                    purchasesettlementdetailVO.setTaxUnitPrice(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 合同单价含税(元)
                    purchasesettlementdetailVO.setSettlementPrice(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 结算单价(除税)(元)
                    purchasesettlementdetailVO.setTaxSettlementPrice(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 结算单价(含税)(元)
                    purchasesettlementdetailVO.setSettlementAmount(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); //  结算金额(除税)(元)
                    purchasesettlementdetailVO.setTaxSettlementAmount(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); //  结算金额(含税)(元)
                    purchasesettlementdetailVO.setRemarks(StringUtils.isNotBlank(datas.get(13)) ?datas.get(13) : null); // 备注
                    purchasesettlementdetailVO.setSettlementTotal(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null); // 累计结算金额(除税)
                    purchasesettlementdetailVO.setTaxSettlementTotal(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null); //累计结算金额(含税)
                    successList.add(purchasesettlementdetailVO);
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPurchasesettlementFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody PurchasesettlementVO purchasesettlementVO, HttpServletResponse response) {
        QueryWrapper<PurchasesettlementdetailEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("mid", purchasesettlementVO.getId());
        queryWrapper.eq("dr", 0);
        List<PurchasesettlementdetailEntity> list = purchasesettlementdetailService.list(queryWrapper);
        List<PurchasesettlementdetailVO> purchasesettlementdetailVOList = BeanMapper.mapList(list, PurchasesettlementdetailVO.class);
        if (purchasesettlementdetailVOList != null && purchasesettlementdetailVOList.size() > 0) {
            for (int i = 0; i < purchasesettlementdetailVOList.size(); i++) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = purchasesettlementdetailVOList.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if(purchasesettlementdetailVO.getSupplyTime()!=null){
                    purchasesettlementdetailVO.setSupplyTimeShow(DateUtils.dateSimple(purchasesettlementdetailVO.getSupplyTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", purchasesettlementdetailVOList);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPurchasesettlementFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<PurchasesettlementdetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = list.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if(purchasesettlementdetailVO.getSupplyTime()!=null){
                    purchasesettlementdetailVO.setSupplyTimeShow(DateUtils.dateSimple(purchasesettlementdetailVO.getSupplyTime()));
                }

            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }

}
