package com.ejianc.business.middlemeasurement.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 月度周转租赁单清单导入导出
 */
@Controller
@RequestMapping("revolvingleaseExport")
public class ExcelRevolvingleaseController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadRevolvinglease",method = RequestMethod.POST)
    @ResponseBody
    public void downloadRevolvinglease(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "revolvingleasedetail-import.xlsx", "月度周转租赁单清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportRevolvinglease", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportRevolvinglease(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<RevolvingleasedetailVO> successList = new ArrayList<>();
        List<RevolvingleasedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);

            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    RevolvingleasedetailVO revolvingleasedetailVO = new RevolvingleasedetailVO();
                    List<String> datas = result.get(i);
                    revolvingleasedetailVO.setId(IdWorker.getId());//id
                    revolvingleasedetailVO.setMaterialCode(StringUtils.isNotBlank(datas.get(1)) ? String.valueOf(datas.get(1)) : null); // 物资编码
                    revolvingleasedetailVO.setLesseeMaterialsName(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 租赁物资名称
                    revolvingleasedetailVO.setSpecifications(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); //规格型号
                    revolvingleasedetailVO.setMeasurementUnit(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); //  计量单位
                    revolvingleasedetailVO.setLesseeQuantity(StringUtils.isNotBlank(datas.get(5)) ? Integer.valueOf((int)Float.parseFloat(datas.get(5))) : null); //  租赁数量
                    revolvingleasedetailVO.setSettleTime(StringUtils.isNotBlank(datas.get(6)) ? DateUtils.Date(datas.get(6)) : null); // 本期计算起始时间
                    revolvingleasedetailVO.setEndTime(StringUtils.isNotBlank(datas.get(7)) ? DateUtils.Date(datas.get(7)) : null); //本期计算终止时间
                    revolvingleasedetailVO.setLesseeTerm(StringUtils.isNotBlank(datas.get(8)) ? Integer.valueOf((int)Float.parseFloat(datas.get(8))) : null);//  本期租赁期长(天)
                    revolvingleasedetailVO.setLesseeUnitprice(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null);// 租赁单价(除税)(元)
                    revolvingleasedetailVO.setTaxLesseeUnitprice(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null);// 租赁单价(含税)(元)
                    revolvingleasedetailVO.setTaxLesseeUnitprice(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null);// 租赁单价(含税)(元)
                    revolvingleasedetailVO.setLesseeTotalprice(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null);// 租赁合价(除税)(元)
                    revolvingleasedetailVO.setTaxLesseeTotalprice(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null);// 租赁合价(含税)(元)
                    revolvingleasedetailVO.setLossDamage(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null);// 丢失损坏量
                    revolvingleasedetailVO.setCompensateUnitprice(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null);// 赔偿单价(除税)(元)
                    revolvingleasedetailVO.setTaxCompensateUnitprice(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null);// 赔偿单价(含税)(元)
                    revolvingleasedetailVO.setCompensateAccount(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : null);// 赔偿金额((除税)(元)
                    revolvingleasedetailVO.setTaxCompensateAccount(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : null);// 赔偿金额((含税)(元)
                    revolvingleasedetailVO.setOtherExpenses(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : null);// 清理维修费非等其他费用(除税)(元)
                    revolvingleasedetailVO.setTaxOtherExpenses(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) : null);// 清理维修费非等其他费用(含税)(元)
                    revolvingleasedetailVO.setMonthlyExpenses(StringUtils.isNotBlank(datas.get(20)) ? new BigDecimal(datas.get(20)) : null);// 月度结算费用(除税)(元)
                    revolvingleasedetailVO.setTaxMonthlyExpenses(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) : null);// 月度结算费用(含税)(元)
                    revolvingleasedetailVO.setRemarks(StringUtils.isNotBlank(datas.get(22)) ? String.valueOf(datas.get(22)) : null); // 备注

                    successList.add(revolvingleasedetailVO);
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleaseFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleaseFromDatabase(@RequestBody RevolvingleaseVO revolvingleaseVO, HttpServletResponse response) {
        QueryWrapper<RevolvingleasedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", revolvingleaseVO.getId());
        queryWrapper.eq("dr", 0);
        List<RevolvingleasedetailEntity> list = revolvingleasedetailService.list(queryWrapper);
        List<RevolvingleasedetailVO> revolvingleasedetailVOList = BeanMapper.mapList(list, RevolvingleasedetailVO.class);
        if (revolvingleasedetailVOList != null && revolvingleasedetailVOList.size() > 0) {
            for (int i = 0; i < revolvingleasedetailVOList.size(); i++) {
                RevolvingleasedetailVO revolvingleasedetailVO = revolvingleasedetailVOList.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() != null) {
                    revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", revolvingleasedetailVOList);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleaseFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleaseFromPage(@RequestBody List<RevolvingleasedetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                RevolvingleasedetailVO revolvingleasedetailVO = list.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() != null) {
                    revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

}
