package com.ejianc.business.middlemeasurement.excel;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumemdetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeodetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;

import cn.hutool.core.collection.CollectionUtil;

/**
 * 分包月度报量及申请报告导入导出
 */
@Controller
@RequestMapping("subcontractingvolumeExport")
public class ExcelSubcontractingvolumeController {

	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ISubcontractingvolumedetailService subcontractingvolumedetailService;

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download", method = RequestMethod.POST)
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "subcontractingvolumedetail-import.xlsx", "分包月度报量及申请报告");
	}
	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download2", method = RequestMethod.POST)
	@ResponseBody
	public void download2(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "subcontractingvolumemdetail-import.xlsx", "物资代扣及超用扣款清单");
	}
	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download3", method = RequestMethod.POST)
	@ResponseBody
	public void download3(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "subcontractingvolumeodetail-import.xlsx", "其它扣款清单");
	}

	/**
	 * excel导入
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData(HttpServletRequest request, HttpServletResponse response)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<SubcontractingvolumedetailVO> successList = new ArrayList<>();
		List<SubcontractingvolumedetailVO> errorList = new ArrayList<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 3; i < result.size(); i++) {
					SubcontractingvolumedetailVO vo = new SubcontractingvolumedetailVO();
					List<String> datas = result.get(i);
					vo.setBillCode(datas.get(0));
					vo.setBillName(datas.get(1));
					vo.setUnit(datas.get(2));
					vo.setQuantity(
							StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : new BigDecimal(0.0));
					vo.setUnitprice(
							StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : new BigDecimal(0.0));
					vo.setTaxUnitprice(
							StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : new BigDecimal(0.0));
					vo.setAmounts(vo.getQuantity().multiply(vo.getUnitprice()));
					vo.setTaxAmounts(vo.getQuantity().multiply(vo.getTaxUnitprice()));

					vo.setExamineQuantity(
							StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : new BigDecimal(0.0));
					vo.setExamineUnitprice(
							StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : new BigDecimal(0.0));
					vo.setExamineTaxUnitprice(
							StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : new BigDecimal(0.0));
					vo.setExamineAmounts(vo.getExamineQuantity().multiply(vo.getExamineUnitprice()));
					vo.setExamineTaxAmounts(vo.getExamineQuantity().multiply(vo.getExamineTaxUnitprice()));
					vo.setMemo(datas.get(10));
					successList.add(vo);
				}

			}
		}
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导入 物资代扣及超用扣款清单
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import2", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData2(HttpServletRequest request, HttpServletResponse response)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<SubcontractingvolumemdetailVO> successList = new ArrayList<>();
		List<SubcontractingvolumemdetailVO> errorList = new ArrayList<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 3; i < result.size(); i++) {
					SubcontractingvolumemdetailVO vo = new SubcontractingvolumemdetailVO();
					List<String> datas = result.get(i);
					vo.setBillCode(datas.get(0));
					vo.setBillName(datas.get(1));
					vo.setUnit(datas.get(2));
					vo.setUnitprice(
							StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : new BigDecimal(0.0));
					vo.setBudgetquantity(
							StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : new BigDecimal(0.0));
					vo.setActualConsumption(
							StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : new BigDecimal(0.0));
					vo.setExcessdosage(vo.getActualConsumption().add(vo.getBudgetquantity()));
					if (vo.getExcessdosage().compareTo(new BigDecimal(0.0)) < 0) {
						vo.setExcessdosage(new BigDecimal(0.0));
					}
					vo.setOverdraftDeduction(vo.getExcessdosage().multiply(vo.getUnitprice()));
					vo.setWithholding(datas.get(6));
					successList.add(vo);
				}

			}
		}
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导入其它扣款清单
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import3", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData3(HttpServletRequest request, HttpServletResponse response)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<SubcontractingvolumeodetailVO> successList = new ArrayList<>();
		List<SubcontractingvolumeodetailVO> errorList = new ArrayList<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 3; i < result.size(); i++) {
					SubcontractingvolumeodetailVO vo = new SubcontractingvolumeodetailVO();
					List<String> datas = result.get(i);
					vo.setExpenseName(datas.get(0));
					vo.setUnit(datas.get(1));
					vo.setQuantity(
							StringUtils.isNotBlank(datas.get(2)) ? new BigDecimal(datas.get(2)) : new BigDecimal(0.0));
					vo.setUnitPrice(
							StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : new BigDecimal(0.0));
					vo.setAmounts(vo.getQuantity().multiply(vo.getQuantity()));
					vo.setRemarks(datas.get(4));
					successList.add(vo);
				}

			}
		}
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export", method = RequestMethod.POST)
	@ResponseBody
	public void export(@RequestBody SubcontractingvolumeVO vo, HttpServletResponse response) {
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", vo.getId());
		queryWrapper.eq("dr", 0);
		List<SubcontractingvolumedetailEntity> list = this.subcontractingvolumedetailService.list(queryWrapper);
		List<SubcontractingvolumedetailVO> vOList = BeanMapper.mapList(list, SubcontractingvolumedetailVO.class);
		if (!CollectionUtil.isEmpty(vOList)) {
			for (int i = 0; i < vOList.size(); i++) {
				SubcontractingvolumedetailVO linevo = vOList.get(i);
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", vOList);
		ExcelExport.getInstance().export("subcontractingvolumedetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				SubcontractingvolumedetailVO vo = list.get(i);
				vo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("subcontractingvolumedetail-export.xlsx", beans, response);
	}

}
