package com.ejianc.business.middlemeasurement.excel;


import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractvisadetailEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractvisadetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.SubcontractvisaVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractvisadetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 总包签证索赔导入导出
 */
@Controller
@RequestMapping("subcontractvisaExport")
public class ExcelSubcontractvisaController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubcontractvisadetailService subcontractvisadetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadSubcontractvisa")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "subcontractvisadetail-import.xlsx", "分包经济签证月清确认单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportSubcontractvisa", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<SubcontractvisadetailVO> successList = new ArrayList<>();
        List<SubcontractvisadetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    SubcontractvisadetailVO subcontractvisadetailVO = new SubcontractvisadetailVO();
                    subcontractvisadetailVO.setId(IdWorker.getId());//id
                    if(datas.get(0) == null || StringUtils.isBlank(datas.get(0))){
                        subcontractvisadetailVO.setErrorMsg("'分包方式'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        subcontractvisadetailVO.setSubcontractingMode(StringUtils.isNotBlank(datas.get(0)) ? datas.get(0) : null); // 分包方式
                    }

                    if(datas.get(1) == null || StringUtils.isBlank(datas.get(1))){
                        subcontractvisadetailVO.setErrorMsg("'签证编号'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        subcontractvisadetailVO.setVisaCode(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 签证编号
                    }

                    if(datas.get(2) == null || StringUtils.isBlank(datas.get(2))){
                        subcontractvisadetailVO.setErrorMsg("'签证主要内容'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        subcontractvisadetailVO.setVisaContent(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 签证主要内容
                    }

                    if(datas.get(3) == null || StringUtils.isBlank(datas.get(3)) ){
                        if(DateUtils.grepDate(datas.get(3))){
                            subcontractvisadetailVO.setErrorMsg("'分包报送日期'格式错误");
                            errorList.add(subcontractvisadetailVO);
                        }
                    }else{
                        subcontractvisadetailVO.setSubmissionDate(StringUtils.isNotBlank(datas.get(3)) ? DateUtils.Date(datas.get(3)) : null); // 分包报送日期
                    }

                    if(datas.get(4) == null || StringUtils.isBlank(datas.get(4))){
                        subcontractvisadetailVO.setErrorMsg("'报送值(元)'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(4))){
                            subcontractvisadetailVO.setErrorMsg("'报送值(元)'格式错误");
                            errorList.add(subcontractvisadetailVO);
                        }else{
                            subcontractvisadetailVO.setSubmittedValue(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : null); // 报送值(元)
                        }
                    }

                    if(datas.get(5) == null || StringUtils.isBlank(datas.get(5))){
                        subcontractvisadetailVO.setErrorMsg("'签证经办人'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        subcontractvisadetailVO.setVisaagentName(StringUtils.isNotBlank(datas.get(5)) ? datas.get(5) : null); // 签证经办人
                    }

                    if(datas.get(6) == null || StringUtils.isBlank(datas.get(6)) ){
                        subcontractvisadetailVO.setErrorMsg("'签证提交日期'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        if(DateUtils.grepDate(datas.get(6))){
                            subcontractvisadetailVO.setErrorMsg("'签证提交日期'格式错误");
                            errorList.add(subcontractvisadetailVO);
                        }else{
                            subcontractvisadetailVO.setVisaSubmissionDate(StringUtils.isNotBlank(datas.get(6)) ? DateUtils.Date(datas.get(6)) : null); //签证提交日期
                        }
                    }

                    if(datas.get(7) == null || StringUtils.isBlank(datas.get(7)) ){
                        if(DateUtils.grepDate(datas.get(7))){
                            subcontractvisadetailVO.setErrorMsg("'项目部审批日期'格式错误");
                            errorList.add(subcontractvisadetailVO);
                        }
                    }else{
                        subcontractvisadetailVO.setApprovalDate(StringUtils.isNotBlank(datas.get(7)) ? DateUtils.Date(datas.get(7)) : null); // 项目部审批日期
                    }

                    if(datas.get(9) == null || StringUtils.isBlank(datas.get(9))){
                        subcontractvisadetailVO.setErrorMsg("'签证金额(除税)(元)'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(9))){
                            subcontractvisadetailVO.setErrorMsg("'签证金额(除税)(元)'格式错误");
                            errorList.add(subcontractvisadetailVO);
                        }else{
                            subcontractvisadetailVO.setExVisaAmount(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 签证金额(除税)(元)
                        }
                    }

                    if(datas.get(10) == null || StringUtils.isBlank(datas.get(10))){
                        subcontractvisadetailVO.setErrorMsg("'签证金额(含税)(元)'不能为空");
                        errorList.add(subcontractvisadetailVO);

                    }else{
                        if(!NumberUtil.isNumber(datas.get(10))){
                            subcontractvisadetailVO.setErrorMsg("'签证金额(含税)(元)'格式错误");
                            errorList.add(subcontractvisadetailVO);
                        }else{
                            subcontractvisadetailVO.setInVisaAmount(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null); // 签证金额(含税)(元)
                        }
                    }

                    if(datas.get(11) == null || StringUtils.isBlank(datas.get(11))){
                        subcontractvisadetailVO.setErrorMsg("'其中签证零工(除税)(元)'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(11))){
                            subcontractvisadetailVO.setErrorMsg("'其中签证零工(除税)(元)'格式错误");
                            errorList.add(subcontractvisadetailVO);
                        }else{
                            subcontractvisadetailVO.setExVisaOddjob(StringUtils.isNotBlank(datas.get(11)) ?new BigDecimal(datas.get(11)) : null); // 其中签证零工(除税)(元)
                        }
                    }

                    if(datas.get(12) == null || StringUtils.isBlank(datas.get(12))){
                        subcontractvisadetailVO.setErrorMsg("'其中签证零工(含税)(元)'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(12))){
                            subcontractvisadetailVO.setErrorMsg("'其中签证零工(含税)(元)'格式错误");
                            errorList.add(subcontractvisadetailVO);
                        }else{
                            subcontractvisadetailVO.setInVisaOddjob(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) : null); //  其中签证零工(含税)(元)
                        }
                    }

                    if(datas.get(13) == null || StringUtils.isBlank(datas.get(13))){
                        subcontractvisadetailVO.setErrorMsg("' 合计(元)'不能为空");
                        errorList.add(subcontractvisadetailVO);
                    }else{
                        if(!NumberUtil.isNumber(datas.get(13))){
                            subcontractvisadetailVO.setErrorMsg("' 合计(元)'格式错误");
                            errorList.add(subcontractvisadetailVO);
                        }else{
                            subcontractvisadetailVO.setTotalDetail(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null); //  合计(元)
                        }
                    }

                    subcontractvisadetailVO.setUnitSituation(StringUtils.isNotBlank(datas.get(14)) ? datas.get(14) : null); // 分包签证转扣单位情况
                    if(CollectionUtil.isEmpty(errorList)){
                        successList.add(subcontractvisadetailVO);
                    }
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubcontractvisaFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody SubcontractvisaVO subcontractvisaVO, HttpServletResponse response) {
        QueryWrapper<SubcontractvisadetailEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("mid", subcontractvisaVO.getId());
        queryWrapper.eq("dr", 0);
        List<SubcontractvisadetailEntity> list = subcontractvisadetailService.list(queryWrapper);
        List<SubcontractvisadetailVO> subcontractvisadetailVOList = BeanMapper.mapList(list, SubcontractvisadetailVO.class);
        if (subcontractvisadetailVOList != null && subcontractvisadetailVOList.size() > 0) {
            for (int i = 0; i < subcontractvisadetailVOList.size(); i++) {
                SubcontractvisadetailVO subcontractvisadetailVO = subcontractvisadetailVOList.get(i);
                subcontractvisadetailVO.setSort(String.valueOf(i + 1));
                if(subcontractvisadetailVO.getSubmissionDate()!=null){
                    subcontractvisadetailVO.setSubmissionDateShow(DateUtils.dateSimple(subcontractvisadetailVO.getSubmissionDate()));
                }
                if(subcontractvisadetailVO.getApprovalDate()!=null){
                    subcontractvisadetailVO.setApprovalDateShow(DateUtils.dateSimple(subcontractvisadetailVO.getApprovalDate()));
                }
                if (subcontractvisadetailVO.getVisaSubmissionDate()!=null){
                    subcontractvisadetailVO.setVisaSubmissionDateShow(DateUtils.dateSimple(subcontractvisadetailVO.getVisaSubmissionDate()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", subcontractvisadetailVOList);
        ExcelExport.getInstance().export("subcontractvisadetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportSubcontractvisaFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<SubcontractvisadetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                SubcontractvisadetailVO subcontractvisadetailVO = list.get(i);
                subcontractvisadetailVO.setSort(String.valueOf(i + 1));
                if(subcontractvisadetailVO.getSubmissionDate()!=null){
                    subcontractvisadetailVO.setSubmissionDateShow(DateUtils.dateSimple(subcontractvisadetailVO.getSubmissionDate()));
                }
                if(subcontractvisadetailVO.getApprovalDate()!=null){
                subcontractvisadetailVO.setApprovalDateShow(DateUtils.dateSimple(subcontractvisadetailVO.getApprovalDate()));
                }
                if (subcontractvisadetailVO.getVisaSubmissionDate()!=null){
                subcontractvisadetailVO.setVisaSubmissionDateShow(DateUtils.dateSimple(subcontractvisadetailVO.getVisaSubmissionDate()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subcontractvisadetail-export.xlsx", beans, response);
    }

}
