package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodedetailEntity;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodedetailService;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("designsubcontractnodeExport")
public class ExceldesignsubcontractnodeController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDesignsubcontractnodedetailService detailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDesignsubcontractnode",method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "designsubcontractnode-import.xlsx", "设计分包节点报量申请模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportDesignsubcontractnode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInterimsettlement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DesignsubcontractnodedetailVO> successList = new ArrayList<>();
        List<DesignsubcontractnodedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);


         /*   QueryWrapper<DesignsubcontractnodedetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_state",3);
            List<DesignsubcontractnodedetailEntity> list = detailService.list(wrapper);
            if(CollectionUtil.isEmpty(list)){
                throw new RuntimeException("暂无审批通过的数据");
            }
*/
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    DesignsubcontractnodedetailVO designsubcontractnodedetailVO = new DesignsubcontractnodedetailVO();
                    List<String> datas = result.get(i);
                    designsubcontractnodedetailVO.setSort(String.valueOf(IdWorker.getId()));//id
                    designsubcontractnodedetailVO.setCompleteContent(StringUtils.isNotBlank(datas.get(0)) ? String.valueOf(datas.get(0)) : null); // 完成内容
                    designsubcontractnodedetailVO.setProjectName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 项目名称
                    designsubcontractnodedetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(2)) ? String.valueOf(datas.get(2)) : null); //计量单位
                    designsubcontractnodedetailVO.setCompleteThisDeclare(StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : new BigDecimal(0)); //  完成量（本期申报）
                    designsubcontractnodedetailVO.setExTaxUnitThisDeclare(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) :  new BigDecimal(0)); // 除税单价（本期申报）
                    designsubcontractnodedetailVO.setInTaxUnitThisDeclare(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) :  new BigDecimal(0)); // 含税单价（本期申报）
                    designsubcontractnodedetailVO.setExTaxTotalThisDeclare(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) :  new BigDecimal(0)); //含税合价（本期申报）
                    designsubcontractnodedetailVO.setInTaxTotalThisDeclare(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) :  new BigDecimal(0));// 含税合价（本期申报）
                    designsubcontractnodedetailVO.setCompleteLastAudit(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) :  new BigDecimal(0));// 完成量（上期累计审核）
                    designsubcontractnodedetailVO.setExTaxUnitLastAudit(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) :  new BigDecimal(0)); //  除税单价（上期累计审核）
                    designsubcontractnodedetailVO.setInTaxUnitLastAudit(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) :  new BigDecimal(0)); // 含税单价（上期累计审核）
                    designsubcontractnodedetailVO.setExTaxTotalLastAudit(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) :  new BigDecimal(0)); // 含税合价（上期累计审核）
                    designsubcontractnodedetailVO.setInTaxTotalLastAudit(StringUtils.isNotBlank(datas.get(12)) ? new BigDecimal(datas.get(12)) :  new BigDecimal(0)); // 含税合价（上期累计审核）
                    designsubcontractnodedetailVO.setCompleteThisAudit(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) :  new BigDecimal(0)); // 完成量（本期审核）
                    designsubcontractnodedetailVO.setExTaxUnitThisAudit(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) :  new BigDecimal(0)); // 除税单价（本期审核）
                    designsubcontractnodedetailVO.setInTaxUnitThisAudit(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) :  new BigDecimal(0));// 含税单价（本期审核）
                    designsubcontractnodedetailVO.setExTaxTotalThisAudit(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) :  new BigDecimal(0));// 含税合价（本期审核）
                    designsubcontractnodedetailVO.setInTaxTotalThisAudit(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) :  new BigDecimal(0)); // 含税合价（本期审核）
                    designsubcontractnodedetailVO.setCompleteCumulativeAudit(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) :  new BigDecimal(0)); // 完成量（累计审核）
                    designsubcontractnodedetailVO.setExTaxUnitCumulativeAudit(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) :  new BigDecimal(0)); //除税单价（累计审核）
                    designsubcontractnodedetailVO.setInTaxUnitCumulativeAudit(StringUtils.isNotBlank(datas.get(20)) ? new BigDecimal(datas.get(20)) :  new BigDecimal(0));//  含税单价（累计审核）
                    designsubcontractnodedetailVO.setExTaxTotalCumulativeAudit(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) :  new BigDecimal(0));//含税合价（累计审核）
                    designsubcontractnodedetailVO.setInTaxTotalCumulativeAudit(StringUtils.isNotBlank(datas.get(22)) ? new BigDecimal(datas.get(22)) :  new BigDecimal(0)); // 含税合价（累计审核）
                    designsubcontractnodedetailVO.setRemarks(StringUtils.isNotBlank(datas.get(23)) ? String.valueOf(datas.get(23)) : null); // 备注

                    successList.add(designsubcontractnodedetailVO);
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDesignsubcontractnodeFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody DesignsubcontractnodedetailVO detailVo, HttpServletResponse response) {
        QueryWrapper<DesignsubcontractnodedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<DesignsubcontractnodedetailEntity> list = detailService.list(queryWrapper);
        List<DesignsubcontractnodedetailVO> designsubcontractnodedetailVOList = BeanMapper.mapList(list, DesignsubcontractnodedetailVO.class);
        if (designsubcontractnodedetailVOList != null && designsubcontractnodedetailVOList.size() > 0) {
            for (int i = 0; i < designsubcontractnodedetailVOList.size(); i++) {
                DesignsubcontractnodedetailVO designsubcontractnodedetailVO = designsubcontractnodedetailVOList.get(i);
                designsubcontractnodedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", designsubcontractnodedetailVOList);
        ExcelExport.getInstance().export("designsubcontractnode-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDesignsubcontractnodeFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<DesignsubcontractnodedetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                DesignsubcontractnodedetailVO designsubcontractnodedetailVO = list.get(i);
                designsubcontractnodedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designsubcontractnode-export.xlsx", beans, response);
    }


}
