package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleaseEntity;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("mechanicalleaseExport")
public class ExcelmechanicalleaseController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMechanicalleaseService service;

    @Autowired
    private IMechanicalleasedetailService detailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMechanicalleasedetail",method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "mechanicalleaseDetail-import.xlsx", "月度机械设备租赁单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelMechanicallease", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportMechanicallease(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MechanicalleasedetailVO> successList = new ArrayList<>();
        List<MechanicalleasedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            QueryWrapper<MechanicalleasedetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_state",3);
            List<MechanicalleasedetailEntity> list = detailService.list(wrapper);
            if(CollectionUtil.isEmpty(list)){
                throw new RuntimeException("暂无审批通过的数据");
            }

            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    MechanicalleasedetailVO mechanicalleasedetailVO = new MechanicalleasedetailVO();
                    List<String> datas = result.get(i);
                    mechanicalleasedetailVO.setId(IdWorker.getId());//id
                    mechanicalleasedetailVO.setSort(StringUtils.isNotEmpty(datas.get(0)) ? datas.get(0) : null);// 序号
                    mechanicalleasedetailVO.setBillCode(StringUtils.isNotEmpty(datas.get(1)) ? datas.get(1) : null);// 单据编号
                    mechanicalleasedetailVO.setName(StringUtils.isNotEmpty(datas.get(2)) ? datas.get(2) : null);// 租赁物资名称
                    mechanicalleasedetailVO.setSpec(StringUtils.isNotEmpty(datas.get(3)) ? datas.get(3) : null); // 规格型号
                    mechanicalleasedetailVO.setMeasuringUnit(StringUtils.isNotEmpty(datas.get(4)) ? datas.get(4) : null);// 计量单位
                    mechanicalleasedetailVO.setLeaseNum(StringUtils.isNotEmpty(datas.get(5)) ? new BigDecimal(datas.get(5)) : null);// 租赁数量
                    mechanicalleasedetailVO.setBillingStartTime(StringUtils.isNotEmpty(datas.get(6)) ? DateUtils.Date(datas.get(6)) : null);// 本期计算起始日期
                    mechanicalleasedetailVO.setBillingEndTime(StringUtils.isNotEmpty(datas.get(7)) ? DateUtils.Date(datas.get(7)) : null);// 本期计算终止日期
                    mechanicalleasedetailVO.setLeaseDaysThisTime(StringUtils.isNotEmpty(datas.get(8)) ? Integer.valueOf(datas.get(8)) : null); // 本期租赁期长（天）
                    mechanicalleasedetailVO.setLoseDestroyNum(StringUtils.isNotEmpty(datas.get(9)) ?  Integer.valueOf(datas.get(9)) : null);// 丢失损坏量
                    mechanicalleasedetailVO.setInTaxLeaseUnit(StringUtils.isNotEmpty(datas.get(10)) ? new BigDecimal(datas.get(10)) : null);// 租赁单价（含税）（元）
                    mechanicalleasedetailVO.setExTaxLeaseUnit(StringUtils.isNotEmpty(datas.get(11)) ? new BigDecimal(datas.get(11)) : null); // 租赁单价（除税）（元）
                    mechanicalleasedetailVO.setInTaxLeaseTotal(StringUtils.isNotEmpty(datas.get(12)) ? new BigDecimal(datas.get(12)) : null);// 租赁合价（含税）（元）
                    mechanicalleasedetailVO.setExTaxLeaseTotal(StringUtils.isNotEmpty(datas.get(13)) ? new BigDecimal(datas.get(13)) : null);// 租赁合价（除税）（元）
                    mechanicalleasedetailVO.setInTaxCompensationUnit(StringUtils.isNotEmpty(datas.get(14)) ? new BigDecimal(datas.get(14)) : null);// 赔偿单价（含税）（元）
                    mechanicalleasedetailVO.setExTaxCompensationUnit(StringUtils.isNotEmpty(datas.get(15)) ? new BigDecimal(datas.get(15)) : null); // 赔偿单价（除税）（元）
                    mechanicalleasedetailVO.setInTaxCompensationTotal(StringUtils.isNotEmpty(datas.get(16)) ? new BigDecimal(datas.get(16)) : null); // 赔偿合价（含税）（元）
                    mechanicalleasedetailVO.setExTaxCompensationTotal(StringUtils.isNotEmpty(datas.get(17)) ? new BigDecimal(datas.get(17)) : null);// 赔偿合价（除税）（元）
                    mechanicalleasedetailVO.setInTaxMaintain(StringUtils.isNotEmpty(datas.get(18)) ? new BigDecimal(datas.get(18)) : null); // 清理维修费等其他费用（含税）（元）
                    mechanicalleasedetailVO.setExTaxMaintain(StringUtils.isNotEmpty(datas.get(19)) ? new BigDecimal(datas.get(19)) : null);// 清理维修费等其他费用（除税）（元）
                    mechanicalleasedetailVO.setInTaxSettlementMonth(StringUtils.isNotEmpty(datas.get(20)) ? new BigDecimal(datas.get(20)) : null); // 月度结算费用（含税）（元）
                    mechanicalleasedetailVO.setExTaxSettlementMonth(StringUtils.isNotEmpty(datas.get(21)) ? new BigDecimal(datas.get(21)) : null);// 月度结算费用（除税）（元）
                    mechanicalleasedetailVO.setExTaxCumulative(StringUtils.isNotEmpty(datas.get(22)) ? new BigDecimal(datas.get(22)) : null);// 累计结算金额(除税)
                    mechanicalleasedetailVO.setInTaxCumulative(StringUtils.isNotEmpty(datas.get(23)) ? new BigDecimal(datas.get(23)) : null);// 累计结算金额(含税)
                    mechanicalleasedetailVO.setRemarks(StringUtils.isNotEmpty(datas.get(24)) ? datas.get(24) : null);// 备注

                    successList.add(mechanicalleasedetailVO);
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMechanicalleaseFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMechanicalleaseFromDatabase(@RequestBody MechanicalleasedetailVO detailVo, HttpServletResponse response) {
        QueryWrapper<MechanicalleaseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<MechanicalleaseEntity> list = service.list(queryWrapper);
        List<MechanicalleasedetailVO> mechanicalleasedetailVOList = BeanMapper.mapList(list, MechanicalleasedetailVO.class);
        if (mechanicalleasedetailVOList != null && mechanicalleasedetailVOList.size() > 0) {
            for (int i = 0; i < mechanicalleasedetailVOList.size(); i++) {
                MechanicalleasedetailVO mechanicalleasedetailVO = mechanicalleasedetailVOList.get(i);
                mechanicalleasedetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetailVO.getBillingStartTime()!= null) {
                    mechanicalleasedetailVO.setBillingStartTime(mechanicalleasedetailVO.getBillingStartTime());
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>(16);
        beans.put("records", mechanicalleasedetailVOList);
        ExcelExport.getInstance().export("mechanicalleasdetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMechanicalleasedetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMechanicalleasedetailFromPage(@RequestBody List<MechanicalleasedetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                MechanicalleasedetailVO mechanicalleasedetailVO = list.get(i);
                mechanicalleasedetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetailVO.getBillingEndTime() != null) {
                    mechanicalleasedetailVO.setBillingEndTime(DateUtil.date(mechanicalleasedetailVO.getBillingEndTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>(16);
        beans.put("records", list);
        ExcelExport.getInstance().export("mechanicalleasedetail-export.xlsx", beans, response);
    }

}
