package com.ejianc.business.middlemeasurement.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.vo.CapitalinflowsVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.CapitalinflowsMapper;
import com.ejianc.business.middlemeasurement.bean.CapitalinflowsEntity;
import com.ejianc.business.middlemeasurement.service.ICapitalinflowsService;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 资金流入
 *
 * @author generator
 */
@Service("capitalinflowsService")
public class CapitalinflowsServiceImpl extends BaseServiceImpl<CapitalinflowsMapper, CapitalinflowsEntity> implements ICapitalinflowsService {

    //日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ICapitalinflowsService service;

    @Autowired
    private RestHighLevelClient client;


    private final static String ESSignStatistic = "ejc_capotalinflows_report";


    @Override
    public CommonResponse<String> saveSnapshotData() {
        String curDate = this.getLastMonth();
        //资金流入报表统计
        new Thread(() -> {
            try {
                service.saveESData("资金流入报表" + curDate);
            } catch (Exception e) {
                logger.error("资金流入报表数据异常，", e);
            }
        }).start();

        return CommonResponse.success("保存快照成功");
    }

    @Override
    public CommonResponse<String> saveESData(String reportName) {

        //获取当前mysql数据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<CapitalinflowsEntity> list = service.queryList(queryParam);

        //构建es请求
        BulkRequest bulkRequest = new BulkRequest();
        for (CapitalinflowsEntity entity : list) {
            try {
                CapitalinflowsVO vo = BeanMapper.map(entity, CapitalinflowsVO.class);
                Map<String, Object> dataMap = BeanMapper.map(vo, Map.class);
                dataMap.put("reportId", entity.getId().toString());
                dataMap.put("snapShotTime", new Date());
                dataMap.put("snapShotVersion", IdWorker.getId());
                IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            } catch (Exception e) {
                logger.error("生成资金流入统计数据异常，", e);
                throw new BusinessException("生成资金流入统计数据异常");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            client.bulk(bulkRequest, RequestOptions.DEFAULT);
        } catch (IOException e) {
            logger.info("生成ES数据失败:---->" + e.getMessage());
            throw new BusinessException("生成ES数据失败:---->" + e.getMessage());
        }

        logger.info("***********生成资金流入统计执行 完事 *********** ");
        return CommonResponse.success("生成资金流入统计成功");
    }

    @Override
    public IPage<CapitalinflowsVO> queryEsByPage(QueryParam param) {

        // 搜索请求对象
        SearchRequest searchRequest = new SearchRequest(ESSignStatistic);
        // 指定类型
        searchRequest.searchType(SearchType.DFS_QUERY_THEN_FETCH);

        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(60, TimeUnit.SECONDS)); //设置超时时间
        sourceBuilder.sort("snapShotTime", SortOrder.ASC); // 第二排序规则
        List<String> fields = param.getFuzzyFields();
        if (fields.size() > 0 && fields != null) {
            for (String field : fields) {
                sourceBuilder.query(QueryBuilders.matchQuery("reportId", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("snapShotTime", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("snapShotVersion",param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("contractName", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("billCode", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("billState", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("projectId", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("projectName", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("orgId", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("orgName", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("projectDepartmentId", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("deadline", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("operationalTotal", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("receivedPayment", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("financing", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("total", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("dr", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("createUserCode", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("createTime", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("updateUserCode", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("updateTime", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("tenantId", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("syncEsFlag", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("rowState", param.getSearchText()));
                sourceBuilder.query(QueryBuilders.matchPhrasePrefixQuery("version", param.getSearchText()));

            }
            // 向搜索请求对象中设置搜索源
            searchRequest.source(sourceBuilder);
        } else {
            sourceBuilder.query(QueryBuilders.matchAllQuery());
            // 向搜索请求对象中设置搜索源
            searchRequest.source(sourceBuilder);
        }
        try {
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            // 搜索结果
            SearchHits hits = searchResponse.getHits();
            Integer count = 0;
            Integer idCount = 1;
            // 得到匹配度高的文档
            SearchHit[] searchHits = hits.getHits();
            if (searchHits.length <= 0) {
                return null;
            }
            Page<CapitalinflowsVO> voPage = new Page<>();
            ArrayList<CapitalinflowsVO> list = new ArrayList<>();
            for (SearchHit hit : searchHits) {
                idCount++;
                JSONObject json = new JSONObject(hit.getSourceAsMap());
                CapitalinflowsVO vo = JSONObject.toJavaObject(json, CapitalinflowsVO.class);
                vo.setId(Long.valueOf(idCount));
                if (vo.getSnapShotTime() != null) {
                    vo.setSnapShotTime(DateUtil.date(vo.getSnapShotTime()));
                }
                list.add(vo);
                count++;
            }
            voPage.setTotal(count);
            voPage.setSize(pageSize);
            voPage.setPages(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
            return voPage.setRecords(list);
        } catch (IOException e) {
            throw new RuntimeException("ES查询异常" + e);
        }

    }

    @Override
    public List<String> queryEsSnap() {
        // 搜索请求对象
        SearchRequest searchRequest = new SearchRequest(ESSignStatistic);
        // 指定类型
        searchRequest.searchType(SearchType.DFS_QUERY_THEN_FETCH);

        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query(QueryBuilders.matchAllQuery());
        sourceBuilder.fetchSource(new String[]{"snapShotVersion"}, new String[]{});
        // 向搜索请求对象中设置搜索源
        searchRequest.source(sourceBuilder);
        // 执行搜索,向ES发起http请求
        SearchResponse searchResponse = null;
        ArrayList<String> list = new ArrayList<>();
        try {
            searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            SearchHit[] searchHits = hits.getHits();
            for (SearchHit hit : searchHits) {
                // 源文档内容
                Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                String versionName = (String) sourceAsMap.get("snapShotVersion");
                list.add(hit.getId());
                list.add(versionName);
            }
        } catch (IOException e) {
            throw new RuntimeException("ES查询失败" + e);
        }
        // 搜索结果
        return list;
    }

    //获取上一个月字符串
    public String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date); // 设置为当前时间
        calendar.set(Calendar.MONTH, calendar.get(Calendar.MONTH) - 1); // 设置为上一个月
        date = calendar.getTime();
        String accDate = format.format(date);
        return accDate;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }
}
