package com.ejianc.business.middlemeasurement.service.impl;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumemdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeodetailEntity;
import com.ejianc.business.middlemeasurement.mapper.SubcontractingvolumeMapper;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumeService;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.vo.SubcontractaccountPullVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import cn.hutool.core.collection.CollectionUtil;

/**
 * 分包月度报量及申请报告
 * 
 * @author generator
 * 
 */
@Service("subcontractingvolumeService")
public class SubcontractingvolumeServiceImpl
		extends BaseServiceImpl<SubcontractingvolumeMapper, SubcontractingvolumeEntity>
		implements ISubcontractingvolumeService {
	/**
	 * 新增和更新数据校验
	 */
	private void verificate(SubcontractingvolumeEntity entity) {
		// 1.校验（同一合同，如有未审批通过的单据，不允许新增）
		if (entity.getId() == null || entity.getId() == 0) {// 新增校验
			QueryWrapper<SubcontractingvolumeEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("contract_id", entity.getContractId());
			queryWrapper.notIn("bill_state", 1, 3);// 1直审的已提交 3审批通过 ne（不等于） notIn
			List<SubcontractingvolumeEntity> pro = this.list(queryWrapper);
			if (pro != null && pro.size() > 0) {
				throw new BusinessException("同一合同只能存在一份自由态、审批中、审批驳回的\"分包月度报量及申请报告\"!");
			}
		}

	}

	@Autowired
	private IOrgApi iOrgApi;
	@Autowired
	private ISubcontractingvolumedetailService subcontractingvolumedetailService;
	@Autowired
	private IOutcontractApi outcontractApi;

	private void setDefaultValue(SubcontractingvolumedetailEntity entity) {
		if (entity.getQuantity() == null) {
			entity.setQuantity(new BigDecimal(0.0));
		}
		if (entity.getCumulativeQuantity() == null) {
			entity.setCumulativeQuantity(new BigDecimal(0.0));
		}
		if (entity.getCumulativeAmounts() == null) {
			entity.setCumulativeAmounts(new BigDecimal(0.0));
		}
		if (entity.getCumulativeTaxAmounts() == null) {
			entity.setCumulativeTaxAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineQuantity() == null) {
			entity.setExamineQuantity(new BigDecimal(0.0));
		}
		if (entity.getExamineAmounts() == null) {
			entity.setExamineAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineTaxAmounts() == null) {
			entity.setExamineTaxAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineCumulativeQuantity() == null) {
			entity.setExamineCumulativeQuantity(new BigDecimal(0.0));
		}
		if (entity.getExamineCumulativeAmounts() == null) {
			entity.setExamineCumulativeAmounts(new BigDecimal(0.0));
		}
		if (entity.getExamineCumulativeTaxAmounts() == null) {
			entity.setExamineCumulativeTaxAmounts(new BigDecimal(0.0));
		}
		BigDecimal cumulativeQuantity = new BigDecimal(0.0);
		BigDecimal cumulativeAmounts = new BigDecimal(0.0);
		BigDecimal cumulativeTaxAmounts = new BigDecimal(0.0);
		BigDecimal examineCumulativeQuantity = new BigDecimal(0.0);
		BigDecimal examineCumulativeAmounts = new BigDecimal(0.0);
		BigDecimal examineCumulativeTaxAmounts = new BigDecimal(0.0);
		QueryWrapper<SubcontractingvolumedetailEntity> queryWrapper = new QueryWrapper();
		queryWrapper.eq("dr", 0);
		queryWrapper.eq("bill_code", entity.getBillCode());
		List<SubcontractingvolumedetailEntity> list = subcontractingvolumedetailService.list(queryWrapper);
		if (!CollectionUtil.isEmpty(list)) {
			for (SubcontractingvolumedetailEntity subc : list) {
				cumulativeQuantity = cumulativeQuantity.add(subc.getQuantity());
				cumulativeAmounts = cumulativeAmounts.add(subc.getAmounts());
				cumulativeTaxAmounts = cumulativeTaxAmounts.add(subc.getTaxAmounts());
				examineCumulativeQuantity = examineCumulativeQuantity.add(subc.getExamineQuantity());
				examineCumulativeAmounts = examineCumulativeAmounts.add(subc.getExamineAmounts());
				examineCumulativeTaxAmounts = examineCumulativeTaxAmounts.add(subc.getExamineTaxAmounts());
			}
		}
		if (entity.getId() != null && entity.getId() > 0) {// 更新
			SubcontractingvolumedetailEntity oldEntity = subcontractingvolumedetailService.getById(entity.getId());
			cumulativeQuantity = oldEntity.getCumulativeQuantity().add(oldEntity.getQuantity().negate())
					.add(entity.getQuantity());
			cumulativeAmounts = oldEntity.getCumulativeAmounts().add(oldEntity.getAmounts().negate())
					.add(entity.getAmounts());
			cumulativeTaxAmounts = oldEntity.getCumulativeTaxAmounts().add(oldEntity.getTaxAmounts().negate())
					.add(entity.getTaxAmounts());

			examineCumulativeQuantity = oldEntity.getExamineCumulativeQuantity()
					.add(oldEntity.getExamineQuantity().negate()).add(entity.getExamineQuantity());
			examineCumulativeAmounts = oldEntity.getExamineCumulativeAmounts()
					.add(oldEntity.getExamineAmounts().negate()).add(entity.getExamineAmounts());
			examineCumulativeTaxAmounts = oldEntity.getExamineCumulativeTaxAmounts()
					.add(oldEntity.getExamineTaxAmounts().negate()).add(entity.getExamineTaxAmounts());
		} else {// 新增
			cumulativeQuantity = cumulativeQuantity.add(entity.getQuantity());
			cumulativeAmounts = cumulativeAmounts.add(entity.getAmounts());
			cumulativeTaxAmounts = cumulativeTaxAmounts.add(entity.getTaxAmounts());
			examineCumulativeQuantity = examineCumulativeQuantity.add(entity.getExamineQuantity());
			examineCumulativeAmounts = examineCumulativeAmounts.add(entity.getExamineAmounts());
			examineCumulativeTaxAmounts = examineCumulativeTaxAmounts.add(entity.getExamineTaxAmounts());
		}
		entity.setCumulativeQuantity(cumulativeQuantity);
		entity.setCumulativeAmounts(cumulativeAmounts);
		entity.setCumulativeTaxAmounts(cumulativeTaxAmounts);
		entity.setExamineCumulativeQuantity(examineCumulativeQuantity);
		entity.setExamineCumulativeAmounts(examineCumulativeAmounts);
		entity.setExamineCumulativeTaxAmounts(examineCumulativeTaxAmounts);
	}

	/**
	 * 新增赋默认值
	 * 
	 * @param entity
	 */
	private void setDefaultValue(SubcontractingvolumeEntity entity) {
		BigDecimal cumulativeFarmersWages = new BigDecimal(0.0);
		BigDecimal taxCumulativeTotal = new BigDecimal(0.0);
		BigDecimal taxCumulativeContract = new BigDecimal(0.0);
		BigDecimal taxCumulativeContractout = new BigDecimal(0.0);

		BigDecimal cumulativeContract = new BigDecimal(0.0);
		BigDecimal cumulativeContractout = new BigDecimal(0.0);
		if (entity.getTaxCurrentContract() == null) {
			entity.setTaxCurrentContract(new BigDecimal(0.0));
		}
		if (entity.getTaxCurrentTotal() == null) {
			entity.setTaxCurrentTotal(new BigDecimal(0.0));
		}
		if (entity.getTaxCurrentContractout() == null) {
			entity.setTaxCurrentContractout(new BigDecimal(0.0));
		}
		if (entity.getCurrentContract() == null) {
			entity.setCurrentContract(new BigDecimal(0.0));
		}
		if (entity.getCurrentContractout() == null) {
			entity.setCurrentContractout(new BigDecimal(0.0));
		}
		// 先查一下是不是数据来源是不是能和合同匹配上
		for (SubcontractingvolumedetailEntity row : entity.getSubcontractingvolumedetailEntities()) {
			CommonResponse<List<OutcontractSubcontractUnitPriceVO>> result = outcontractApi
					.queryListBycontractIdAndCode(entity.getContractId(), row.getBillCode());
			if (result != null && result.isSuccess()) {
				if (result.getData().size() > 0) {
					row.setSource(1);
				} else {
					row.setSource(2);
				}
			}
		}

		BigDecimal taxCurrentTotal = new BigDecimal(0.0);
		BigDecimal taxDeductionAmount = new BigDecimal(0.0);
		BigDecimal taxCurrentContract = new BigDecimal(0.0);
		BigDecimal taxCurrentContractout = new BigDecimal(0.0);
		BigDecimal currentTotal = new BigDecimal(0.0);
		BigDecimal currentContract = new BigDecimal(0.0);
		BigDecimal currentContractout = new BigDecimal(0.0);
		for (SubcontractingvolumedetailEntity row : entity.getSubcontractingvolumedetailEntities()) {
			if (row.getExamineTaxAmounts() != null) {
				taxCurrentTotal = taxCurrentTotal.add(row.getExamineTaxAmounts());
			}
			if (row.getExamineAmounts() != null) {
				currentTotal = currentTotal.add(row.getExamineAmounts());
			}
			if (row.getSource() == 1) {
				taxCurrentContract = taxCurrentContract.add(row.getExamineTaxAmounts());
				currentContract = currentContract.add(row.getExamineAmounts());
			}
			if (row.getSource() == 2) {
				taxCurrentContractout = taxCurrentContractout.add(row.getExamineTaxAmounts());
				currentContractout = currentContractout.add(row.getExamineAmounts());
			}
		}
		for (SubcontractingvolumemdetailEntity row : entity.getSubcontractingvolumemdetailEntities()) {
			if (row.getOverdraftDeduction() != null) {
				taxDeductionAmount = taxDeductionAmount.add(row.getOverdraftDeduction());
				taxCurrentTotal = taxCurrentTotal.add(row.getOverdraftDeduction().negate());
				currentTotal = currentTotal.add(row.getOverdraftDeduction().negate());
			}
		}
		for (SubcontractingvolumeodetailEntity row : entity.getSubcontractingvolumeodetailEntities()) {
			if (row.getAmounts() != null) {
				taxDeductionAmount = taxDeductionAmount.add(row.getAmounts());
				taxCurrentTotal = taxCurrentTotal.add(row.getAmounts().negate());
				currentTotal = currentTotal.add(row.getAmounts().negate());
			}
		}
		entity.setTaxCurrentTotal(taxCurrentTotal);
		entity.setTaxDeductionAmount(taxDeductionAmount);
		entity.setTaxCurrentContract(taxCurrentContract);
		entity.setTaxCurrentContractout(taxCurrentContractout);
		entity.setCurrentTotal(currentTotal);
		entity.setCurrentContract(currentContract);
		entity.setCurrentContractout(currentContractout);

		if (entity.getId() != null && entity.getId() > 0) {// 更新

			SubcontractingvolumeEntity oldEntity = this.getById(entity.getId());
			cumulativeFarmersWages = oldEntity.getCumulativeFarmersWages().add(oldEntity.getFarmersWages().negate())
					.add(entity.getFarmersWages());
			taxCumulativeTotal = oldEntity.getTaxCumulativeTotal().add(oldEntity.getTaxCurrentTotal().negate())
					.add(entity.getTaxCurrentTotal());

			taxCumulativeContract = oldEntity.getTaxCumulativeContract().add(oldEntity.getTaxCurrentContract().negate())
					.add(entity.getTaxCurrentContract());
			taxCumulativeContractout = oldEntity.getTaxCumulativeContractout()
					.add(oldEntity.getTaxCurrentContractout().negate()).add(entity.getTaxCurrentContractout());

			cumulativeContract = oldEntity.getCumulativeContract().add(oldEntity.getCurrentContract().negate())
					.add(entity.getCurrentContract());
			cumulativeContractout = oldEntity.getCumulativeContractout().add(oldEntity.getCurrentContractout().negate())
					.add(entity.getCurrentContractout());
		} else {
			entity.setOrgId(InvocationInfoProxy.getOrgId());
			entity.setOrgName(iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData().getName());
			if (entity.getFarmersWages() == null) {
				entity.setFarmersWages(new BigDecimal(0.0));
			}
			if (entity.getCumulativeFarmersWages() == null) {
				entity.setCumulativeFarmersWages(new BigDecimal(0.0));
			}
			QueryWrapper queryWrapper = new QueryWrapper();
			queryWrapper.eq("contract_id", entity.getContractId());
			List<SubcontractingvolumeEntity> list = this.list(queryWrapper);
			if (!CollectionUtil.isEmpty(list)) {
				for (SubcontractingvolumeEntity subc : list) {
					cumulativeFarmersWages = cumulativeFarmersWages.add(subc.getFarmersWages());
					taxCumulativeTotal = taxCumulativeTotal.add(subc.getTaxCurrentTotal());

					taxCumulativeContract = taxCumulativeContract.add(subc.getTaxCurrentContract());
					taxCumulativeContractout = taxCumulativeContractout.add(subc.getTaxCurrentContractout());

					cumulativeContract = cumulativeContract.add(subc.getCurrentContract());
					cumulativeContractout = cumulativeContractout.add(subc.getCurrentContractout());
				}
			}
			cumulativeFarmersWages = cumulativeFarmersWages.add(entity.getFarmersWages());
			taxCumulativeTotal = taxCumulativeTotal.add(entity.getTaxCurrentTotal());
			taxCumulativeContract = taxCumulativeContract.add(entity.getTaxCurrentContract());
			taxCumulativeContractout = taxCumulativeContractout.add(entity.getTaxCurrentContractout());

			cumulativeContract = cumulativeContract.add(entity.getCurrentContract());
			cumulativeContractout = cumulativeContractout.add(entity.getCurrentContractout());
		}
		entity.setCumulativeFarmersWages(cumulativeFarmersWages);
		entity.setTaxCumulativeTotal(taxCumulativeTotal);
		entity.setTaxCumulativeContract(taxCumulativeContract);
		entity.setTaxCumulativeContractout(taxCumulativeContractout);
		entity.setCumulativeContract(cumulativeContract);
		entity.setCumulativeContractout(cumulativeContractout);
		for (SubcontractingvolumedetailEntity line : entity.getSubcontractingvolumedetailEntities()) {
			this.setDefaultValue(line);
		}
	}

	@Transactional
	@Override
	public boolean saveOrUpdate(SubcontractingvolumeEntity entity, boolean syncEs) {
		setDefaultValue(entity);
		verificate(entity);
		return super.saveOrUpdate(entity, syncEs);

	}

	@Override
	public SubcontractaccountPullVO getSubcontractaccountAmount(Long contractId) {
		return this.baseMapper.getSubcontractaccountAmount(contractId);
	}
}
