package com.ejianc.business.middlemeasurement.vo;

import java.util.List;
import java.util.ArrayList;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 月度机械设备租赁单
 *
 * @author generator
 */
public class MechanicalleaseVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.Long contractId; // 合同
    private java.lang.String contractName; // 合同名称
    private java.lang.Long supplierId; // 租赁商
    private java.lang.String supplierName; // 租赁商名称
    private java.math.BigDecimal exTaxSettlement; // 结算金额（除税）
    private java.math.BigDecimal inTaxSettlement; // 结算金额（含税）
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date settlementTime; // 结算时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billingStartTime; // 计费起始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billingEndTime; // 计费截止时间
    private java.math.BigDecimal exTaxThisMonthTotal; // 本月合计(除税)
    private java.math.BigDecimal inTaxThisMonthTotal; // 本月合计(含税)
    private java.math.BigDecimal exTaxCumulative; // 累计发生(除税)
    private java.math.BigDecimal inTaxCumulative; // 累计发生(含税)
    private java.lang.String projectCode;//项目编码

    private java.lang.String sort;
    private java.lang.String billStateStr;

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    private List<MechanicalleasedetailVO> mechanicalleasedetailEntities = new ArrayList<>(); // 月度机械设备租赁单子表

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }

    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }

    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }

    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }

    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }

    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    /**
     * 租赁商名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 租赁商名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }

    /**
     * 结算金额（除税）
     */
    public java.math.BigDecimal getExTaxSettlement() {
        return exTaxSettlement;
    }

    /**
     * 结算金额（除税）
     */
    public void setExTaxSettlement(java.math.BigDecimal exTaxSettlement) {
        this.exTaxSettlement = exTaxSettlement;
    }

    /**
     * 结算金额（含税）
     */
    public java.math.BigDecimal getInTaxSettlement() {
        return inTaxSettlement;
    }

    /**
     * 结算金额（含税）
     */
    public void setInTaxSettlement(java.math.BigDecimal inTaxSettlement) {
        this.inTaxSettlement = inTaxSettlement;
    }

    /**
     * 结算时间
     */
    public java.util.Date getSettlementTime() {
        return settlementTime;
    }

    /**
     * 结算时间
     */
    public void setSettlementTime(java.util.Date settlementTime) {
        this.settlementTime = settlementTime;
    }

    /**
     * 计费起始时间
     */
    public java.util.Date getBillingStartTime() {
        return billingStartTime;
    }

    /**
     * 计费起始时间
     */
    public void setBillingStartTime(java.util.Date billingStartTime) {
        this.billingStartTime = billingStartTime;
    }

    /**
     * 计费截止时间
     */
    public java.util.Date getBillingEndTime() {
        return billingEndTime;
    }

    /**
     * 计费截止时间
     */
    public void setBillingEndTime(java.util.Date billingEndTime) {
        this.billingEndTime = billingEndTime;
    }

    /**
     * 本月合计(除税)
     */
    public java.math.BigDecimal getExTaxThisMonthTotal() {
        return exTaxThisMonthTotal;
    }

    /**
     * 本月合计(除税)
     */
    public void setExTaxThisMonthTotal(java.math.BigDecimal exTaxThisMonthTotal) {
        this.exTaxThisMonthTotal = exTaxThisMonthTotal;
    }

    /**
     * 本月合计(含税)
     */
    public java.math.BigDecimal getInTaxThisMonthTotal() {
        return inTaxThisMonthTotal;
    }

    /**
     * 本月合计(含税)
     */
    public void setInTaxThisMonthTotal(java.math.BigDecimal inTaxThisMonthTotal) {
        this.inTaxThisMonthTotal = inTaxThisMonthTotal;
    }

    /**
     * 累计发生(除税)
     */
    public java.math.BigDecimal getExTaxCumulative() {
        return exTaxCumulative;
    }

    /**
     * 累计发生(除税)
     */
    public void setExTaxCumulative(java.math.BigDecimal exTaxCumulative) {
        this.exTaxCumulative = exTaxCumulative;
    }

    /**
     * 累计发生(含税)
     */
    public java.math.BigDecimal getInTaxCumulative() {
        return inTaxCumulative;
    }

    /**
     * 累计发生(含税)
     */
    public void setInTaxCumulative(java.math.BigDecimal inTaxCumulative) {
        this.inTaxCumulative = inTaxCumulative;
    }

    /**
     * 月度机械设备租赁单子表
     */
    public List<MechanicalleasedetailVO> getMechanicalleasedetailEntities() {
        return mechanicalleasedetailEntities;
    }

    /**
     * 月度机械设备租赁单子表
     */
    public void setMechanicalleasedetailEntities(List<MechanicalleasedetailVO> mechanicalleasedetailEntities) {
        this.mechanicalleasedetailEntities = mechanicalleasedetailEntities;
    }
}
