package com.ejianc.business.middlemeasurement.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.middlemeasurement.vo.PurchasesummarydetatilVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 月度物资采购结算汇总
 * 
 * @author generator
 * 
 */
public class PurchasesummaryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.String projectCode; // 项目编号
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date statisticalTime; // 统计时间
    private java.lang.String code; // 编号
    private java.math.BigDecimal settlementAmount; // 本月结算金额(除税)
    private java.math.BigDecimal taxSettlementAmount; // 本月结算金额(含税)
    private java.math.BigDecimal settlementTotal; // 累计结算金额汇总(除税)
    private java.math.BigDecimal taxSettlementTotal; // 累计结算金额汇总(含税)
    private java.math.BigDecimal cumulativePayable; // 本月累计应付款金额
    private java.math.BigDecimal cumulativePayment; // 本月累计付款金额
    private java.lang.String remarks; // 备注
    
    private List<PurchasesummarydetatilVO> purchasesummarydetatilEntities = new ArrayList<>(); // 月度物资采购结算汇总子表
    private List<String> referenceIdList = new ArrayList<>(); // 被引用的月度周采购结算单id集合

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 统计时间
     */
    public java.util.Date getStatisticalTime() {
        return statisticalTime;
    }

    /**
     * 统计时间
     */
    public void setStatisticalTime(java.util.Date statisticalTime) {
        this.statisticalTime = statisticalTime;
    }
    /**
     * 编号
     */
    public java.lang.String getCode() {
        return code;
    }

    /**
     * 编号
     */
    public void setCode(java.lang.String code) {
        this.code = code;
    }
    /**
     * 本月结算金额(除税)
     */
    public java.math.BigDecimal getSettlementAmount() {
        return settlementAmount;
    }

    /**
     * 本月结算金额(除税)
     */
    public void setSettlementAmount(java.math.BigDecimal settlementAmount) {
        this.settlementAmount = settlementAmount;
    }
    /**
     * 本月结算金额(含税)
     */
    public java.math.BigDecimal getTaxSettlementAmount() {
        return taxSettlementAmount;
    }

    /**
     * 本月结算金额(含税)
     */
    public void setTaxSettlementAmount(java.math.BigDecimal taxSettlementAmount) {
        this.taxSettlementAmount = taxSettlementAmount;
    }
    /**
     * 累计结算金额汇总(除税)
     */
    public java.math.BigDecimal getSettlementTotal() {
        return settlementTotal;
    }

    /**
     * 累计结算金额汇总(除税)
     */
    public void setSettlementTotal(java.math.BigDecimal settlementTotal) {
        this.settlementTotal = settlementTotal;
    }
    /**
     * 累计结算金额汇总(含税)
     */
    public java.math.BigDecimal getTaxSettlementTotal() {
        return taxSettlementTotal;
    }

    /**
     * 累计结算金额汇总(含税)
     */
    public void setTaxSettlementTotal(java.math.BigDecimal taxSettlementTotal) {
        this.taxSettlementTotal = taxSettlementTotal;
    }
    /**
     * 本月累计应付款金额
     */
    public java.math.BigDecimal getCumulativePayable() {
        return cumulativePayable;
    }

    /**
     * 本月累计应付款金额
     */
    public void setCumulativePayable(java.math.BigDecimal cumulativePayable) {
        this.cumulativePayable = cumulativePayable;
    }
    /**
     * 本月累计付款金额
     */
    public java.math.BigDecimal getCumulativePayment() {
        return cumulativePayment;
    }

    /**
     * 本月累计付款金额
     */
    public void setCumulativePayment(java.math.BigDecimal cumulativePayment) {
        this.cumulativePayment = cumulativePayment;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    
     /**
      * 月度物资采购结算汇总子表
      */
    public List<PurchasesummarydetatilVO> getPurchasesummarydetatilEntities() {
        return purchasesummarydetatilEntities;
    }
    /**
      * 月度物资采购结算汇总子表
      */
    public void setPurchasesummarydetatilEntities(List<PurchasesummarydetatilVO> purchasesummarydetatilEntities) {
        this.purchasesummarydetatilEntities = purchasesummarydetatilEntities;
    }

    public List<String> getReferenceIdList() {
        return referenceIdList;
    }

    public void setReferenceIdList(List<String> referenceIdList) {
        this.referenceIdList = referenceIdList;
    }
}
