package com.ejianc.business.middlemeasurement.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.middlemeasurement.vo.SubcontractvisadetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 分包经济签证月清确认单
 * 
 * @author generator
 * 
 */
public class SubcontractvisaVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.lang.String code; // 编号
    private java.lang.Long contractId; // 合同id
    private java.lang.String contractName; // 合同名称
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.String projectCode; // 项目编号
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date happenTime; // 发生时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date startTime; // 起始时间
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date endTime; // 截至时间
    private java.math.BigDecimal submittedValue; // 报送值(元)
    private java.math.BigDecimal visaAmount; // 签证金额(元)
    private java.math.BigDecimal visaOddjob; // 签证零工(元)
    private java.math.BigDecimal total; // 合计
    private java.lang.Long subcontractorId; // 分包方id
    private java.lang.String subcontractorName; // 分包方名称
    private java.lang.Integer totalVisas; // 共计发生签证(份)
    private java.lang.String remarks; // 备注
    private java.math.BigDecimal inCurrentAmount; // 本期签证金额(元)
    private java.math.BigDecimal inCumulativeAmount; // 累计签证金额(元)
    private java.math.BigDecimal inCurrentOddjob; // 本期签证零工(元)
    private java.math.BigDecimal inCumulativeOddjob; // 累计签证零工(元)
    private java.math.BigDecimal exCurrentAmount; // 本期签证金额(元)
    private java.math.BigDecimal exCumulativeAmount; // 累计签证金额(元)
    private java.math.BigDecimal exCurrentOddjob; // 本期签证零工(元)
    private java.math.BigDecimal exCumulativeOddjob; // 累计签证零工(元)
    private java.lang.String sort;
    private java.lang.String billStateStr;
    
    private List<SubcontractvisadetailVO> subcontractvisadetailEntities = new ArrayList<>(); // 分包经济签证月清确认子表

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 编号
     */
    public java.lang.String getCode() {
        return code;
    }

    /**
     * 编号
     */
    public void setCode(java.lang.String code) {
        this.code = code;
    }
    /**
     * 合同id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public java.lang.Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    @ReferDeserialTransfer
    public void setContractId(java.lang.Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */

    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 发生时间
     */
    public java.util.Date getHappenTime() {
        return happenTime;
    }

    /**
     * 发生时间
     */
    public void setHappenTime(java.util.Date happenTime) {
        this.happenTime = happenTime;
    }
    /**
     * 起始时间
     */
    public java.util.Date getStartTime() {
        return startTime;
    }

    /**
     * 起始时间
     */
    public void setStartTime(java.util.Date startTime) {
        this.startTime = startTime;
    }
    /**
     * 截至时间
     */
    public java.util.Date getEndTime() {
        return endTime;
    }

    /**
     * 截至时间
     */
    public void setEndTime(java.util.Date endTime) {
        this.endTime = endTime;
    }
    /**
     * 报送值(元)
     */
    public java.math.BigDecimal getSubmittedValue() {
        return submittedValue;
    }

    /**
     * 报送值(元)
     */
    public void setSubmittedValue(java.math.BigDecimal submittedValue) {
        this.submittedValue = submittedValue;
    }
    /**
     * 签证金额(元)
     */
    public java.math.BigDecimal getVisaAmount() {
        return visaAmount;
    }

    /**
     * 签证金额(元)
     */
    public void setVisaAmount(java.math.BigDecimal visaAmount) {
        this.visaAmount = visaAmount;
    }
    /**
     * 签证零工(元)
     */
    public java.math.BigDecimal getVisaOddjob() {
        return visaOddjob;
    }

    /**
     * 签证零工(元)
     */
    public void setVisaOddjob(java.math.BigDecimal visaOddjob) {
        this.visaOddjob = visaOddjob;
    }
    /**
     * 合计
     */
    public java.math.BigDecimal getTotal() {
        return total;
    }

    /**
     * 合计
     */
    public void setTotal(java.math.BigDecimal total) {
        this.total = total;
    }
    /**
     * 分包方id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-outcontract")
    public java.lang.Long getSubcontractorId() {
        return subcontractorId;
    }

    /**
     * 分包方id
     */
    @ReferDeserialTransfer
    public void setSubcontractorId(java.lang.Long subcontractorId) {
        this.subcontractorId = subcontractorId;
    }
    /**
     * 分包方名称
     */
    public java.lang.String getSubcontractorName() {
        return subcontractorName;
    }

    /**
     * 分包方名称
     */
    public void setSubcontractorName(java.lang.String subcontractorName) {
        this.subcontractorName = subcontractorName;
    }
    /**
     * 共计发生签证(份)
     */
    public java.lang.Integer getTotalVisas() {
        return totalVisas;
    }

    /**
     * 共计发生签证(份)
     */
    public void setTotalVisas(java.lang.Integer totalVisas) {
        this.totalVisas = totalVisas;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 本期签证金额(元)
     */
    public java.math.BigDecimal getInCurrentAmount() {
        return inCurrentAmount;
    }

    /**
     * 本期签证金额(元)
     */
    public void setInCurrentAmount(java.math.BigDecimal inCurrentAmount) {
        this.inCurrentAmount = inCurrentAmount;
    }
    /**
     * 累计签证金额(元)
     */
    public java.math.BigDecimal getInCumulativeAmount() {
        return inCumulativeAmount;
    }

    /**
     * 累计签证金额(元)
     */
    public void setInCumulativeAmount(java.math.BigDecimal inCumulativeAmount) {
        this.inCumulativeAmount = inCumulativeAmount;
    }
    /**
     * 本期签证零工(元)
     */
    public java.math.BigDecimal getInCurrentOddjob() {
        return inCurrentOddjob;
    }

    /**
     * 本期签证零工(元)
     */
    public void setInCurrentOddjob(java.math.BigDecimal inCurrentOddjob) {
        this.inCurrentOddjob = inCurrentOddjob;
    }
    /**
     * 累计签证零工(元)
     */
    public java.math.BigDecimal getInCumulativeOddjob() {
        return inCumulativeOddjob;
    }

    /**
     * 累计签证零工(元)
     */
    public void setInCumulativeOddjob(java.math.BigDecimal inCumulativeOddjob) {
        this.inCumulativeOddjob = inCumulativeOddjob;
    }
    /**
     * 本期签证金额(元)
     */
    public java.math.BigDecimal getExCurrentAmount() {
        return exCurrentAmount;
    }

    /**
     * 本期签证金额(元)
     */
    public void setExCurrentAmount(java.math.BigDecimal exCurrentAmount) {
        this.exCurrentAmount = exCurrentAmount;
    }
    /**
     * 累计签证金额(元)
     */
    public java.math.BigDecimal getExCumulativeAmount() {
        return exCumulativeAmount;
    }

    /**
     * 累计签证金额(元)
     */
    public void setExCumulativeAmount(java.math.BigDecimal exCumulativeAmount) {
        this.exCumulativeAmount = exCumulativeAmount;
    }
    /**
     * 本期签证零工(元)
     */
    public java.math.BigDecimal getExCurrentOddjob() {
        return exCurrentOddjob;
    }

    /**
     * 本期签证零工(元)
     */
    public void setExCurrentOddjob(java.math.BigDecimal exCurrentOddjob) {
        this.exCurrentOddjob = exCurrentOddjob;
    }
    /**
     * 累计签证零工(元)
     */
    public java.math.BigDecimal getExCumulativeOddjob() {
        return exCumulativeOddjob;
    }

    /**
     * 累计签证零工(元)
     */
    public void setExCumulativeOddjob(java.math.BigDecimal exCumulativeOddjob) {
        this.exCumulativeOddjob = exCumulativeOddjob;
    }
    
     /**
      * 分包经济签证月清确认子表
      */
    public List<SubcontractvisadetailVO> getSubcontractvisadetailEntities() {
        return subcontractvisadetailEntities;
    }

/**
      * 分包经济签证月清确认子表
      */
    public void setSubcontractvisadetailEntities(List<SubcontractvisadetailVO> subcontractvisadetailEntities) {
        this.subcontractvisadetailEntities = subcontractvisadetailEntities;
    }


}
