/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasesummaryEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasesummaryService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasesummaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"revolvingleasesummary"})
public class RevolvingleasesummaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IRevolvingleasesummaryService service;
    @Autowired
    private IRevolvingleaseService revolvingleaseService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RevolvingleasesummaryVO> saveOrUpdate(@RequestBody RevolvingleasesummaryVO saveorUpdateVO) {
        List<String> referenceIdList;
        RevolvingleasesummaryEntity entity = (RevolvingleasesummaryEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), RevolvingleasesummaryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
            queryWrapper.in((Object)"bill_state", new Object[]{0, 2, 4, 5});
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("\u540c\u4e00\u9879\u76ee\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u6708\u5ea6\u5468\u8f6c\u79df\u8d41\u7ed3\u7b97\u6c47\u603b\u5355\"!");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getId() != null) {
            QueryWrapper queryWrapperOld = new QueryWrapper();
            queryWrapperOld.in((Object)"reference_code", new Object[]{saveorUpdateVO.getBillCode()});
            List oldList = this.revolvingleaseService.list((Wrapper)queryWrapperOld);
            if (oldList != null && oldList.size() > 0) {
                for (RevolvingleaseEntity item : oldList) {
                    item.setIsReference(0);
                    item.setReferenceCode(null);
                }
                this.revolvingleaseService.saveOrUpdateBatch(oldList);
            }
        }
        if ((referenceIdList = saveorUpdateVO.getReferenceIdList()) != null && referenceIdList.size() > 0) {
            QueryWrapper queryWrapperByIdsNew = new QueryWrapper();
            queryWrapperByIdsNew.in((Object)"id", referenceIdList);
            List newList = this.revolvingleaseService.list((Wrapper)queryWrapperByIdsNew);
            if (newList != null && newList.size() > 0) {
                for (RevolvingleaseEntity item : newList) {
                    item.setIsReference(1);
                    item.setReferenceCode(saveorUpdateVO.getBillCode());
                }
                this.revolvingleaseService.saveOrUpdateBatch(newList);
            }
        }
        RevolvingleasesummaryVO vo = (RevolvingleasesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), RevolvingleasesummaryVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RevolvingleasesummaryVO> queryDetail(Long id) {
        RevolvingleasesummaryEntity entity = (RevolvingleasesummaryEntity)((Object)this.service.selectById(id));
        RevolvingleasesummaryVO vo = (RevolvingleasesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), RevolvingleasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RevolvingleasesummaryVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RevolvingleasesummaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RevolvingleasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List revolvingleasesummaryVOList = BeanMapper.mapList((Iterable)list, RevolvingleasesummaryVO.class);
        for (int i = 0; i < revolvingleasesummaryVOList.size(); ++i) {
            String billStateStr;
            RevolvingleasesummaryVO revolvingleasesummaryVO = (RevolvingleasesummaryVO)((Object)revolvingleasesummaryVOList.get(i));
            revolvingleasesummaryVO.setSort(String.valueOf(i + 1));
            if (revolvingleasesummaryVO.getStatisticalTime() != null) {
                revolvingleasesummaryVO.setStatisticalTimeShow(DateUtils.dateSimple2(revolvingleasesummaryVO.getStatisticalTime()));
            }
            if ((billStateStr = revolvingleasesummaryVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            revolvingleasesummaryVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", revolvingleasesummaryVOList);
        ExcelExport.getInstance().export("RevolvingleasesummaryMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRevolvingleasesummaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RevolvingleasesummaryVO>> refRevolvingleasesummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RevolvingleasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

