/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.SubcontractvisaEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractvisaService;
import com.ejianc.business.middlemeasurement.vo.SubcontractvisaVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subcontractvisa"})
public class SubcontractvisaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISubcontractvisaService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> saveOrUpdate(@RequestBody SubcontractvisaVO saveorUpdateVO) {
        SubcontractvisaEntity entity = (SubcontractvisaEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), SubcontractvisaEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
            queryWrapper.ne((Object)"bill_state", (Object)3);
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u7b7e\u8bc1\u7d22\u8d54\u53f0\u8d26\"!");
            }
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        QueryWrapper wrapper = new QueryWrapper();
        BigDecimal inCurrentAmount1 = entity.getInCurrentAmount();
        BigDecimal exCurrentAmount1 = entity.getExCurrentAmount();
        BigDecimal inCurrentOddjob1 = entity.getInCurrentOddjob();
        BigDecimal exCurrentOddjob1 = entity.getExCurrentOddjob();
        BigDecimal amount = BigDecimal.valueOf(0L);
        BigDecimal oddjob = BigDecimal.valueOf(0L);
        BigDecimal exAmount = BigDecimal.valueOf(0L);
        BigDecimal exOddjob = BigDecimal.valueOf(0L);
        wrapper.eq((Object)"contract_id", (Object)entity.getContractId());
        wrapper.eq((Object)"bill_state", (Object)3);
        List list = this.service.list((Wrapper)wrapper);
        if (list.size() > 0 && list != null) {
            for (int i = 0; i < list.size(); ++i) {
                SubcontractvisaEntity subcontractvisaEntity = (SubcontractvisaEntity)((Object)list.get(i));
                BigDecimal inCurrentAmount = subcontractvisaEntity.getInCurrentAmount();
                amount = amount.add(inCurrentAmount);
                BigDecimal inCurrentOddjob = subcontractvisaEntity.getInCurrentOddjob();
                oddjob = oddjob.add(inCurrentOddjob);
                BigDecimal exCurrentAmount = subcontractvisaEntity.getExCurrentAmount();
                exAmount = exAmount.add(exCurrentAmount);
                BigDecimal exCurrentOddjob = subcontractvisaEntity.getExCurrentOddjob();
                exOddjob = exOddjob.add(exCurrentOddjob);
            }
        }
        if (inCurrentAmount1 != null) {
            amount = amount.add(inCurrentAmount1);
            entity.setInCumulativeAmount(amount);
        }
        if (inCurrentOddjob1 != null) {
            oddjob = oddjob.add(inCurrentOddjob1);
            entity.setInCumulativeOddjob(oddjob);
        }
        if (exCurrentAmount1 != null) {
            exAmount = exAmount.add(exCurrentAmount1);
            entity.setExCumulativeAmount(exAmount);
        }
        if (exCurrentOddjob1 != null) {
            exOddjob = exOddjob.add(exCurrentOddjob1);
            entity.setExCumulativeOddjob(exOddjob);
        }
        BigDecimal total = new BigDecimal(0);
        if (saveorUpdateVO.getInCurrentAmount() != null) {
            total = saveorUpdateVO.getInCurrentAmount().add(saveorUpdateVO.getInCurrentOddjob());
        }
        entity.setTotal(total);
        this.service.saveOrUpdate((Object)entity, false);
        SubcontractvisaVO vo = (SubcontractvisaVO)((Object)BeanMapper.map((Object)((Object)entity), SubcontractvisaVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> queryDetail(Long id) {
        SubcontractvisaEntity entity = (SubcontractvisaEntity)((Object)this.service.selectById(id));
        SubcontractvisaVO vo = (SubcontractvisaVO)((Object)BeanMapper.map((Object)((Object)entity), SubcontractvisaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractvisaVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubcontractvisaVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractvisaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List subcontractvisaVOList = BeanMapper.mapList((Iterable)list, SubcontractvisaVO.class);
        for (int i = 0; i < list.size(); ++i) {
            String billStateStr;
            SubcontractvisaVO vo = (SubcontractvisaVO)((Object)subcontractvisaVOList.get(0));
            vo.setSort(String.valueOf(i + 1));
            if (vo.getHappenTime() != null) {
                vo.setHappenTime((Date)DateUtil.date((Date)vo.getHappenTime()));
            }
            if (vo.getStartTime() != null) {
                vo.setStartTime((Date)DateUtil.date((Date)vo.getStartTime()));
            }
            if (vo.getEndTime() != null) {
                vo.setEndTime((Date)DateUtil.date((Date)vo.getEndTime()));
            }
            if ((billStateStr = vo.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            vo.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", subcontractvisaVOList);
        ExcelExport.getInstance().export("subcontractvisa-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubcontractvisaData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubcontractvisaVO>> refSubcontractvisaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractvisaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

