/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"engineermeasurementExport"})
public class ExcelEngineermeasurementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IEngineermeasurementdetailService engineermeasurementdetailService;

    @RequestMapping(value={"/downloadEngineermeasurement"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadEngineermeasurement(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"engineermeasurementdetail-import.xlsx", (String)"\u5de5\u7a0b\u8ba1\u91cf\u53f0\u8d26\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportEngineermeasurement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportEngineermeasurement(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<EngineermeasurementdetailVO> successList = new ArrayList<EngineermeasurementdetailVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 3; i < result.size(); ++i) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = new EngineermeasurementdetailVO();
                List datas = (List)result.get(i);
                engineermeasurementdetailVO.setId(IdWorker.getId());
                engineermeasurementdetailVO.setImageProgress(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? String.valueOf(datas.get(1)) : null);
                engineermeasurementdetailVO.setIspecificDate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? DateUtils.Date((String)datas.get(2)) : null);
                engineermeasurementdetailVO.setCivilEngineering(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : null);
                engineermeasurementdetailVO.setInstall(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : null);
                engineermeasurementdetailVO.setTotal(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                engineermeasurementdetailVO.setActualCivilEngineering(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : null);
                engineermeasurementdetailVO.setActualInstall(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                engineermeasurementdetailVO.setActualTotal(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                engineermeasurementdetailVO.setFinancialIncome(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                engineermeasurementdetailVO.setActualCost(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                engineermeasurementdetailVO.setRightConfirmationRate(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                engineermeasurementdetailVO.setContractApprovalTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? DateUtils.Date((String)datas.get(12)) : null);
                engineermeasurementdetailVO.setActualReportingTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? DateUtils.Date((String)datas.get(13)) : null);
                engineermeasurementdetailVO.setActualApprovalTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) ? DateUtils.Date((String)datas.get(14)) : null);
                engineermeasurementdetailVO.setAmountAgreedReceivables(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) ? new BigDecimal((String)datas.get(15)) : null);
                engineermeasurementdetailVO.setAmountCollected(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16))) ? new BigDecimal((String)datas.get(16)) : null);
                engineermeasurementdetailVO.setAmongCivilEngineering(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(17))) ? new BigDecimal((String)datas.get(17)) : null);
                engineermeasurementdetailVO.setAmongInstall(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(18))) ? new BigDecimal((String)datas.get(18)) : null);
                engineermeasurementdetailVO.setAgreedCollectionTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(19))) ? DateUtils.Date((String)datas.get(19)) : null);
                engineermeasurementdetailVO.setActualCollectionTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(20))) ? DateUtils.Date((String)datas.get(20)) : null);
                engineermeasurementdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(21))) ? String.valueOf(datas.get(21)) : null);
                successList.add(engineermeasurementdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportEngineermeasurementFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEngineermeasurementFromDatabase(@RequestBody EngineermeasurementVO engineermeasurementVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)engineermeasurementVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.engineermeasurementdetailService.list((Wrapper)queryWrapper);
        List engineermeasurementdetailVOList = BeanMapper.mapList((Iterable)list, EngineermeasurementdetailVO.class);
        if (engineermeasurementdetailVOList != null && engineermeasurementdetailVOList.size() > 0) {
            for (int i = 0; i < engineermeasurementdetailVOList.size(); ++i) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = (EngineermeasurementdetailVO)((Object)engineermeasurementdetailVOList.get(i));
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() == null) continue;
                engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", engineermeasurementdetailVOList);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportEngineermeasurementFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportEngineermeasurementFromPage(@RequestBody List<EngineermeasurementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                EngineermeasurementdetailVO engineermeasurementdetailVO = list.get(i);
                engineermeasurementdetailVO.setSort(String.valueOf(i + 1));
                if (engineermeasurementdetailVO.getActualApprovalTime() != null) {
                    engineermeasurementdetailVO.setActualApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualApprovalTime()));
                }
                if (engineermeasurementdetailVO.getIspecificDate() != null) {
                    engineermeasurementdetailVO.setIspecificDateShow(DateUtils.dateSimple(engineermeasurementdetailVO.getIspecificDate()));
                }
                if (engineermeasurementdetailVO.getContractApprovalTime() != null) {
                    engineermeasurementdetailVO.setContractApprovalTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getContractApprovalTime()));
                }
                if (engineermeasurementdetailVO.getActualReportingTime() != null) {
                    engineermeasurementdetailVO.setActualReportingTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualReportingTime()));
                }
                if (engineermeasurementdetailVO.getAgreedCollectionTime() != null) {
                    engineermeasurementdetailVO.setAgreedCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getAgreedCollectionTime()));
                }
                if (engineermeasurementdetailVO.getActualCollectionTime() == null) continue;
                engineermeasurementdetailVO.setActualCollectionTimeShow(DateUtils.dateSimple(engineermeasurementdetailVO.getActualCollectionTime()));
            }
        }
        HashMap<String, List<EngineermeasurementdetailVO>> beans = new HashMap<String, List<EngineermeasurementdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("engineermeasurementdetail-export.xlsx", beans, response);
    }
}

