/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"purchasesettlementExport"})
public class ExcelPurchasesettlementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IPurchasesettlementdetailService purchasesettlementdetailService;

    @RequestMapping(value={"/downloadPurchasesettlement"})
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"purchasesettlementdetail-import.xlsx", (String)"\u6708\u5ea6\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportPurchasesettlement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PurchasesettlementdetailVO> successList = new ArrayList<PurchasesettlementdetailVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                PurchasesettlementdetailVO purchasesettlementdetailVO = new PurchasesettlementdetailVO();
                purchasesettlementdetailVO.setId(IdWorker.getId());
                purchasesettlementdetailVO.setSource(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0))) ? (String)datas.get(0) : null);
                purchasesettlementdetailVO.setBillCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                purchasesettlementdetailVO.setBillName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                purchasesettlementdetailVO.setBrandModel(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                purchasesettlementdetailVO.setUnit(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                purchasesettlementdetailVO.setSupplyQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                purchasesettlementdetailVO.setSupplyTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? DateUtils.Date((String)datas.get(6)) : null);
                purchasesettlementdetailVO.setUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                purchasesettlementdetailVO.setTaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                purchasesettlementdetailVO.setSettlementPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                purchasesettlementdetailVO.setTaxSettlementPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                purchasesettlementdetailVO.setSettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                purchasesettlementdetailVO.setTaxSettlementAmount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? new BigDecimal((String)datas.get(12)) : null);
                purchasesettlementdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? (String)datas.get(13) : null);
                purchasesettlementdetailVO.setSettlementTotal(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) ? new BigDecimal((String)datas.get(14)) : null);
                purchasesettlementdetailVO.setTaxSettlementTotal(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) ? new BigDecimal((String)datas.get(15)) : null);
                successList.add(purchasesettlementdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportPurchasesettlementFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody PurchasesettlementVO purchasesettlementVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)purchasesettlementVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.purchasesettlementdetailService.list((Wrapper)queryWrapper);
        List purchasesettlementdetailVOList = BeanMapper.mapList((Iterable)list, PurchasesettlementdetailVO.class);
        if (purchasesettlementdetailVOList != null && purchasesettlementdetailVOList.size() > 0) {
            for (int i = 0; i < purchasesettlementdetailVOList.size(); ++i) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = (PurchasesettlementdetailVO)((Object)purchasesettlementdetailVOList.get(i));
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if (purchasesettlementdetailVO.getSupplyTime() == null) continue;
                purchasesettlementdetailVO.setSupplyTimeShow(DateUtils.dateSimple(purchasesettlementdetailVO.getSupplyTime()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", purchasesettlementdetailVOList);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportPurchasesettlementFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<PurchasesettlementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = list.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if (purchasesettlementdetailVO.getSupplyTime() == null) continue;
                purchasesettlementdetailVO.setSupplyTimeShow(DateUtils.dateSimple(purchasesettlementdetailVO.getSupplyTime()));
            }
        }
        HashMap<String, List<PurchasesettlementdetailVO>> beans = new HashMap<String, List<PurchasesettlementdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }
}

