/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"revolvingleaseExport"})
public class ExcelRevolvingleaseController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;

    @RequestMapping(value={"/downloadRevolvinglease"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadRevolvinglease(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"revolvingleasedetail-import.xlsx", (String)"\u6708\u5ea6\u5468\u8f6c\u79df\u8d41\u5355\u6e05\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportRevolvinglease"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportRevolvinglease(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<RevolvingleasedetailVO> successList = new ArrayList<RevolvingleasedetailVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                RevolvingleasedetailVO revolvingleasedetailVO = new RevolvingleasedetailVO();
                List datas = (List)result.get(i);
                revolvingleasedetailVO.setId(IdWorker.getId());
                revolvingleasedetailVO.setMaterialCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? String.valueOf(datas.get(1)) : null);
                revolvingleasedetailVO.setLesseeMaterialsName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                revolvingleasedetailVO.setSpecifications(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                revolvingleasedetailVO.setMeasurementUnit(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                revolvingleasedetailVO.setLesseeQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? Integer.valueOf((int)Float.parseFloat((String)datas.get(5))) : null);
                revolvingleasedetailVO.setSettleTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? DateUtils.Date((String)datas.get(6)) : null);
                revolvingleasedetailVO.setEndTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? DateUtils.Date((String)datas.get(7)) : null);
                revolvingleasedetailVO.setLesseeTerm(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? Integer.valueOf((int)Float.parseFloat((String)datas.get(8))) : null);
                revolvingleasedetailVO.setLesseeUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                revolvingleasedetailVO.setTaxLesseeUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                revolvingleasedetailVO.setTaxLesseeUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                revolvingleasedetailVO.setLesseeTotalprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                revolvingleasedetailVO.setTaxLesseeTotalprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? new BigDecimal((String)datas.get(12)) : null);
                revolvingleasedetailVO.setLossDamage(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(13))) ? new BigDecimal((String)datas.get(13)) : null);
                revolvingleasedetailVO.setCompensateUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(14))) ? new BigDecimal((String)datas.get(14)) : null);
                revolvingleasedetailVO.setTaxCompensateUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) ? new BigDecimal((String)datas.get(15)) : null);
                revolvingleasedetailVO.setCompensateAccount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(16))) ? new BigDecimal((String)datas.get(16)) : null);
                revolvingleasedetailVO.setTaxCompensateAccount(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(17))) ? new BigDecimal((String)datas.get(17)) : null);
                revolvingleasedetailVO.setOtherExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(18))) ? new BigDecimal((String)datas.get(18)) : null);
                revolvingleasedetailVO.setTaxOtherExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(19))) ? new BigDecimal((String)datas.get(19)) : null);
                revolvingleasedetailVO.setMonthlyExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(20))) ? new BigDecimal((String)datas.get(20)) : null);
                revolvingleasedetailVO.setTaxMonthlyExpenses(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(21))) ? new BigDecimal((String)datas.get(21)) : null);
                revolvingleasedetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(22))) ? String.valueOf(datas.get(22)) : null);
                successList.add(revolvingleasedetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportRevolvingleaseFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportRevolvingleaseFromDatabase(@RequestBody RevolvingleaseVO revolvingleaseVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)revolvingleaseVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.revolvingleasedetailService.list((Wrapper)queryWrapper);
        List revolvingleasedetailVOList = BeanMapper.mapList((Iterable)list, RevolvingleasedetailVO.class);
        if (revolvingleasedetailVOList != null && revolvingleasedetailVOList.size() > 0) {
            for (int i = 0; i < revolvingleasedetailVOList.size(); ++i) {
                RevolvingleasedetailVO revolvingleasedetailVO = (RevolvingleasedetailVO)((Object)revolvingleasedetailVOList.get(i));
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() == null) continue;
                revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", revolvingleasedetailVOList);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportRevolvingleaseFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportRevolvingleaseFromPage(@RequestBody List<RevolvingleasedetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                RevolvingleasedetailVO revolvingleasedetailVO = list.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() == null) continue;
                revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
            }
        }
        HashMap<String, List<RevolvingleasedetailVO>> beans = new HashMap<String, List<RevolvingleasedetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }
}

