/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.ISubcontractingvolumedetailService;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumedetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumemdetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractingvolumeodetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"subcontractingvolumeExport"})
public class ExcelSubcontractingvolumeController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ISubcontractingvolumedetailService subcontractingvolumedetailService;

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"subcontractingvolumedetail-import.xlsx", (String)"\u5206\u5305\u6708\u5ea6\u62a5\u91cf\u53ca\u7533\u8bf7\u62a5\u544a");
    }

    @RequestMapping(value={"/download2"}, method={RequestMethod.POST})
    @ResponseBody
    public void download2(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"subcontractingvolumemdetail-import.xlsx", (String)"\u7269\u8d44\u4ee3\u6263\u53ca\u8d85\u7528\u6263\u6b3e\u6e05\u5355");
    }

    @RequestMapping(value={"/download3"}, method={RequestMethod.POST})
    @ResponseBody
    public void download3(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"subcontractingvolumeodetail-import.xlsx", (String)"\u5176\u5b83\u6263\u6b3e\u6e05\u5355");
    }

    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SubcontractingvolumedetailVO> successList = new ArrayList<SubcontractingvolumedetailVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 3; i < result.size(); ++i) {
                SubcontractingvolumedetailVO vo = new SubcontractingvolumedetailVO();
                List datas = (List)result.get(i);
                vo.setBillCode((String)datas.get(0));
                vo.setBillName((String)datas.get(1));
                vo.setUnit((String)datas.get(2));
                vo.setQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : new BigDecimal(0.0));
                vo.setUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : new BigDecimal(0.0));
                vo.setTaxUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : new BigDecimal(0.0));
                vo.setAmounts(vo.getQuantity().multiply(vo.getUnitprice()));
                vo.setTaxAmounts(vo.getQuantity().multiply(vo.getTaxUnitprice()));
                vo.setExamineQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? new BigDecimal((String)datas.get(6)) : new BigDecimal(0.0));
                vo.setExamineUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : new BigDecimal(0.0));
                vo.setExamineTaxUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : new BigDecimal(0.0));
                vo.setExamineAmounts(vo.getExamineQuantity().multiply(vo.getExamineUnitprice()));
                vo.setExamineTaxAmounts(vo.getExamineQuantity().multiply(vo.getExamineTaxUnitprice()));
                vo.setMemo((String)datas.get(10));
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/import2"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData2(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SubcontractingvolumemdetailVO> successList = new ArrayList<SubcontractingvolumemdetailVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 3; i < result.size(); ++i) {
                SubcontractingvolumemdetailVO vo = new SubcontractingvolumemdetailVO();
                List datas = (List)result.get(i);
                vo.setBillCode((String)datas.get(0));
                vo.setBillName((String)datas.get(1));
                vo.setUnit((String)datas.get(2));
                vo.setUnitprice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : new BigDecimal(0.0));
                vo.setBudgetquantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? new BigDecimal((String)datas.get(4)) : new BigDecimal(0.0));
                vo.setActualConsumption(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : new BigDecimal(0.0));
                vo.setExcessdosage(vo.getActualConsumption().add(vo.getBudgetquantity()));
                if (vo.getExcessdosage().compareTo(new BigDecimal(0.0)) < 0) {
                    vo.setExcessdosage(new BigDecimal(0.0));
                }
                vo.setOverdraftDeduction(vo.getExcessdosage().multiply(vo.getUnitprice()));
                vo.setWithholding((String)datas.get(6));
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/import3"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> importData3(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<SubcontractingvolumeodetailVO> successList = new ArrayList<SubcontractingvolumeodetailVO>();
        ArrayList errorList = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 3; i < result.size(); ++i) {
                SubcontractingvolumeodetailVO vo = new SubcontractingvolumeodetailVO();
                List datas = (List)result.get(i);
                vo.setExpenseName((String)datas.get(0));
                vo.setUnit((String)datas.get(1));
                vo.setQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? new BigDecimal((String)datas.get(2)) : new BigDecimal(0.0));
                vo.setUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? new BigDecimal((String)datas.get(3)) : new BigDecimal(0.0));
                vo.setAmounts(vo.getQuantity().multiply(vo.getQuantity()));
                vo.setRemarks((String)datas.get(4));
                successList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/export"}, method={RequestMethod.POST})
    @ResponseBody
    public void export(@RequestBody SubcontractingvolumeVO vo, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)vo.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.subcontractingvolumedetailService.list((Wrapper)queryWrapper);
        List vOList = BeanMapper.mapList((Iterable)list, SubcontractingvolumedetailVO.class);
        if (!CollectionUtil.isEmpty((Collection)vOList)) {
            for (int i = 0; i < vOList.size(); ++i) {
                SubcontractingvolumedetailVO subcontractingvolumedetailVO = (SubcontractingvolumedetailVO)((Object)vOList.get(i));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vOList);
        ExcelExport.getInstance().export("subcontractingvolumedetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/exportFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void exportFromPage(@RequestBody List<SubcontractingvolumedetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                SubcontractingvolumedetailVO vo = list.get(i);
                vo.setSort(String.valueOf(i + 1));
            }
        }
        HashMap<String, List<SubcontractingvolumedetailVO>> beans = new HashMap<String, List<SubcontractingvolumedetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("subcontractingvolumedetail-export.xlsx", beans, response);
    }
}

