/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.CreditorsrightsEntity;
import com.ejianc.business.middlemeasurement.mapper.CreditorsrightsMapper;
import com.ejianc.business.middlemeasurement.service.ICreditorsrightsService;
import com.ejianc.business.middlemeasurement.vo.CreditorsrightsVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="creditorsrightsService")
public class CreditorsrightsServiceImpl
extends BaseServiceImpl<CreditorsrightsMapper, CreditorsrightsEntity>
implements ICreditorsrightsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICreditorsrightsService service;
    @Autowired
    private RestHighLevelClient client;
    private static final String ESSignStatistic = "ejc_creditorsrights_report";

    @Override
    public CommonResponse<String> saveSnapshotData() {
        String curDate = this.getLastMonth();
        new Thread(() -> {
            try {
                this.service.saveESData("\u503a\u6743\u60c5\u51b5" + curDate);
            }
            catch (Exception e) {
                this.logger.error("\u503a\u6743\u60c5\u51b5\u62a5\u8868\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
            }
        }).start();
        return CommonResponse.success((String)"\u4fdd\u5b58\u5feb\u7167\u6210\u529f");
    }

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = this.service.queryList(queryParam);
        BulkRequest bulkRequest = new BulkRequest();
        for (CreditorsrightsEntity entity : list) {
            try {
                CreditorsrightsVO vo = (CreditorsrightsVO)((Object)BeanMapper.map((Object)((Object)entity), CreditorsrightsVO.class));
                Map dataMap = (Map)BeanMapper.map((Object)((Object)vo), Map.class);
                dataMap.put("id", IdWorker.getId());
                dataMap.put("reportId", entity.getId().toString());
                dataMap.put("snapShotTime", new Date());
                dataMap.put("snapShotVersion", IdWorker.getId());
                IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u503a\u6743\u60c5\u51b5\u7edf\u8ba1\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                throw new BusinessException("\u751f\u6210\u503a\u6743\u60c5\u51b5\u7edf\u8ba1\u6570\u636e\u5f02\u5e38");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.info("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
            throw new BusinessException("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
        }
        this.logger.info("***********\u751f\u6210\u503a\u6743\u60c5\u51b5\u7edf\u8ba1\u6267\u884c \u5b8c\u4e8b *********** ");
        return CommonResponse.success((String)"\u751f\u6210\u503a\u6743\u60c5\u51b5\u7edf\u8ba1\u6210\u529f");
    }

    @Override
    public IPage<CreditorsrightsVO> queryEsByPage(QueryParam param) {
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
        searchRequest.searchType(SearchType.DFS_QUERY_THEN_FETCH);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
        sourceBuilder.size(pageSize.intValue());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        sourceBuilder.sort("snapShotTime", SortOrder.ASC);
        List fields = param.getFuzzyFields();
        if (fields.size() > 0 && fields != null) {
            for (String field : fields) {
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchQuery((String)"reportId", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"snapShotTime", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"snapShotVersion", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"billCode", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"billState", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"projectId", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"projectName", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"orgId", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"orgName", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"projectDepartmentId", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"deadline", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"margin", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"revolvingFund", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"operational", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"total", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"dr", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"createUserCode", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"createTime", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"updateUserCode", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"updateTime", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"tenantId", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"syncEsFlag", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"rowState", (Object)param.getSearchText()));
                sourceBuilder.query((QueryBuilder)QueryBuilders.matchPhrasePrefixQuery((String)"version", (Object)param.getSearchText()));
            }
            searchRequest.source(sourceBuilder);
        } else {
            sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            searchRequest.source(sourceBuilder);
        }
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            Integer count = 0;
            Integer idCount = 1;
            SearchHit[] searchHits = hits.getHits();
            if (searchHits.length <= 0) {
                return null;
            }
            Page voPage = new Page();
            ArrayList<CreditorsrightsVO> list = new ArrayList<CreditorsrightsVO>();
            for (SearchHit hit : searchHits) {
                Integer n = idCount;
                Integer n2 = idCount = Integer.valueOf(idCount + 1);
                JSONObject json = new JSONObject(hit.getSourceAsMap());
                CreditorsrightsVO vo = (CreditorsrightsVO)((Object)JSONObject.toJavaObject((JSON)json, CreditorsrightsVO.class));
                vo.setId((long)idCount);
                if (vo.getSnapShotTime() != null) {
                    vo.setSnapShotTime((Date)DateUtil.date((Date)vo.getSnapShotTime()));
                }
                list.add(vo);
                Integer n3 = count;
                Integer n4 = count = Integer.valueOf(count + 1);
            }
            voPage.setTotal((long)count.intValue());
            voPage.setSize((long)pageSize.intValue());
            voPage.setPages(pageIndex <= 0 ? 0L : (long)((pageIndex - 1) * pageSize));
            return voPage.setRecords(list);
        }
        catch (IOException e) {
            throw new RuntimeException("ES\u67e5\u8be2\u5f02\u5e38" + e);
        }
    }

    @Override
    public List<String> queryEsSnap() {
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
        searchRequest.searchType(SearchType.DFS_QUERY_THEN_FETCH);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
        sourceBuilder.fetchSource(new String[]{"snapShotVersion"}, new String[0]);
        searchRequest.source(sourceBuilder);
        SearchResponse searchResponse = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            SearchHit[] searchHits;
            searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            for (SearchHit hit : searchHits = hits.getHits()) {
                Map sourceAsMap = hit.getSourceAsMap();
                String versionName = (String)sourceAsMap.get("snapShotVersion");
                list.add(hit.getId());
                list.add(versionName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("ES\u67e5\u8be2\u5931\u8d25" + e);
        }
        return list;
    }

    public String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - 1);
        date = calendar.getTime();
        String accDate = format.format(date);
        return accDate;
    }
}

