/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.CapitalinflowsEntity;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.service.ICapitalinflowsService;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;
import com.ejianc.business.middlemeasurement.vo.CapitalinflowsVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"capitalinflows"})
public class CapitalinflowsController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ICapitalinflowsService service;
    @Autowired
    private IEngineermeasurementService engineermeasurementService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<CapitalinflowsVO> saveOrUpdate(@RequestBody CapitalinflowsVO saveorUpdateVO) {
        CapitalinflowsEntity entity = (CapitalinflowsEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), CapitalinflowsEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
            queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("\u540c\u4e00\u9879\u76ee\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u8d44\u91d1\u6d41\u5165\"!");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        CapitalinflowsVO vo = (CapitalinflowsVO)((Object)BeanMapper.map((Object)((Object)entity), CapitalinflowsVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CapitalinflowsVO> queryDetail(Long id) {
        CapitalinflowsEntity entity = (CapitalinflowsEntity)((Object)this.service.selectById(id));
        CapitalinflowsVO vo = (CapitalinflowsVO)((Object)BeanMapper.map((Object)((Object)entity), CapitalinflowsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CapitalinflowsVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<CapitalinflowsVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CapitalinflowsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List capitalinflowsVOList = BeanMapper.mapList((Iterable)list, CapitalinflowsVO.class);
        for (int i = 0; i < capitalinflowsVOList.size(); ++i) {
            String billStateStr;
            CapitalinflowsVO capitalinflowsVO = (CapitalinflowsVO)((Object)capitalinflowsVOList.get(i));
            capitalinflowsVO.setSort(String.valueOf(i + 1));
            if (capitalinflowsVO.getDeadline() != null) {
                capitalinflowsVO.setDeadline((Date)DateUtil.date((Date)capitalinflowsVO.getDeadline()));
            }
            if ((billStateStr = capitalinflowsVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            capitalinflowsVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", capitalinflowsVOList);
        ExcelExport.getInstance().export("capitalinflowsList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refCapitalinflowsData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CapitalinflowsVO>> refCapitalinflowsData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), CapitalinflowsVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/saveSnapshotData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> saveSnapshotData() {
        return this.service.saveSnapshotData();
    }

    @RequestMapping(value={"/saveESData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> saveESData() {
        SimpleDateFormat format1 = new SimpleDateFormat("YYYY-MM-dd hh:mm:ss");
        String curDate = format1.format(new Date());
        return this.service.saveESData("\u8d44\u91d1\u6d41\u5165\u7edf\u8ba1\u62a5\u8868\uff08\u624b\u52a8\uff09" + curDate);
    }

    @RequestMapping(value={"/queryReportList"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CapitalinflowsVO>> queryReportList(QueryParam param, String monthQuery, String reportItem) {
        List fuzzyFields = param.getFuzzyFields();
        return CommonResponse.success(this.service.queryEsByPage(param, monthQuery, reportItem));
    }

    @RequestMapping(value={"/esExcelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse esExcelExport(HttpServletResponse response, @RequestBody List<CapitalinflowsEntity> list) {
        List capitalinflowsVOList = BeanMapper.mapList(list, CapitalinflowsVO.class);
        for (int i = 0; i < capitalinflowsVOList.size(); ++i) {
            String billStateStr;
            CapitalinflowsVO capitalinflowsVO = (CapitalinflowsVO)((Object)capitalinflowsVOList.get(i));
            capitalinflowsVO.setSort(String.valueOf(i + 1));
            if (capitalinflowsVO.getDeadline() != null) {
                capitalinflowsVO.setDeadline((Date)DateUtil.date((Date)capitalinflowsVO.getDeadline()));
            }
            if ((billStateStr = capitalinflowsVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            capitalinflowsVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", capitalinflowsVOList);
        ExcelExport.getInstance().export("CapitalinflowsReport-export.xlsx", beans, response);
        return CommonResponse.success();
    }

    @RequestMapping(value={"/queryEsSnap"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse queryEsSnap(String monthQuery) {
        List<String> list = this.service.queryEsSnap(monthQuery);
        return CommonResponse.success(list);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<CapitalinflowsVO> pastData(Long projectId, Date deadline) {
        Date deadlineRes = deadline;
        if (deadline == null) {
            deadlineRes = new Date(System.currentTimeMillis());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(projectId, deadlineRes)));
    }

    private CapitalinflowsVO getPastTotalData(Long projectId, Date deadline) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"project_id", (Object)projectId);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)deadline);
        queryWrapperTotal.orderByDesc((Object)"reporting_time");
        queryWrapperTotal.groupBy((Object[])new String[]{"contract_id"});
        List proTotal = this.engineermeasurementService.list((Wrapper)queryWrapperTotal);
        BigDecimal receivedPayment = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); ++i) {
                EngineermeasurementEntity engineermeasurementEntity = (EngineermeasurementEntity)((Object)proTotal.get(i));
                BigDecimal cumulativeCollection = engineermeasurementEntity.getCumulativeCollection();
                receivedPayment = receivedPayment.add(cumulativeCollection);
            }
        }
        CapitalinflowsVO vo = new CapitalinflowsVO();
        vo.setReceivedPayment(receivedPayment);
        vo.setProjectId(projectId);
        return vo;
    }
}

