/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementEntity;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementService;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"interimsettlement"})
public class InterimsettlementController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IInterimsettlementService service;
    @Autowired
    private IInterimsettlementdetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<InterimsettlementVO> saveOrUpdate(@RequestBody InterimsettlementVO saveorUpdateVO) {
        InterimsettlementEntity entity = (InterimsettlementEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), InterimsettlementEntity.class));
        this.checkIssueNumberUniq(entity.getInterimsettlementdetailEntities());
        this.checkBillStateUniq(entity.getId(), entity.getContractId());
        entity = this.checkBillCodeUniq(entity);
        entity = this.handleCumulative(entity);
        this.service.saveOrUpdate((Object)entity, false);
        InterimsettlementVO vo = (InterimsettlementVO)((Object)BeanMapper.map((Object)((Object)entity), InterimsettlementVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    private void checkIssueNumberUniq(List<InterimsettlementdetailEntity> detailEntities) {
        if (detailEntities != null && detailEntities.size() > 0) {
            HashMap<String, InterimsettlementdetailEntity> map = new HashMap<String, InterimsettlementdetailEntity>();
            for (InterimsettlementdetailEntity detail : detailEntities) {
                if (map.get(detail.getIssueNumber()) == null) {
                    map.put(detail.getIssueNumber(), detail);
                    continue;
                }
                throw new BusinessException("\u671f\u53f7\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
            }
        }
    }

    private void checkBillStateUniq(Long id, Long contractId) {
        List pro;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        queryWrapper.eq((Object)"dr", (Object)"0");
        if (id != null) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)) != null && pro.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\"\u9879\u76ee\u671f\u4e2d\u7ed3\u7b97\u53f0\u8d26\"!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InterimsettlementEntity checkBillCodeUniq(InterimsettlementEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne((Object)"id", (Object)id);
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)) == null || proBillCode.size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    private InterimsettlementEntity handleCumulative(InterimsettlementEntity entity) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (entity.getCreateTime() != null) {
            currentDate = entity.getCreateTime();
        }
        InterimsettlementVO pastVo = this.getPastTotalData(entity.getContractId(), currentDate);
        List<InterimsettlementdetailVO> pastDetailVOList = pastVo.getInterimsettlementdetailEntities();
        List pastDetailList = BeanMapper.mapList(pastDetailVOList, InterimsettlementdetailEntity.class);
        BigDecimal cumulativeAmount = pastVo.getCumulativeAmount();
        BigDecimal currentAmount = entity.getCurrentAmount();
        cumulativeAmount = cumulativeAmount != null && entity.getCurrentAmount() != null ? currentAmount.add(cumulativeAmount) : currentAmount;
        entity.setCumulativeAmount(cumulativeAmount);
        BigDecimal contractAmount = entity.getContractAmount();
        if (cumulativeAmount != null && contractAmount != null && contractAmount.compareTo(BigDecimal.ZERO) != 0) {
            BigDecimal cumulativeProportion = cumulativeAmount.divide(contractAmount, 8, 4).multiply(new BigDecimal(100));
            entity.setCumulativeProportion(cumulativeProportion);
        }
        ArrayList<InterimsettlementdetailEntity> resDetailList = new ArrayList();
        List<InterimsettlementdetailEntity> currentDetailEntities = entity.getInterimsettlementdetailEntities();
        ArrayList<InterimsettlementdetailEntity> delCurrentDetailEntities = new ArrayList<InterimsettlementdetailEntity>();
        if (currentDetailEntities != null && currentDetailEntities.size() > 0 && pastDetailList != null && pastDetailList.size() > 0) {
            for (int i = 0; i < currentDetailEntities.size(); ++i) {
                if (i == 0) continue;
                InterimsettlementdetailEntity delCurrentDetail = currentDetailEntities.get(i);
                delCurrentDetail.setRowState("del");
                delCurrentDetailEntities.add(delCurrentDetail);
            }
            InterimsettlementdetailEntity currentDetailEntity = currentDetailEntities.get(0);
            resDetailList.add(currentDetailEntity);
            if (pastDetailList != null && pastDetailList.size() > 0) {
                resDetailList.addAll(pastDetailList);
            }
            for (int i = 0; i < resDetailList.size(); ++i) {
                ((InterimsettlementdetailEntity)((Object)resDetailList.get(i))).setSort(String.valueOf(i + 1));
            }
            if (resDetailList != null && resDetailList.size() > 1) {
                InterimsettlementdetailEntity detail0 = (InterimsettlementdetailEntity)((Object)resDetailList.get(0));
                InterimsettlementdetailEntity detail1 = (InterimsettlementdetailEntity)((Object)resDetailList.get(1));
                BigDecimal detailCurrentApproval = detail0.getCurrentApproval();
                BigDecimal detailCurrentReceivable = detail0.getCurrentReceivable();
                BigDecimal detailCurrentRetention = detail0.getCurrentRetention();
                BigDecimal detailCurrentActual = detail0.getCurrentActual();
                BigDecimal detailCurrentUncollected = detail0.getCurrentUncollected();
                BigDecimal detailCumulativeApprovalP = detail1.getCumulativeApproval();
                BigDecimal detailCumulativeReceivableP = detail1.getCumulativeReceivable();
                BigDecimal detailCumulativeRetentionP = detail1.getCumulativeRetention();
                BigDecimal detailCumulativeActualP = detail1.getCumulativeActual();
                BigDecimal detailCumulativeUncollectedP = detail1.getCumulativeUncollected();
                if (detailCumulativeApprovalP != null && detailCurrentApproval != null) {
                    BigDecimal resdetailCumulativeApproval = detailCurrentApproval.add(detailCumulativeApprovalP);
                    detail0.setCumulativeApproval(resdetailCumulativeApproval);
                }
                if (detailCumulativeReceivableP != null && detailCurrentReceivable != null) {
                    BigDecimal resdetailCurrentReceivable = detailCurrentReceivable.add(detailCumulativeReceivableP);
                    detail0.setCumulativeReceivable(resdetailCurrentReceivable);
                }
                if (detailCumulativeRetentionP != null && detailCurrentRetention != null) {
                    BigDecimal resdetailCumulativeRetention = detailCurrentRetention.add(detailCumulativeRetentionP);
                    detail0.setCumulativeRetention(resdetailCumulativeRetention);
                }
                if (detailCumulativeActualP != null && detailCurrentActual != null) {
                    BigDecimal resdetailCumulativeActual = detailCurrentActual.add(detailCumulativeActualP);
                    detail0.setCumulativeApproval(resdetailCumulativeActual);
                }
                if (detailCumulativeUncollectedP != null && detailCurrentUncollected != null) {
                    BigDecimal resdetailCumulativeUncollected = detailCurrentUncollected.add(detailCumulativeUncollectedP);
                    detail0.setCumulativeApproval(resdetailCumulativeUncollected);
                }
                resDetailList.addAll(delCurrentDetailEntities);
            }
        } else {
            resDetailList = currentDetailEntities;
        }
        entity.setInterimsettlementdetailEntities(resDetailList);
        return entity;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InterimsettlementVO> queryDetail(Long id) {
        InterimsettlementEntity entity = (InterimsettlementEntity)((Object)this.service.selectById(id));
        InterimsettlementVO vo = (InterimsettlementVO)((Object)BeanMapper.map((Object)((Object)entity), InterimsettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<InterimsettlementVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<InterimsettlementVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InterimsettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        List interimsettlementVOList = BeanMapper.mapList((Iterable)list, InterimsettlementVO.class);
        for (int i = 0; i < interimsettlementVOList.size(); ++i) {
            String billStateStr;
            InterimsettlementVO interimsettlementVO = (InterimsettlementVO)((Object)interimsettlementVOList.get(i));
            interimsettlementVO.setSort(String.valueOf(i + 1));
            if (interimsettlementVO.getApplicationTime() != null) {
                interimsettlementVO.setApplicationTime((Date)DateUtil.date((Date)interimsettlementVO.getApplicationTime()));
            }
            if (interimsettlementVO.getApprovalTime() != null) {
                interimsettlementVO.setApprovalTime((Date)DateUtil.date((Date)interimsettlementVO.getApplicationTime()));
            }
            if ((billStateStr = interimsettlementVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            interimsettlementVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", interimsettlementVOList);
        ExcelExport.getInstance().export("interimsettlementList-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refInterimsettlementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<InterimsettlementVO>> refInterimsettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), InterimsettlementVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<InterimsettlementVO> pastData(Long id, Long contractId) {
        this.checkBillStateUniq(id, contractId);
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            InterimsettlementEntity entity = (InterimsettlementEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate)));
    }

    private InterimsettlementVO getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.eq((Object)"dr", (Object)0);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        queryWrapperTotal.orderByDesc((Object)"create_time");
        queryWrapperTotal.last("limit 1");
        List list = this.service.list((Wrapper)queryWrapperTotal);
        InterimsettlementVO resVO = new InterimsettlementVO();
        if (list != null && list.size() > 0) {
            resVO = (InterimsettlementVO)((Object)BeanMapper.map(list.get(0), InterimsettlementVO.class));
            QueryWrapper queryWrapperDetailList = new QueryWrapper();
            queryWrapperDetailList.eq((Object)"mid", (Object)resVO.getId());
            queryWrapperDetailList.eq((Object)"dr", (Object)"0");
            queryWrapperDetailList.orderByAsc((Object)"sort");
            List detailList = this.detailService.list((Wrapper)queryWrapperDetailList);
            if (detailList != null && detailList.size() > 0) {
                for (int i = 0; i < detailList.size(); ++i) {
                    ((InterimsettlementdetailEntity)((Object)detailList.get(i))).setId(IdWorker.getId());
                    ((InterimsettlementdetailEntity)((Object)detailList.get(i))).setPastFlag(1);
                }
                List resDetailList = BeanMapper.mapList((Iterable)detailList, InterimsettlementdetailVO.class);
                resVO.setInterimsettlementdetailEntities(resDetailList);
            }
        }
        return resVO;
    }
}

