/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementEntity;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementService;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"interimsettlementExport"})
public class ExcelInterimsettlementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IInterimsettlementService service;
    @Autowired
    private IInterimsettlementdetailService detailService;

    @RequestMapping(value={"/downloadInterimsettlementdetail"}, method={RequestMethod.POST})
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"interimsettlementdetail-import.xlsx", (String)"\u9879\u76ee\u671f\u4e2d\u7ed3\u7b97\u53f0\u8d26\u6a21\u677f");
    }

    @RequestMapping(value={"/excelInterimsettlement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportInterimsettlement(HttpServletRequest request, HttpServletResponse response, String id, String contractId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<InterimsettlementdetailVO> successList = new ArrayList<InterimsettlementdetailVO>();
        ArrayList<InterimsettlementdetailVO> errorList = new ArrayList<InterimsettlementdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        Long billId = null;
        Long billContractId = null;
        billId = id != null && !"null".equals(id) ? Long.valueOf(Long.parseLong(id)) : null;
        if (contractId != null) {
            billContractId = Long.parseLong(contractId);
        }
        if (result != null && result.size() > 0) {
            InterimsettlementVO pastVO = this.pastData(billId, billContractId);
            List<InterimsettlementdetailVO> pastDetailVOList = pastVO.getInterimsettlementdetailEntities();
            HashMap<String, InterimsettlementdetailVO> pastDetailMap = new HashMap<String, InterimsettlementdetailVO>();
            InterimsettlementdetailVO lastPastDetail = new InterimsettlementdetailVO();
            if (pastDetailVOList != null && pastDetailVOList.size() > 0) {
                for (int i = 0; i < pastDetailVOList.size(); ++i) {
                    InterimsettlementdetailVO pastDetailVO = pastDetailVOList.get(i);
                    pastDetailMap.put(pastDetailVO.getIssueNumber(), pastDetailVO);
                }
                lastPastDetail = pastDetailVOList.get(0);
            }
            HashMap<String, InterimsettlementdetailVO> importDetailMap = new HashMap<String, InterimsettlementdetailVO>();
            for (int i = 2; i < result.size(); ++i) {
                InterimsettlementdetailVO interimsettlementdetailVO = new InterimsettlementdetailVO();
                List datas = (List)result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String issueNumber = (String)datas.get(1);
                String completionMonth = (String)datas.get(2);
                String applicationNo = (String)datas.get(3);
                String applicationAmount = (String)datas.get(4);
                String currentApproval = (String)datas.get(5);
                String cumulativeApproval = (String)datas.get(6);
                String income = (String)datas.get(7);
                String currentReceivable = (String)datas.get(8);
                String cumulativeReceivable = (String)datas.get(9);
                String currentRetention = (String)datas.get(10);
                String cumulativeRetention = (String)datas.get(11);
                String currentActual = (String)datas.get(12);
                String cumulativeActual = (String)datas.get(13);
                String currentUncollected = (String)datas.get(14);
                String cumulativeUncollected = (String)datas.get(15);
                String actualCollection = (String)datas.get(16);
                String cashFlow = (String)datas.get(17);
                String remarks = (String)datas.get(18);
                interimsettlementdetailVO.setId(IdWorker.getId());
                interimsettlementdetailVO.setRemarks(remarks);
                if (pastDetailMap.get(issueNumber) != null) continue;
                if (StringUtils.isBlank((CharSequence)issueNumber)) {
                    interimsettlementdetailVO.setErrorMsg("\u671f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u671f\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    interimsettlementdetailVO.setIssueNumber(issueNumber);
                }
                if (StringUtils.isBlank((CharSequence)completionMonth)) {
                    interimsettlementdetailVO.setErrorMsg("\u5b8c\u6210\u5de5\u7a0b\u6b3e\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u5b8c\u6210\u5de5\u7a0b\u6b3e\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    interimsettlementdetailVO.setCompletionMonth(completionMonth);
                }
                if (StringUtils.isBlank((CharSequence)applicationNo)) {
                    interimsettlementdetailVO.setErrorMsg("\u7533\u8bf7\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u7533\u8bf7\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    interimsettlementdetailVO.setApplicationNo(applicationNo);
                }
                if (StringUtils.isBlank((CharSequence)applicationAmount)) {
                    interimsettlementdetailVO.setErrorMsg("\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u7533\u8bf7\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else if (NumberUtil.isNumber((String)applicationAmount)) {
                    interimsettlementdetailVO.setApplicationAmount(new BigDecimal(applicationAmount));
                } else {
                    interimsettlementdetailVO.setErrorMsg("\u7533\u8bf7\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u7533\u8bf7\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (StringUtils.isBlank((CharSequence)currentApproval)) {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u6279\u51c6\u91d1\u989d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u6279\u51c6\u91d1\u989d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else if (NumberUtil.isNumber((String)currentApproval)) {
                    BigDecimal currentApprovalB = new BigDecimal(currentApproval);
                    interimsettlementdetailVO.setCurrentApproval(currentApprovalB);
                    BigDecimal pastCumulativeApproval = lastPastDetail.getCumulativeApproval();
                    pastCumulativeApproval = pastCumulativeApproval != null ? currentApprovalB.add(pastCumulativeApproval) : currentApprovalB;
                    interimsettlementdetailVO.setCumulativeApproval(pastCumulativeApproval);
                } else {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u6279\u51c6\u91d1\u989d\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u6279\u51c6\u91d1\u989d\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (StringUtils.isBlank((CharSequence)income)) {
                    interimsettlementdetailVO.setErrorMsg("\u8d22\u52a1\u5217\u62a5\u6536\u5165\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u8d22\u52a1\u5217\u62a5\u6536\u5165\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else if (NumberUtil.isNumber((String)income)) {
                    interimsettlementdetailVO.setIncome(new BigDecimal(income));
                } else {
                    interimsettlementdetailVO.setErrorMsg("\u8d22\u52a1\u5217\u62a5\u6536\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u8d22\u52a1\u5217\u62a5\u6536\u5165\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (StringUtils.isBlank((CharSequence)currentReceivable)) {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u6309\u7167\u5408\u540c\u7ea6\u5b9a\u6536\u6b3e\u6bd4\u4f8b\u5e94\u6536\u91d1\u989d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u6309\u7167\u5408\u540c\u7ea6\u5b9a\u6536\u6b3e\u6bd4\u4f8b\u5e94\u6536\u91d1\u989d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else if (NumberUtil.isNumber((String)currentReceivable)) {
                    BigDecimal currentReceivableB = new BigDecimal(currentReceivable);
                    interimsettlementdetailVO.setCurrentReceivable(currentReceivableB);
                    BigDecimal pastCumulativeReceivable = lastPastDetail.getCumulativeReceivable();
                    pastCumulativeReceivable = pastCumulativeReceivable != null ? currentReceivableB.add(pastCumulativeReceivable) : currentReceivableB;
                    interimsettlementdetailVO.setCumulativeReceivable(pastCumulativeReceivable);
                } else {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u6309\u7167\u5408\u540c\u7ea6\u5b9a\u6536\u6b3e\u6bd4\u4f8b\u5e94\u6536\u91d1\u989d\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u6309\u7167\u5408\u540c\u7ea6\u5b9a\u6536\u6b3e\u6bd4\u4f8b\u5e94\u6536\u91d1\u989d\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (StringUtils.isBlank((CharSequence)currentRetention)) {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u4fdd\u7559\u91d1\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u4fdd\u7559\u91d1\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else if (NumberUtil.isNumber((String)currentRetention)) {
                    BigDecimal currentRetentionB = new BigDecimal(currentRetention);
                    interimsettlementdetailVO.setCurrentRetention(currentRetentionB);
                    BigDecimal pastCumulativeRetention = lastPastDetail.getCumulativeRetention();
                    pastCumulativeRetention = pastCumulativeRetention != null ? currentRetentionB.add(pastCumulativeRetention) : currentRetentionB;
                    interimsettlementdetailVO.setCumulativeRetention(pastCumulativeRetention);
                } else {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u4fdd\u7559\u91d1\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u4fdd\u7559\u91d1\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (StringUtils.isBlank((CharSequence)currentActual)) {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u5b9e\u9645\u5df2\u6536\u91d1\u989d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u5b9e\u9645\u5df2\u6536\u91d1\u989d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else if (NumberUtil.isNumber((String)currentActual)) {
                    BigDecimal currentActualB = new BigDecimal(currentActual);
                    interimsettlementdetailVO.setCurrentActual(currentActualB);
                    BigDecimal pastCumulativeActual = lastPastDetail.getCumulativeActual();
                    pastCumulativeActual = pastCumulativeActual != null ? currentActualB.add(pastCumulativeActual) : currentActualB;
                    interimsettlementdetailVO.setCumulativeActual(pastCumulativeActual);
                } else {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u5b9e\u9645\u5df2\u6536\u91d1\u989d\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u5b9e\u9645\u5df2\u6536\u91d1\u989d\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (StringUtils.isBlank((CharSequence)currentUncollected)) {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u672a\u6536\u91d1\u989d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u672a\u6536\u91d1\u989d\uff09\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else if (NumberUtil.isNumber((String)currentUncollected)) {
                    BigDecimal currentUncollectedB = new BigDecimal(currentUncollected);
                    interimsettlementdetailVO.setCurrentUncollected(currentUncollectedB);
                    BigDecimal pastCumulativeUncollected = lastPastDetail.getCumulativeUncollected();
                    pastCumulativeUncollected = pastCumulativeUncollected != null ? currentUncollectedB.add(pastCumulativeUncollected) : currentUncollectedB;
                    interimsettlementdetailVO.setCumulativeUncollected(pastCumulativeUncollected);
                } else {
                    interimsettlementdetailVO.setErrorMsg("\u672c\u671f\uff08\u672a\u6536\u91d1\u989d\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u672c\u671f\uff08\u672a\u6536\u91d1\u989d\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (StringUtils.isBlank((CharSequence)actualCollection)) {
                    interimsettlementdetailVO.setErrorMsg("\u5b9e\u9645\u6536\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u5b9e\u9645\u6536\u6b3e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else if (DateUtils.grepDate(actualCollection)) {
                    interimsettlementdetailVO.setActualCollection(DateUtils.Date(actualCollection));
                } else {
                    interimsettlementdetailVO.setErrorMsg("\u5b9e\u9645\u6536\u6b3e\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5b9e\u9645\u6536\u6b3e\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                }
                if (StringUtils.isBlank((CharSequence)cashFlow)) {
                    interimsettlementdetailVO.setErrorMsg("\u73b0\u91d1\u6d41\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u73b0\u91d1\u6d41\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                } else {
                    interimsettlementdetailVO.setCashFlow(cashFlow);
                }
                if (importDetailMap.get(issueNumber) == null) {
                    importDetailMap.put(issueNumber, interimsettlementdetailVO);
                } else {
                    interimsettlementdetailVO.setErrorMsg("\u671f\u53f7\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
                    errorsMsgBuilder.append("\u671f\u53f7\u4e0d\u5141\u8bb8\u91cd\u590d\uff01");
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(interimsettlementdetailVO);
                    continue;
                }
                successList.add(interimsettlementdetailVO);
            }
            successList.addAll(pastDetailVOList);
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportInterimsettlementFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody InterimsettlementVO detailVo, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)detailVo.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.detailService.list((Wrapper)queryWrapper);
        List interimsettlementdetailVOList = BeanMapper.mapList((Iterable)list, InterimsettlementdetailVO.class);
        if (interimsettlementdetailVOList != null && interimsettlementdetailVOList.size() > 0) {
            for (int i = 0; i < interimsettlementdetailVOList.size(); ++i) {
                InterimsettlementdetailVO interimsettlementdetailVO = (InterimsettlementdetailVO)((Object)interimsettlementdetailVOList.get(i));
                interimsettlementdetailVO.setSort(String.valueOf(i + 1));
                if (interimsettlementdetailVO.getActualCollection() == null) continue;
                interimsettlementdetailVO.setActualCollectionShow(DateUtils.dateSimple(interimsettlementdetailVO.getActualCollection()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", interimsettlementdetailVOList);
        ExcelExport.getInstance().export("interimsettlementdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportInterimsettlementdetailFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<InterimsettlementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                InterimsettlementdetailVO interimsettlementdetailVO = list.get(i);
                interimsettlementdetailVO.setSort(String.valueOf(i + 1));
                if (interimsettlementdetailVO.getActualCollection() == null) continue;
                interimsettlementdetailVO.setActualCollectionShow(DateUtils.dateSimple(interimsettlementdetailVO.getActualCollection()));
            }
        }
        HashMap<String, List<InterimsettlementdetailVO>> beans = new HashMap<String, List<InterimsettlementdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("interimsettlementdetail-export.xlsx", beans, response);
    }

    public InterimsettlementVO pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            InterimsettlementEntity entity = (InterimsettlementEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return this.getPastTotalData(contractId, currentDate);
    }

    private InterimsettlementVO getPastTotalData(Long contractId, Date currentDate) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.eq((Object)"dr", (Object)0);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        queryWrapperTotal.orderByDesc((Object)"create_time");
        queryWrapperTotal.last("limit 1");
        List list = this.service.list((Wrapper)queryWrapperTotal);
        InterimsettlementVO resVO = new InterimsettlementVO();
        if (list != null && list.size() > 0) {
            resVO = (InterimsettlementVO)((Object)BeanMapper.map(list.get(0), InterimsettlementVO.class));
            QueryWrapper queryWrapperDetailList = new QueryWrapper();
            queryWrapperDetailList.eq((Object)"mid", (Object)resVO.getId());
            queryWrapperDetailList.eq((Object)"dr", (Object)"0");
            queryWrapperDetailList.orderByAsc((Object)"sort");
            List detailList = this.detailService.list((Wrapper)queryWrapperDetailList);
            if (detailList != null && detailList.size() > 0) {
                for (int i = 0; i < detailList.size(); ++i) {
                    ((InterimsettlementdetailEntity)((Object)detailList.get(i))).setId(IdWorker.getId());
                    ((InterimsettlementdetailEntity)((Object)detailList.get(i))).setPastFlag(1);
                }
                List resDetailList = BeanMapper.mapList((Iterable)detailList, InterimsettlementdetailVO.class);
                resVO.setInterimsettlementdetailEntities(resDetailList);
            }
        }
        return resVO;
    }
}

