/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.CapitalinflowsEntity;
import com.ejianc.business.middlemeasurement.mapper.CapitalinflowsMapper;
import com.ejianc.business.middlemeasurement.service.ICapitalinflowsService;
import com.ejianc.business.middlemeasurement.vo.CapitalinflowsVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MatchPhraseQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="capitalinflowsService")
public class CapitalinflowsServiceImpl
extends BaseServiceImpl<CapitalinflowsMapper, CapitalinflowsEntity>
implements ICapitalinflowsService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ICapitalinflowsService service;
    @Autowired
    private RestHighLevelClient client;
    private static final String ESSignStatistic = "ejc_capotalinflows_report";

    @Override
    public CommonResponse<String> saveSnapshotData() {
        new Thread(() -> {
            try {
                this.service.saveESData("\u8d44\u91d1\u6d41\u5165\u62a5\u8868" + DateUtil.now());
            }
            catch (Exception e) {
                this.logger.error("\u8d44\u91d1\u6d41\u5165\u62a5\u8868\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
            }
        }).start();
        return CommonResponse.success((String)"\u4fdd\u5b58\u5feb\u7167\u6210\u529f");
    }

    @Override
    public CommonResponse<String> saveESData(String reportName) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        List list = this.service.queryList(queryParam);
        BulkRequest bulkRequest = new BulkRequest();
        for (CapitalinflowsEntity entity : list) {
            try {
                CapitalinflowsVO vo = (CapitalinflowsVO)((Object)BeanMapper.map((Object)((Object)entity), CapitalinflowsVO.class));
                Map dataMap = (Map)BeanMapper.map((Object)((Object)vo), Map.class);
                dataMap.put("reportId", entity.getId().toString());
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
                dataMap.put("snapShotTime", format.format(new Date()));
                dataMap.put("snapShotVersion", reportName);
                IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            }
            catch (Exception e) {
                this.logger.error("\u751f\u6210\u8d44\u91d1\u6d41\u5165\u7edf\u8ba1\u6570\u636e\u5f02\u5e38\uff0c", (Throwable)e);
                throw new BusinessException("\u751f\u6210\u8d44\u91d1\u6d41\u5165\u7edf\u8ba1\u6570\u636e\u5f02\u5e38");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            this.client.bulk(bulkRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            this.logger.info("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
            throw new BusinessException("\u751f\u6210ES\u6570\u636e\u5931\u8d25:---->" + e.getMessage());
        }
        this.logger.info("***********\u751f\u6210\u8d44\u91d1\u6d41\u5165\u7edf\u8ba1\u6267\u884c \u5b8c\u4e8b *********** ");
        return CommonResponse.success((String)"\u751f\u6210\u8d44\u91d1\u6d41\u5165\u7edf\u8ba1\u6210\u529f");
    }

    @Override
    public IPage<CapitalinflowsVO> queryEsByPage(QueryParam param, String monthQuery, String reportItem) {
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
        searchRequest.searchType(SearchType.DEFAULT);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        Map parameterMap = param.getParams();
        ArrayList<MatchPhraseQueryBuilder> listQuery = new ArrayList<MatchPhraseQueryBuilder>();
        ArrayList<MatchPhraseQueryBuilder> mustQuery = new ArrayList<MatchPhraseQueryBuilder>();
        if (param.getSearchText() != null && StringUtils.isNotBlank((CharSequence)param.getSearchText())) {
            for (String field : param.getFuzzyFields()) {
                listQuery.add(QueryBuilders.matchPhraseQuery((String)field, (Object)param.getSearchText()));
            }
        }
        if (reportItem != null && StringUtils.isNotBlank((CharSequence)reportItem)) {
            mustQuery.add(QueryBuilders.matchPhraseQuery((String)"snapShotVersion", (Object)reportItem));
        }
        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);
        sourceBuilder.size(pageSize.intValue());
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(60L, TimeUnit.SECONDS));
        boolBuilder.should().addAll(listQuery);
        boolBuilder.must().addAll(mustQuery);
        sourceBuilder.query((QueryBuilder)boolBuilder);
        searchRequest.source(sourceBuilder);
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            Integer count = 0;
            Integer idCount = 1;
            SearchHit[] searchHits = hits.getHits();
            if (searchHits.length <= 0) {
                return null;
            }
            Page voPage = new Page();
            ArrayList<CapitalinflowsVO> list = new ArrayList<CapitalinflowsVO>();
            for (SearchHit hit : searchHits) {
                Integer n = idCount;
                Integer n2 = idCount = Integer.valueOf(idCount + 1);
                JSONObject json = new JSONObject(hit.getSourceAsMap());
                CapitalinflowsVO vo = (CapitalinflowsVO)((Object)JSONObject.toJavaObject((JSON)json, CapitalinflowsVO.class));
                vo.setId((long)idCount);
                if (vo.getSnapShotTime() != null) {
                    vo.setSnapShotTime(vo.getSnapShotTime());
                }
                if (vo.getSnapShotVersion().equals(reportItem)) {
                    list.add(vo);
                }
                Integer n3 = count;
                Integer n4 = count = Integer.valueOf(count + 1);
            }
            voPage.setTotal((long)count.intValue());
            voPage.setSize((long)pageSize.intValue());
            voPage.setPages(pageIndex <= 0 ? 0L : (long)((pageIndex - 1) * pageSize));
            return voPage.setRecords(list);
        }
        catch (IOException e) {
            throw new RuntimeException("ES\u67e5\u8be2\u5f02\u5e38" + e);
        }
    }

    @Override
    public List<String> queryEsSnap(String monthQuery) {
        SearchRequest searchRequest = new SearchRequest(new String[]{ESSignStatistic});
        searchRequest.searchType(SearchType.DEFAULT);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        ArrayList listQuery = new ArrayList();
        ArrayList<MatchPhraseQueryBuilder> mustQuery = new ArrayList<MatchPhraseQueryBuilder>();
        if (StringUtils.isNotEmpty((CharSequence)monthQuery) && monthQuery != null) {
            mustQuery.add(QueryBuilders.matchPhraseQuery((String)"snapShotTime", (Object)monthQuery));
        }
        boolBuilder.should().addAll(listQuery);
        boolBuilder.must().addAll(mustQuery);
        sourceBuilder.query((QueryBuilder)boolBuilder);
        searchRequest.source(sourceBuilder);
        ArrayList<String> list = new ArrayList<String>();
        try {
            SearchResponse searchResponse = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            SearchHit[] searchHits = hits.getHits();
            TreeSet<String> set = new TreeSet<String>();
            for (SearchHit hit : searchHits) {
                Map sourceAsMap = hit.getSourceAsMap();
                JSONObject json = new JSONObject(sourceAsMap);
                CapitalinflowsVO vo = (CapitalinflowsVO)((Object)JSONObject.toJavaObject((JSON)json, CapitalinflowsVO.class));
                if (!vo.getSnapShotTime().equals(monthQuery)) continue;
                set.add(vo.getSnapShotVersion());
            }
            list.addAll(set);
        }
        catch (IOException e) {
            throw new RuntimeException("ES\u67e5\u8be2\u5931\u8d25" + e);
        }
        return list;
    }

    public String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - 1);
        date = calendar.getTime();
        String accDate = format.format(date);
        return accDate;
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

