package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasesummaryVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetotalService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetotalVO;

/**
 * 月度机械设备租赁结算汇总
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("mechanicalleasedetotal")
public class MechanicalleasedetotalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMechanicalleasedetotalService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMechanicalleaseService mechanicalleaseService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MechanicalleasedetotalVO> saveOrUpdate(@RequestBody MechanicalleasedetotalVO saveorUpdateVO) {
    	MechanicalleasedetotalEntity entity = BeanMapper.map(saveorUpdateVO, MechanicalleasedetotalEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {//新增

            //1.校验（同一项目，如有未审批通过的单据，不允许新增）
            //创建条件构造器
            QueryWrapper<MechanicalleasedetotalEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("project_id", entity.getProjectId());
            queryWrapper.in("bill_state", 0, 2, 4, 5);
            List<MechanicalleasedetotalEntity> pro = service.list(queryWrapper);
            if(pro != null && pro.size() > 0){
                throw new BusinessException("同一项目只能存在一份自由态、审批中、审批驳回的\"月度周转租赁结算汇总单\"!");
            }
        }
        entity = checkBillCodeUniq(entity);
        service.saveOrUpdate(entity, false);

        //2.保存或更新后，更新租赁单的被引用状态
        if(entity.getId() != null){
            //2.1更新后，先把老数据的被引用状态改为0
            //创建条件构造器
            QueryWrapper<MechanicalleaseEntity> queryWrapperOld = new QueryWrapper<>();
            queryWrapperOld.in("reference_code", saveorUpdateVO.getBillCode());
            queryWrapperOld.eq("dr",0);
            List<MechanicalleaseEntity> oldList = mechanicalleaseService.list(queryWrapperOld);
            if(oldList != null && oldList.size() > 0){
                for (MechanicalleaseEntity item : oldList) {
                    item.setIsReference(0);
                    item.setReferenceCode(null);
                }
                mechanicalleaseService.saveOrUpdateBatch(oldList);
            }
        }

        //2.2更新被引用单据的引用状态
        List<String> referenceIdList = saveorUpdateVO.getReferenceIdList();
        if(referenceIdList != null && referenceIdList.size() > 0){
            //创建条件构造器
            QueryWrapper<MechanicalleaseEntity> queryWrapperByIdsNew = new QueryWrapper<>();
            queryWrapperByIdsNew.in("id", referenceIdList);
            queryWrapperByIdsNew.eq("dr",0);
            List<MechanicalleaseEntity> newList = mechanicalleaseService.list(queryWrapperByIdsNew);
            if(newList != null && newList.size() > 0){
                for (MechanicalleaseEntity item : newList) {
                    item.setIsReference(1);
                    item.setReferenceCode(entity.getBillCode());
                }
                mechanicalleaseService.saveOrUpdateBatch(newList);
            }
        }
        MechanicalleasedetotalVO vo = BeanMapper.map(entity, MechanicalleasedetotalVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    private MechanicalleasedetotalEntity checkBillCodeUniq(MechanicalleasedetotalEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //单据编码唯一性
            QueryWrapper<MechanicalleasedetotalEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne("id", id);
            }
            List<MechanicalleasedetotalEntity> proBillCode = service.list(queryWrapperBillCode);
            if (proBillCode != null && proBillCode.size() > 0) {
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }

        return entity;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MechanicalleasedetotalVO> queryDetail(Long id) {
    	MechanicalleasedetotalEntity entity = service.selectById(id);
    	MechanicalleasedetotalVO vo = BeanMapper.map(entity, MechanicalleasedetotalVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MechanicalleasedetotalVO> vos) {
        List<Long> idList = vos.stream().map(MechanicalleasedetotalVO::getId).collect(Collectors.toList());
        QueryWrapper<MechanicalleasedetotalEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr",0);
        queryWrapper.in("id",idList);
        List<MechanicalleasedetotalEntity> mechanicalleasedetotalEntities = service.list(queryWrapper);

        List<String> codeList = new ArrayList<>();
        for (MechanicalleasedetotalEntity entity : mechanicalleasedetotalEntities) {
            codeList.add(entity.getBillCode());
        }

        QueryWrapper<MechanicalleaseEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr",0);
        wrapper.in("reference_code",codeList);
        List<MechanicalleaseEntity> list = mechanicalleaseService.list(wrapper);
        //删除时去掉结算单的引用状态
        for (MechanicalleaseEntity entity : list) {
            entity.setIsReference(0);
            entity.setReferenceCode(null);
        }
        //保存结算单
        mechanicalleaseService.saveOrUpdateBatch(list);

        service.removeByIds(idList, true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MechanicalleasedetotalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<MechanicalleasedetotalEntity> page = service.queryPage(param,false);
        IPage<MechanicalleasedetotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MechanicalleasedetotalVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MechanicalleasedetotalEntity> list = service.queryList(param);
        //时间转换
        List<MechanicalleasedetotalVO> mechanicalleasedetotalVOList = BeanMapper.mapList(list, MechanicalleasedetotalVO.class);
        for (int i = 0; i < mechanicalleasedetotalVOList.size(); i++) {
            MechanicalleasedetotalVO mechanicalleasedetotalVO = mechanicalleasedetotalVOList.get(i);
            mechanicalleasedetotalVO.setSort(String.valueOf(i + 1));
            if (mechanicalleasedetotalVO.getStatisticalTime() != null) {
                mechanicalleasedetotalVO.setStatisticalTime(DateUtil.date(mechanicalleasedetotalVO.getStatisticalTime()));
            }
            String billStateStr = mechanicalleasedetotalVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }
                mechanicalleasedetotalVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", mechanicalleasedetotalVOList);
        ExcelExport.getInstance().export("mechanicalleasedetotalList-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMechanicalleasedetotalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MechanicalleasedetotalVO>> refMechanicalleasedetotalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MechanicalleasedetotalEntity> page = service.queryPage(param,false);
        IPage<MechanicalleasedetotalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MechanicalleasedetotalVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * 查询被引用的结算单
     *
     * @param id
     * @return
     */
    @RequestMapping(value = "/getSelectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>> getSelectId(Long id) {
        MechanicalleasedetotalEntity mechanicalleasedetotalEntity = service.selectById(id);
        String billCode = mechanicalleasedetotalEntity.getBillCode();
        QueryWrapper<MechanicalleaseEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("dr",0);
        wrapper.eq("reference_code",billCode);
        List<MechanicalleaseEntity> list = mechanicalleaseService.list(wrapper);
        List<Long> idList = new ArrayList<>();
        for (MechanicalleaseEntity entity : list) {
            idList.add(entity.getId());
        }

        return CommonResponse.success("查询成功！", idList);
    }

}
