package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.bean.MonthlyapprovalEntity;
import com.ejianc.business.middlemeasurement.service.IMonthlyapprovalService;
import com.ejianc.business.middlemeasurement.vo.MonthlyapprovalVO;

/**
 * 总包月度计量审批
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("monthlyapproval")
public class MonthlyapprovalController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private SessionManager sessionManager;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMonthlyapprovalService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthlyapprovalVO> saveOrUpdate(@RequestBody MonthlyapprovalVO saveorUpdateVO) throws ParseException {
    	MonthlyapprovalEntity entity = BeanMapper.map(saveorUpdateVO, MonthlyapprovalEntity.class);
        //校验：同一合同，只能存在一份自由态或审批中的单据
        checkBillStateUniq(entity.getId(), entity.getContractId());

        //校验：单据编号唯一性
        entity = checkBillCodeUniq(entity);

        //累计（包含本期）
        entity = handleCumulative(entity);

    	service.saveOrUpdate(entity, false);
    	MonthlyapprovalVO vo = BeanMapper.map(entity, MonthlyapprovalVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 同一合同，只能存在一份自由态或审批中的单据
     * @param id
     * @param contractId
     */
    private void checkBillStateUniq(Long id, Long contractId) {
        //创建条件构造器
        QueryWrapper<MonthlyapprovalEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
        queryWrapper.eq("dr", "0");
        if(id != null){
            queryWrapper.ne("id", id);
        }
        List<MonthlyapprovalEntity> pro = service.list(queryWrapper);
        if(pro != null && pro.size() > 0){
            throw new BusinessException("同一合同只能存在一份自由态或审批中的\"总包月度计量计量审批单据\"!");
        }
    }

    /**
     * 单据编码唯一性校验
     * @param entity
     */
    private MonthlyapprovalEntity checkBillCodeUniq(MonthlyapprovalEntity entity) {
        if(entity.getBillCode() == null || StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }else {
            //单据编码唯一性
            QueryWrapper<MonthlyapprovalEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("bill_code", entity.getBillCode());
            queryWrapperBillCode.eq("dr", "0");
            Long id = entity.getId();
            if(id != null){
                queryWrapperBillCode.ne("id", id);
            }
            List<MonthlyapprovalEntity> proBillCode = service.list(queryWrapperBillCode);
            if(proBillCode != null && proBillCode.size() > 0){
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }

        return entity;
    }

    /**
     * 累计（包含本期）
     * @param entity
     * @return
     */
    private MonthlyapprovalEntity handleCumulative(MonthlyapprovalEntity entity) {
        Date currentDate = new Date(System.currentTimeMillis());
        if(entity.getCreateTime() != null){
            currentDate = entity.getCreateTime();
        }
        //获取往期
        MonthlyapprovalVO pastVo = getPastTotalData(entity.getContractId(), currentDate);
        //本期 + 往期
        BigDecimal cumulativeOriginalContract = pastVo.getCumulativeOriginalContract();//原合同部分
        if(cumulativeOriginalContract != null && entity.getOriginalContract() != null){
            cumulativeOriginalContract = entity.getOriginalContract().add(cumulativeOriginalContract);//原合同部分
        }

        BigDecimal cumulativeChangeVisa = pastVo.getCumulativeChangeVisa();//变更签证部分
        if(cumulativeChangeVisa != null && entity.getChangeVisa() != null){
            cumulativeChangeVisa = entity.getChangeVisa().add(cumulativeChangeVisa);//变更签证部分
        }

        BigDecimal cumulativeCompensationReward = pastVo.getCumulativeCompensationReward();//补偿奖励部分
        if(cumulativeCompensationReward != null && entity.getCompensationReward() != null){
            cumulativeCompensationReward = entity.getCompensationReward().add(cumulativeCompensationReward);//补偿奖励部分
        }

        BigDecimal cumulativeTotalComplete = pastVo.getCumulativeTotalComplete();//合计
        if(cumulativeTotalComplete != null && entity.getThisMonthTotal() != null){
            cumulativeTotalComplete = entity.getThisMonthTotal().add(cumulativeTotalComplete);//合计
        }

        entity.setCumulativeOriginalContract(cumulativeOriginalContract);
        entity.setCumulativeChangeVisa(cumulativeChangeVisa);
        entity.setCumulativeCompensationReward(cumulativeCompensationReward);
        entity.setCumulativeTotalComplete(cumulativeTotalComplete);
        entity.setCumulativeTotal(cumulativeTotalComplete);

        return entity;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthlyapprovalVO> queryDetail(Long id) {
    	MonthlyapprovalEntity entity = service.selectById(id);
    	MonthlyapprovalVO vo = BeanMapper.map(entity, MonthlyapprovalVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthlyapprovalVO> vos) {
        service.removeByIds(vos.stream().map(MonthlyapprovalVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthlyapprovalVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<MonthlyapprovalEntity> page = service.queryPage(param,false);
        IPage<MonthlyapprovalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthlyapprovalVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<MonthlyapprovalEntity> list = service.queryList(param);
        //时间转换
        List<MonthlyapprovalVO> monthlyapprovalList = BeanMapper.mapList(list, MonthlyapprovalVO.class);
        for (int i = 0; i < monthlyapprovalList.size(); i++) {
            MonthlyapprovalVO monthlyapprovalVO = monthlyapprovalList.get(i);
            monthlyapprovalVO.setSort(String.valueOf(i+1));
            if (monthlyapprovalVO.getMeasurementTime()!=null){
                monthlyapprovalVO.setMeasurementTimeShow(DateUtils.dateSimple2(monthlyapprovalVO.getMeasurementTime()));
            }

            String billStateStr = monthlyapprovalVO.getBillState().toString();
            if (billStateStr != null){
                if("0".equals(billStateStr)){//自由态
                    billStateStr = "自由态";
                }else if("1".equals(billStateStr)){//已提交
                    billStateStr = "已提交";
                }else if("2".equals(billStateStr) || "5".equals(billStateStr)){//审批中
                    billStateStr = "审批中";
                }else if("3".equals(billStateStr)){//审批通过
                    billStateStr = "审批通过";
                }else if("4".equals(billStateStr)){//驳回
                    billStateStr = "驳回";
                }

                monthlyapprovalVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", monthlyapprovalList);
        ExcelExport.getInstance().export("MonthlyapprovalMain-export.xlsx", beans, response);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refMonthlyapprovalData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthlyapprovalVO>> refMonthlyapprovalData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MonthlyapprovalEntity> page = service.queryPage(param,false);
        IPage<MonthlyapprovalVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthlyapprovalVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description  查询往期
     * @param contractId
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthlyapprovalVO> pastData(Long id, Long contractId) {
        //校验：同一合同，只能存在一份自由态或审批中的单据
        checkBillStateUniq(id, contractId);

        //本期日期
        Date currentDate = new Date(System.currentTimeMillis());
        if(id != null && "".equals(id)){//更新
            MonthlyapprovalEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId 合同id
     * @param currentDate 本期日期
     */
    private MonthlyapprovalVO getPastTotalData(Long contractId, Date currentDate) {
        //创建条件构造器
        QueryWrapper<MonthlyapprovalEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("dr", "0");
        queryWrapperTotal.in("bill_state", 1, 3);//3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<MonthlyapprovalEntity> proTotal = service.list(queryWrapperTotal);

        BigDecimal cumulativeOriginalContract = new BigDecimal(0);
        BigDecimal cumulativeChangeVisa = new BigDecimal(0);
        BigDecimal cumulativeCompensationReward = new BigDecimal(0);
        BigDecimal cumulativeTotalComplete = new BigDecimal(0);
        if(proTotal != null && proTotal.size() > 0){
            for (int i = 0; i < proTotal.size(); i++) {
                MonthlyapprovalEntity monthlyapprovalEntity = proTotal.get(i);
                cumulativeOriginalContract = cumulativeOriginalContract.add(monthlyapprovalEntity.getOriginalContract());
                cumulativeChangeVisa = cumulativeChangeVisa.add(monthlyapprovalEntity.getChangeVisa());
                cumulativeCompensationReward = cumulativeCompensationReward.add(monthlyapprovalEntity.getCompensationReward());
                cumulativeTotalComplete = cumulativeTotalComplete.add(monthlyapprovalEntity.getThisMonthTotal());
            }
        }

        MonthlyapprovalVO vo = new MonthlyapprovalVO();
        vo.setCumulativeOriginalContract(cumulativeOriginalContract);
        vo.setCumulativeChangeVisa(cumulativeChangeVisa);
        vo.setCumulativeCompensationReward(cumulativeCompensationReward);
        vo.setCumulativeTotalComplete(cumulativeTotalComplete);
        vo.setCumulativeTotal(cumulativeTotalComplete);
        vo.setContractId(contractId);

        return vo;
    }
}
