package com.ejianc.business.middlemeasurement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.EngineermeasurementEntity;
import com.ejianc.business.middlemeasurement.service.IEngineermeasurementService;
import com.ejianc.business.middlemeasurement.vo.EngineermeasurementVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import java.io.Serializable;
import java.util.*;

/**
 * 工程计量台账
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/engineermeasurement")
public class EngineermeasurementApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IEngineermeasurementService service;

    /**
     * @Description 根据合同id查询详情
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryByContractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EngineermeasurementVO> queryByContractId(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.in("bill_state", 1, 3);
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByDesc("create_time");
        queryWrapper.last("limit 1");
        List<EngineermeasurementEntity> list = service.list(queryWrapper);
        EngineermeasurementVO result = new EngineermeasurementVO();
        if(list!=null&&list.size()>0){
            result = BeanMapper.map(list.get(0), EngineermeasurementVO.class);
        }
        return CommonResponse.success("查询数据成功！",result);
    }
}
