package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasedetailEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasedetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 月度周转租赁单清单导入导出
 */
@Controller
@RequestMapping("revolvingleaseExport")
public class ExcelRevolvingleaseController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRevolvingleasedetailService revolvingleasedetailService;

    @Autowired
    private IShareMaterialApi shareMaterialApi;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadRevolvinglease", method = RequestMethod.POST)
    @ResponseBody
    public void downloadRevolvinglease(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "revolvingleasedetail-import.xlsx", "月度周转租赁单清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportRevolvinglease", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportRevolvinglease(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<RevolvingleasedetailVO> successList = new ArrayList<>();
        List<RevolvingleasedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            HashMap<String, String> map = new HashMap<>();

            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    RevolvingleasedetailVO revolvingleasedetailVO = new RevolvingleasedetailVO();
                    CommonResponse<MaterialVO> back = null;
                    List<String> datas = result.get(i);
                    revolvingleasedetailVO.setId(IdWorker.getId());//id

                    if (datas.get(1) == null && StringUtils.isBlank(datas.get(1))) {
                        revolvingleasedetailVO.setErrorMsg("'物资编码'不能为空");
                        errorList.add(revolvingleasedetailVO);
                        continue;
                    }else{
                        revolvingleasedetailVO.setMaterialCode(StringUtils.isNotBlank(datas.get(1))?datas.get(1):null);
                    }

                    if (StringUtils.isBlank(datas.get(2)) && datas.get(2) == null) {
                        revolvingleasedetailVO.setErrorMsg("'物资名称'不能为空");
                        errorList.add(revolvingleasedetailVO);
                        continue;
                    }else{
                        revolvingleasedetailVO.setLesseeMaterialsName(StringUtils.isNotBlank(datas.get(2))?datas.get(2):null);
                    }

                    if (StringUtils.isBlank(datas.get(3)) && datas.get(3) == null) {
                        revolvingleasedetailVO.setErrorMsg("'规格型号'不能为空");
                        errorList.add(revolvingleasedetailVO);
                        continue;
                    }else{
                        revolvingleasedetailVO.setSpecifications(StringUtils.isNotBlank(datas.get(3))?datas.get(3):null);
                    }


                    //校验库中物资
                    CommonResponse<MaterialVO> back0 = shareMaterialApi.queryMaterialByCode(datas.get(1));
                    if (back0.getCode() == 1 || back0.getData() == null) {
                        revolvingleasedetailVO.setErrorMsg("未查询到该物资编码下的物资详情");
                        errorList.add(revolvingleasedetailVO);
                        continue;
                    }
                    if (StringUtils.isNotBlank(back0.getData().getName())) {
                        if (!back0.getData().getName().equals(datas.get(2))) {
                            revolvingleasedetailVO.setErrorMsg("'租赁物资名称'未在库中,请检查！");
                            errorList.add(revolvingleasedetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getSpec())) {
                        if (!back0.getData().getSpec().equals(datas.get(3))) {
                            revolvingleasedetailVO.setErrorMsg("'规格型号'未在库中,请检查！");
                            errorList.add(revolvingleasedetailVO);
                            continue;
                        }
                    }

                    if (StringUtils.isNotBlank(back0.getData().getUnitName())) {
                        if (!back0.getData().getUnitName().equals(datas.get(4))) {
                            revolvingleasedetailVO.setErrorMsg("'计量单位'未在库中,请检查！");
                            errorList.add(revolvingleasedetailVO);
                            continue;
                        }
                    }else{
                        revolvingleasedetailVO.setMeasurementUnit(StringUtils.isNotBlank(datas.get(4))?datas.get(4):null);

                    }


                    //物资名称三项是否重复
                    StringBuffer materConcat = new StringBuffer();
                    if (datas.get(3) != null && StringUtils.isNotBlank(datas.get(3))) {
                        materConcat.append(back0.getData().getCode()).append(back0.getData().getName()).append(back0.getData().getSpec());
                    }
                    if (datas.get(4) != null && StringUtils.isNotBlank(datas.get(4))) {
                        materConcat.append(back0.getData().getUnitName());
                    }
                    if (map.containsKey(materConcat.toString())) {
                        revolvingleasedetailVO.setErrorMsg("'物资编码','物资名称','物资规格','计量单位不能重复'");
                        errorList.add(revolvingleasedetailVO);
                        continue;
                    } else {
                        map.put(materConcat.toString(), materConcat.toString());
                    }

                    revolvingleasedetailVO.setMaterialCategoryId(back0.getData().getCategoryId());
                    revolvingleasedetailVO.setMaterialCategoryCode(back0.getData().getCode());
                    revolvingleasedetailVO.setMaterialCategoryName(back0.getData().getCategoryName());

                    BigDecimal num = new BigDecimal(0);

                    if (StringUtils.isBlank(datas.get(5)) || datas.get(5) == null) {
                        revolvingleasedetailVO.setErrorMsg("'租赁数量'不能为空");
                        if (!NumberUtil.isNumber(datas.get(5))) {
                            revolvingleasedetailVO.setErrorMsg("'租赁数量'格式错误");
                        }
                        errorList.add(revolvingleasedetailVO);
                    } else {
                        num = num.add(new BigDecimal((int) Float.parseFloat(datas.get(5))));
                        revolvingleasedetailVO.setLesseeQuantity(StringUtils.isNotBlank(datas.get(5)) ? Integer.valueOf((int) Float.parseFloat(datas.get(5))) : null); //  租赁数量
                    }

                    if (StringUtils.isNotBlank(datas.get(6)) && datas.get(6) != null) {
                        revolvingleasedetailVO.setSettleTime(DateUtils.Date(datas.get(6))); // 本期计算起始时间
                        if (!DateUtils.grepDate(datas.get(6))) {
                            revolvingleasedetailVO.setErrorMsg("'本期计算起始时间'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }
                    } else {
                        revolvingleasedetailVO.setErrorMsg("'本期计算起始时间'不能为空");
                        errorList.add(revolvingleasedetailVO);
                        continue;
                    }

                    if (StringUtils.isNotBlank(datas.get(7)) && datas.get(7) != null) {
                        revolvingleasedetailVO.setEndTime(DateUtils.Date(datas.get(7))); //本期计算终止时间
                        if (!DateUtils.grepDate(datas.get(7))) {
                            revolvingleasedetailVO.setErrorMsg("'本期计算终止时间'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }
                    } else {
                        revolvingleasedetailVO.setErrorMsg("'本期计算终止时间'不能为空");
                        errorList.add(revolvingleasedetailVO);
                        continue;
                    }

                    BigDecimal dayValue = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(8)) && datas.get(8) != null) {
                        Integer value = Integer.valueOf((int) Float.parseFloat(datas.get(8)));
                        if (!NumberUtil.isNumber(datas.get(8))) {
                            revolvingleasedetailVO.setErrorMsg("'本期租赁期长(天)'输入格式错误");
                            errorList.add(revolvingleasedetailVO);
                        } else {
                            revolvingleasedetailVO.setLesseeTerm(StringUtils.isNotBlank(datas.get(8)) ? value : null);//  本期租赁期长(天)
                        }
                    } else {
                        long between = DateUtil.between(DateUtils.Date(datas.get(6)), DateUtils.Date(datas.get(7)), DateUnit.DAY);
                        dayValue = new BigDecimal((int) between);
                        revolvingleasedetailVO.setLesseeTerm(Integer.valueOf((int) between)+1);
                    }

                    BigDecimal exUnitPrice = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(9)) && datas.get(9) != null) {
                        if (!NumberUtil.isNumber(datas.get(9))) {
                            revolvingleasedetailVO.setErrorMsg("'租赁单价(除税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            exUnitPrice = exUnitPrice.add(new BigDecimal(datas.get(9)));
                            revolvingleasedetailVO.setLesseeUnitprice(exUnitPrice);// 租赁单价(除税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setLesseeUnitprice(null);
                    }

                    BigDecimal inUnitPrice = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(10)) && datas.get(10) != null) {
                        if (!NumberUtil.isNumber(datas.get(10))) {
                            revolvingleasedetailVO.setErrorMsg("'租赁单价(含税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            inUnitPrice = inUnitPrice.add(new BigDecimal(datas.get(10)));
                            revolvingleasedetailVO.setTaxLesseeUnitprice(inUnitPrice);// 租赁单价(含税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setTaxLesseeUnitprice(null);
                    }

                    BigDecimal exTotal = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(11)) && datas.get(11) != null) {
                        if (!NumberUtil.isNumber(datas.get(11))) {
                            revolvingleasedetailVO.setErrorMsg("'租赁合价(除税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            exTotal = exTotal.add(num.multiply(dayValue).multiply(inUnitPrice));
                            revolvingleasedetailVO.setLesseeTotalprice(num.multiply(dayValue).multiply(exUnitPrice));// 租赁合价(除税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setLesseeTotalprice(null);
                    }

                    BigDecimal inTotal = new BigDecimal(0);
                    if (StringUtils.isNotBlank(datas.get(12)) && datas.get(12) != null) {
                        if (!NumberUtil.isNumber(datas.get(12))) {
                            revolvingleasedetailVO.setErrorMsg("'租赁合价(含税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            inTotal = inTotal.add(num.multiply(dayValue).multiply(inUnitPrice));
                            revolvingleasedetailVO.setTaxLesseeTotalprice(num.multiply(dayValue).multiply(inUnitPrice));// 租赁合价(含税)(元)
                        }
                    }else{
                        revolvingleasedetailVO.setTaxLesseeTotalprice(null);
                    }

                    BigDecimal findNum = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(13)) || datas.get(13) == null) {
                        revolvingleasedetailVO.setErrorMsg("'丢失损坏量'不能为空");
                        errorList.add(revolvingleasedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(13))) {
                            revolvingleasedetailVO.setErrorMsg("'丢失损坏量'输入格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            findNum = findNum.add(new BigDecimal(datas.get(13)));
                            revolvingleasedetailVO.setLossDamage(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : null);// 丢失损坏量
                        }
                    }

                    BigDecimal pexUnitPrice = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(14)) || datas.get(14) == null) {
                        revolvingleasedetailVO.setErrorMsg("'赔偿单价(除税)(元)'不能为空");
                        errorList.add(revolvingleasedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(14))) {
                            revolvingleasedetailVO.setErrorMsg("'赔偿单价(除税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            pexUnitPrice = pexUnitPrice.add(new BigDecimal(datas.get(14)));
                            revolvingleasedetailVO.setCompensateUnitprice(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : null);// 赔偿单价(除税)(元)
                        }
                     }

                    BigDecimal pinUnitPrice = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(15)) || datas.get(15) == null) {
                        revolvingleasedetailVO.setErrorMsg("'赔偿单价(含税)(元)'不能为空");
                        errorList.add(revolvingleasedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(15))) {
                            revolvingleasedetailVO.setErrorMsg("'赔偿单价(含税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            pinUnitPrice = pinUnitPrice.add(new BigDecimal(datas.get(15)));
                            revolvingleasedetailVO.setTaxCompensateUnitprice(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : null);// 赔偿单价(含税)(元)
                        }
                    }

                    BigDecimal exAmount = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(16)) || datas.get(16) == null) {
                        exAmount = exAmount.add(findNum.multiply(pexUnitPrice));
                        revolvingleasedetailVO.setCompensateAccount(exAmount);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(16))) {
                            revolvingleasedetailVO.setErrorMsg("'赔偿金额((除税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            revolvingleasedetailVO.setCompensateAccount(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : null);// 赔偿金额((除税)(元)
                        }
                    }

                    BigDecimal inAmount = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(17)) || datas.get(17) == null) {
                        inAmount = inAmount.add(findNum.multiply(pinUnitPrice));
                        revolvingleasedetailVO.setTaxCompensateAccount(inAmount);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(17))) {
                            revolvingleasedetailVO.setErrorMsg("' 赔偿金额((含税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            revolvingleasedetailVO.setTaxCompensateAccount(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : null);// 赔偿金额((含税)(元)
                        }
                    }

                    BigDecimal cleanEx = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(18)) || datas.get(18) == null) {
                        revolvingleasedetailVO.setErrorMsg("'清理维修费非等其他费用(除税)(元)'不能为空");
                        errorList.add(revolvingleasedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(18))) {
                            revolvingleasedetailVO.setErrorMsg("'清理维修费非等其他费用(除税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            cleanEx = cleanEx.add(new BigDecimal(datas.get(18)));
                            revolvingleasedetailVO.setOtherExpenses(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : null);// 清理维修费非等其他费用(除税)(元)
                        }
                    }

                    BigDecimal cleanIn = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(19)) || datas.get(19) == null) {
                        revolvingleasedetailVO.setErrorMsg("'清理维修费非等其他费用(含税)(元)'不能为空");
                        errorList.add(revolvingleasedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(19))) {
                            revolvingleasedetailVO.setErrorMsg("'清理维修费非等其他费用(含税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            cleanIn = cleanIn.add(new BigDecimal(datas.get(19)));
                            revolvingleasedetailVO.setTaxOtherExpenses(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) : null);// 清理维修费非等其他费用(含税)(元)
                        }
                     }

                    if (datas.get(20) == null || StringUtils.isBlank(datas.get(20))) {
                        revolvingleasedetailVO.setMonthlyExpenses(exTotal.add(exAmount).add(cleanEx));
                    } else {
                        if (!NumberUtil.isNumber(datas.get(20))) {
                            revolvingleasedetailVO.setErrorMsg("'月度结算费用(除税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            revolvingleasedetailVO.setMonthlyExpenses(StringUtils.isNotBlank(datas.get(20)) ? new BigDecimal(datas.get(20)) : null);// 月度结算费用(除税)(元)
                        }
                    }

                    if (datas.get(21) == null || StringUtils.isBlank(datas.get(21))) {
                        revolvingleasedetailVO.setTaxMonthlyExpenses(inTotal.add(inAmount).add(cleanIn));
                    } else {
                        if (!NumberUtil.isNumber(datas.get(21))) {
                            revolvingleasedetailVO.setErrorMsg("'月度结算费用(含税)(元)'格式错误");
                            errorList.add(revolvingleasedetailVO);
                        }else{
                            revolvingleasedetailVO.setTaxMonthlyExpenses(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) : null);// 月度结算费用(含税)(元)
                        }
                    }

                    revolvingleasedetailVO.setRemarks(StringUtils.isNotBlank(datas.get(22)) ? String.valueOf(datas.get(22)) : null); // 备注

                    if (errorList.size() == 0) {
                        successList.add(revolvingleasedetailVO);
                    }
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleaseFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleaseFromDatabase(@RequestBody RevolvingleaseVO revolvingleaseVO, HttpServletResponse response) {
        QueryWrapper<RevolvingleasedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", revolvingleaseVO.getId());
        queryWrapper.eq("dr", 0);
        List<RevolvingleasedetailEntity> list = revolvingleasedetailService.list(queryWrapper);
        List<RevolvingleasedetailVO> revolvingleasedetailVOList = BeanMapper.mapList(list, RevolvingleasedetailVO.class);
        if (revolvingleasedetailVOList != null && revolvingleasedetailVOList.size() > 0) {
            for (int i = 0; i < revolvingleasedetailVOList.size(); i++) {
                RevolvingleasedetailVO revolvingleasedetailVO = revolvingleasedetailVOList.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() != null) {
                    revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", revolvingleasedetailVOList);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleaseFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleaseFromPage(@RequestBody List<RevolvingleasedetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                RevolvingleasedetailVO revolvingleasedetailVO = list.get(i);
                revolvingleasedetailVO.setSort(String.valueOf(i + 1));
                if (revolvingleasedetailVO.getSettleTime() != null) {
                    revolvingleasedetailVO.setSettleTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getSettleTime()));
                }
                if (revolvingleasedetailVO.getEndTime() != null) {
                    revolvingleasedetailVO.setEndTimeShow(DateUtils.dateSimple(revolvingleasedetailVO.getEndTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("revolvingleasedetail-export.xlsx", beans, response);
    }

}
