package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasedetailEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasesummarydetailEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasesummarydetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasesummaryVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasesummarydetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.number.NumberUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 月度周转租赁结算汇总清单导入导出
 */
@Controller
@RequestMapping("revolvingleasesummaryExport")
public class ExcelRevolvingleasesummaryController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IRevolvingleasesummarydetailService revolvingleasesummarydetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadRevolvingleasesummary", method = RequestMethod.POST)
    @ResponseBody
    public void downloadRevolvingleasesummary(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "revolvingleasesummarydetail-import.xlsx", "月度周转租赁单清单模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportRevolvingleasesummary", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportRevolvingleasesummary(HttpServletRequest request, HttpServletResponse response, String revolvingleaseDetailVo) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<RevolvingleasesummarydetailVO> successList = new ArrayList<>();
        List<RevolvingleasesummarydetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            HashMap<String, String> frontMap = new HashMap<>();
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    RevolvingleasesummarydetailVO revolvingleasesummarydetailVO = new RevolvingleasesummarydetailVO();

                    List<String> datas = result.get(i);

                    List<RevolvingleasesummarydetailVO> revolvingleasesummarydetailVOS = JSON.parseArray(revolvingleaseDetailVo, RevolvingleasesummarydetailVO.class);
                    for (RevolvingleasesummarydetailVO vo : revolvingleasesummarydetailVOS) {
                        StringBuffer materBuffer = new StringBuffer();
                        if (vo.getContractName() != null && StringUtils.isNotBlank(vo.getContractName())) {
                            materBuffer.append(vo.getContractName());
                        }
                        if (vo.getMaterialCode() != null && StringUtils.isNotBlank(vo.getMaterialCode())) {
                            materBuffer.append(vo.getMaterialCode());
                        }
                        if (vo.getCategoryName() != null && StringUtils.isNotBlank(vo.getCategoryName())) {
                            materBuffer.append(vo.getCategoryName());
                        }
                        if (vo.getLesseeName() != null && StringUtils.isNotBlank(vo.getLesseeName())) {
                            materBuffer.append(vo.getLesseeName());
                        }
                        if (vo.getPaymentProportion() != null) {
                            materBuffer.append(vo.getPaymentProportion());
                        }
                        frontMap.put(materBuffer.toString(), materBuffer.toString());
                    }
                    revolvingleasesummarydetailVO.setId(IdWorker.getId());//id

                    revolvingleasesummarydetailVO.setContractName(StringUtils.isNotBlank(datas.get(1)) ? String.valueOf(datas.get(1)) : null); // 合同名称
                    revolvingleasesummarydetailVO.setMaterialCategoryCode(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); //物资编码
                    revolvingleasesummarydetailVO.setCategoryName(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); //设备类别/名称
                    revolvingleasesummarydetailVO.setLesseeName(StringUtils.isNotBlank(datas.get(4)) ? datas.get(4) : null); //  租赁商名称
                    revolvingleasesummarydetailVO.setPaymentProportion(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null);// 合同付款比例

                    String keyValue = frontMap.get(datas.get(1) + datas.get(2) + datas.get(3) + datas.get(4) + datas.get(9));

                    if (keyValue != null && StringUtils.isNotBlank(keyValue)) {

                    } else {
                        revolvingleasesummarydetailVO.setErrorMsg("'合同名称,物资编号,设备类别,租赁商名称,合同付款比例'与参照内容不符,请检查!");
                        errorList.add(revolvingleasesummarydetailVO);
                    }

                    for (RevolvingleasesummarydetailVO vos : revolvingleasesummarydetailVOS) {
                        if(vos.getPaymentProportion()==null){
                            if(vos.getContractName().equals(datas.get(1)) && vos.getMaterialCode().equals(datas.get(2)) && vos.getCategoryName().equals(datas.get(3)) &&
                                    vos.getLesseeName().equals(datas.get(4))){
                                revolvingleasesummarydetailVO.setSettleAccount(vos.getSettleAccount()); //  本月结算金额(除税)
                                revolvingleasesummarydetailVO.setTaxSettleAccount(vos.getTaxSettleAccount()); // 本月结算金额(含税)
                                revolvingleasesummarydetailVO.setCumulativeAmount(vos.getCumulativeAmount()); //累计结算金额(除税)
                                revolvingleasesummarydetailVO.setTaxCumulativeAmount(vos.getTaxCumulativeAmount());//  累计结算金额(含税)
                            }
                        }else{
                            if(vos.getContractName().equals(datas.get(1)) && vos.getMaterialCode().equals(datas.get(2)) && vos.getCategoryName().equals(datas.get(3)) &&
                                    vos.getLesseeName().equals(datas.get(4)) && vos.getPaymentProportion().equals(datas.get(9))){
                                revolvingleasesummarydetailVO.setSettleAccount(vos.getSettleAccount()); //  本月结算金额(除税)
                                revolvingleasesummarydetailVO.setTaxSettleAccount(vos.getTaxSettleAccount()); // 本月结算金额(含税)
                                revolvingleasesummarydetailVO.setCumulativeAmount(vos.getCumulativeAmount()); //累计结算金额(除税)
                                revolvingleasesummarydetailVO.setTaxCumulativeAmount(vos.getTaxCumulativeAmount());//  累计结算金额(含税)
                            }
                        }
                    }

                    if (StringUtils.isBlank(datas.get(10)) || datas.get(10) == null) {
                        revolvingleasesummarydetailVO.setErrorMsg("'至本月累计应付款金额'不能为空");
                        errorList.add(revolvingleasesummarydetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(10))) {
                            revolvingleasesummarydetailVO.setErrorMsg("'至本月累计应付款金额'格式错误");
                            errorList.add(revolvingleasesummarydetailVO);
                        }else{
                            revolvingleasesummarydetailVO.setCumulativePayable(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : null);// 至本月累计应付款金额
                        }

                    }

                    if (StringUtils.isBlank(datas.get(11)) || datas.get(11) == null) {
                        revolvingleasesummarydetailVO.setErrorMsg("'至本月累计付款金额'不能为空");
                        errorList.add(revolvingleasesummarydetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(11))) {
                            revolvingleasesummarydetailVO.setErrorMsg("'至本月累计付款金额'格式错误");
                            errorList.add(revolvingleasesummarydetailVO);
                        }else{
                            revolvingleasesummarydetailVO.setCumulativePayment(StringUtils.isNotBlank(datas.get(11)) ? new BigDecimal(datas.get(11)) : null);// 至本月累计付款金额
                        }

                    }

                    if (StringUtils.isBlank(datas.get(12)) || datas.get(12) == null) {
                        revolvingleasesummarydetailVO.setErrorMsg("'联系人'不能为空");
                        errorList.add(revolvingleasesummarydetailVO);
                    } else {
                        revolvingleasesummarydetailVO.setContacts(StringUtils.isNotBlank(datas.get(12)) ? datas.get(12) : null);// 联系人
                    }

                    if (StringUtils.isBlank(datas.get(13)) || datas.get(13) == null) {
                        revolvingleasesummarydetailVO.setErrorMsg("'联系方式'不能为空");
                        errorList.add(revolvingleasesummarydetailVO);
                    } else {
                        revolvingleasesummarydetailVO.setContactsWay(StringUtils.isNotBlank(datas.get(13)) ? datas.get(13) : null);// 联系方式
                    }

                    revolvingleasesummarydetailVO.setRemarks(StringUtils.isNotBlank(datas.get(14)) ? String.valueOf(datas.get(14)) : null); // 备注

                    if(CollectionUtil.isEmpty(errorList)){
                        successList.add(revolvingleasesummarydetailVO);
                    }
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleasesummaryFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleasesummaryFromDatabase(@RequestBody RevolvingleasesummaryVO revolvingleaseVO, HttpServletResponse response) {
        QueryWrapper<RevolvingleasesummarydetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", revolvingleaseVO.getId());
        queryWrapper.eq("dr", 0);
        List<RevolvingleasesummarydetailEntity> list = revolvingleasesummarydetailService.list(queryWrapper);
        List<RevolvingleasesummarydetailVO> revolvingleasesummarydetailVOList = BeanMapper.mapList(list, RevolvingleasesummarydetailVO.class);
        if (revolvingleasesummarydetailVOList != null && revolvingleasesummarydetailVOList.size() > 0) {
            for (int i = 0; i < revolvingleasesummarydetailVOList.size(); i++) {
                RevolvingleasesummarydetailVO revolvingleasesummarydetailVO = revolvingleasesummarydetailVOList.get(i);
                revolvingleasesummarydetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", revolvingleasesummarydetailVOList);
        ExcelExport.getInstance().export("revolvingleasesummarydetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportRevolvingleasesummaryFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportRevolvingleasesummaryFromPage(@RequestBody List<RevolvingleasesummarydetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                RevolvingleasesummarydetailVO revolvingleasesummarydetailVO = list.get(i);
                revolvingleasesummarydetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("revolvingleasesummarydetail-export.xlsx", beans, response);
    }

}
