package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodedetailEntity;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodedetailService;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("designsubcontractnodeExport")
public class ExceldesignsubcontractnodeController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDesignsubcontractnodedetailService detailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDesignsubcontractnode", method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "designsubcontractnode-import.xlsx", "设计分包节点报量申请模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportDesignsubcontractnode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInterimsettlement(HttpServletRequest request, HttpServletResponse response, Long contract, Long projectId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DesignsubcontractnodedetailVO> successList = new ArrayList<>();
        List<DesignsubcontractnodedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);


         /*   QueryWrapper<DesignsubcontractnodedetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_state",3);
            List<DesignsubcontractnodedetailEntity> list = detailService.list(wrapper);
            if(CollectionUtil.isEmpty(list)){
                throw new RuntimeException("暂无审批通过的数据");
            }
*/
            if (result != null && result.size() > 0) {
                for (int i = 2; i < result.size(); i++) {
                    DesignsubcontractnodedetailVO designsubcontractnodedetailVO = new DesignsubcontractnodedetailVO();
                    List<String> datas = result.get(i);
                    designsubcontractnodedetailVO.setSort(String.valueOf(IdWorker.getId()));//id
                    //设置子表合同id
                    designsubcontractnodedetailVO.setContract(contract);
                    //设置子表项目id
                    designsubcontractnodedetailVO.setProjectId(projectId);
                    //查询子表累计
                    QueryWrapper<DesignsubcontractnodedetailEntity> wrapper = new QueryWrapper<>();
                    wrapper.eq("dr", 0);
                    wrapper.eq("contract", contract);
                    wrapper.eq("project_id", projectId);
                    wrapper.in("bill_state", 1, 3);
                    wrapper.orderByDesc("create_time");
                    wrapper.last("limit 0,1");
                    List<DesignsubcontractnodedetailEntity> designsubcontractnodedetailEntityList = detailService.list(wrapper);

                    //累计审核
                    BigDecimal completeAmt = new BigDecimal(0);
                    BigDecimal exTaxUnitAmt = new BigDecimal(0);
                    BigDecimal inTaxUnitAmt = new BigDecimal(0);

                    //先导入与往期无关的列
                    designsubcontractnodedetailVO.setId(IdWorker.getId());
                    designsubcontractnodedetailVO.setCompleteContent(StringUtils.isNotBlank(datas.get(0)) ? String.valueOf(datas.get(0)) : null); // 完成内容

                    if (StringUtils.isBlank(datas.get(1)) || datas.get(1) == null) {
                        designsubcontractnodedetailVO.setErrorMsg("'项目名称'不能为空");
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        designsubcontractnodedetailVO.setProjectName(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 项目名称
                    }

                    if (StringUtils.isBlank(datas.get(2)) || datas.get(2) == null) {
                        designsubcontractnodedetailVO.setErrorMsg("'计量单位'不能为空");
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        designsubcontractnodedetailVO.setMeasuringUnit(StringUtils.isNotBlank(datas.get(2)) ? String.valueOf(datas.get(2)) : null); //计量单位
                    }

                    BigDecimal completeThisDeclare = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(3)) || datas.get(3) == null) {
                        designsubcontractnodedetailVO.setErrorMsg("'完成量（本期申报）'不能为空");
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(3))) {
                            designsubcontractnodedetailVO.setErrorMsg("'完成量（本期申报）'格式错误");
                            errorList.add(designsubcontractnodedetailVO);
                        } else {
                            completeThisDeclare = new BigDecimal(datas.get(3));
                            designsubcontractnodedetailVO.setCompleteThisDeclare(StringUtils.isNotBlank(datas.get(3)) ? new BigDecimal(datas.get(3)) : new BigDecimal(0)); //  完成量（本期申报）
                        }
                    }

                    BigDecimal exTaxUnitThisDeclare = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(4)) || datas.get(4) == null) {
                        designsubcontractnodedetailVO.setErrorMsg("'除税单价（本期申报）'不能为空");
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(4))) {
                            designsubcontractnodedetailVO.setErrorMsg("'除税单价（本期申报）'格式错误");
                            errorList.add(designsubcontractnodedetailVO);
                        } else {
                            exTaxUnitThisDeclare = new BigDecimal(datas.get(4));
                            designsubcontractnodedetailVO.setExTaxUnitThisDeclare(StringUtils.isNotBlank(datas.get(4)) ? new BigDecimal(datas.get(4)) : new BigDecimal(0)); // 除税单价（本期申报）
                        }
                    }

                    BigDecimal inTaxUnitThisDeclare = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(5)) || datas.get(5) == null) {
                        designsubcontractnodedetailVO.setErrorMsg("'含税单价（本期申报）'不能为空");
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(5))) {
                            designsubcontractnodedetailVO.setErrorMsg("'含税单价（本期申报）'格式错误");
                            errorList.add(designsubcontractnodedetailVO);
                        } else {
                            inTaxUnitThisDeclare = new BigDecimal(datas.get(5));
                            designsubcontractnodedetailVO.setInTaxUnitThisDeclare(StringUtils.isNotBlank(datas.get(5)) ? new BigDecimal(datas.get(5)) : new BigDecimal(0)); // 含税单价（本期申报）
                        }
                    }

                    if (StringUtils.isBlank(datas.get(6)) || datas.get(6) == null) {
                        designsubcontractnodedetailVO.setExTaxTotalThisDeclare(completeThisDeclare.multiply(exTaxUnitThisDeclare));
                    } else {
                        designsubcontractnodedetailVO.setExTaxTotalThisDeclare(StringUtils.isNotBlank(datas.get(6)) ? new BigDecimal(datas.get(6)) : new BigDecimal(0)); //除税合价（本期申报）
                    }

                    if (StringUtils.isBlank(datas.get(7)) || datas.get(7) == null) {
                        designsubcontractnodedetailVO.setInTaxTotalThisDeclare(completeThisDeclare.multiply(inTaxUnitThisDeclare));
                    } else {
                        designsubcontractnodedetailVO.setInTaxTotalThisDeclare(StringUtils.isNotBlank(datas.get(7)) ? new BigDecimal(datas.get(7)) : new BigDecimal(0));// 含税合价（本期申报）
                    }


                    BigDecimal completeThisAudits = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(13)) || datas.get(13) == null) {
                        designsubcontractnodedetailVO.setErrorMsg("'完成量（本期审核）'不能为空");
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(13))) {
                            designsubcontractnodedetailVO.setErrorMsg("'完成量（本期审核）'格式错误");
                            errorList.add(designsubcontractnodedetailVO);
                        } else {
                            completeThisAudits = new BigDecimal(datas.get(13));
                            designsubcontractnodedetailVO.setCompleteThisAudit(StringUtils.isNotBlank(datas.get(13)) ? new BigDecimal(datas.get(13)) : new BigDecimal(0)); // 完成量（本期审核）
                        }
                    }

                    BigDecimal exTaxUnitThisAudits = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(14)) || datas.get(14) == null) {
                        designsubcontractnodedetailVO.setErrorMsg("'除税单价（本期审核）'不能为空");
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(14))) {
                            designsubcontractnodedetailVO.setErrorMsg("'除税单价（本期审核）'格式错误");
                            errorList.add(designsubcontractnodedetailVO);
                        } else {
                            exTaxUnitThisAudits = new BigDecimal(datas.get(14));
                            designsubcontractnodedetailVO.setExTaxUnitThisAudit(StringUtils.isNotBlank(datas.get(14)) ? new BigDecimal(datas.get(14)) : new BigDecimal(0)); // 除税单价（本期审核）
                        }
                    }

                    BigDecimal inTaxUnitThisAudits = new BigDecimal(0);
                    if (StringUtils.isBlank(datas.get(15)) || datas.get(15) == null) {
                        designsubcontractnodedetailVO.setErrorMsg("'含税单价（本期审核）'不能为空");
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(15))) {
                            designsubcontractnodedetailVO.setErrorMsg("'含税单价（本期审核）'格式错误");
                            errorList.add(designsubcontractnodedetailVO);
                        } else {
                            inTaxUnitThisAudits = new BigDecimal(datas.get(15));
                            designsubcontractnodedetailVO.setInTaxUnitThisAudit(StringUtils.isNotBlank(datas.get(15)) ? new BigDecimal(datas.get(15)) : new BigDecimal(0));// 含税单价（本期审核）
                        }
                    }

                    if (StringUtils.isBlank(datas.get(16)) || datas.get(16) == null) {
                        designsubcontractnodedetailVO.setExTaxTotalThisAudit(completeThisAudits.multiply(exTaxUnitThisAudits));
                    } else {
                        designsubcontractnodedetailVO.setExTaxTotalThisAudit(StringUtils.isNotBlank(datas.get(16)) ? new BigDecimal(datas.get(16)) : new BigDecimal(0));// 除税合价（本期审核）
                    }

                    if (StringUtils.isBlank(datas.get(17)) || datas.get(17) == null) {
                        designsubcontractnodedetailVO.setInTaxTotalThisAudit(completeThisAudits.multiply(inTaxUnitThisAudits));
                    } else {
                        designsubcontractnodedetailVO.setInTaxTotalThisAudit(StringUtils.isNotBlank(datas.get(17)) ? new BigDecimal(datas.get(17)) : new BigDecimal(0)); // 含税合价（本期审核）
                    }


                    //导入与往期有关的列
                    if (CollectionUtil.isNotEmpty(designsubcontractnodedetailEntityList)) {
                        //往期数据不为空
                        DesignsubcontractnodedetailEntity data = designsubcontractnodedetailEntityList.get(0);

                        //完成量（累计审核）
                        BigDecimal completeThisAudit = data.getCompleteThisAudit() == null ? new BigDecimal(0) : data.getCompleteThisAudit();
                        //除税单价（累计审核）
                        BigDecimal exTaxUnitThisAudit = data.getExTaxUnitThisAudit() == null ? new BigDecimal(0) : data.getExTaxUnitThisAudit();
                        //含税单价（累计审核）
                        BigDecimal inTaxUnitThisAudit = data.getInTaxUnitThisAudit() == null ? new BigDecimal(0) : data.getInTaxUnitThisAudit();

                        //上期累计带入
                        designsubcontractnodedetailVO.setCompleteLastAudit(completeThisAudit);

                        designsubcontractnodedetailVO.setExTaxUnitLastAudit(exTaxUnitThisAudit);

                        designsubcontractnodedetailVO.setInTaxUnitLastAudit(inTaxUnitThisAudit);

                        designsubcontractnodedetailVO.setExTaxTotalLastAudit(completeThisAudit.multiply(exTaxUnitThisAudit));

                        designsubcontractnodedetailVO.setInTaxTotalLastAudit(completeThisAudit.multiply(inTaxUnitThisAudit));

                        if (StringUtils.isBlank(datas.get(18)) || datas.get(18) == null) {
                            completeAmt = completeThisAudit.add(completeThisAudits);  //累计完成 = 本期完成+上期审核完成
                            designsubcontractnodedetailVO.setCompleteCumulativeAudit(completeAmt);
                        } else {
                            designsubcontractnodedetailVO.setCompleteCumulativeAudit(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : new BigDecimal(0)); // 完成量（累计审核）
                        }

                        if (StringUtils.isBlank(datas.get(19)) || datas.get(19) == null) {
                            exTaxUnitAmt = exTaxUnitThisAudit.add(exTaxUnitThisAudits);  //累计除税 = 本期除税+上期审核除税
                            designsubcontractnodedetailVO.setExTaxUnitCumulativeAudit(exTaxUnitAmt);
                        } else {
                            designsubcontractnodedetailVO.setExTaxUnitCumulativeAudit(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) : new BigDecimal(0)); //除税单价（累计审核）
                        }

                        if (StringUtils.isBlank(datas.get(20)) || datas.get(20) == null) {
                            inTaxUnitAmt = inTaxUnitThisAudit.add(inTaxUnitThisAudits);  //累计含税 = 本期含税+上期审核含税
                            designsubcontractnodedetailVO.setInTaxUnitCumulativeAudit(inTaxUnitAmt);
                        } else {
                            designsubcontractnodedetailVO.setInTaxUnitCumulativeAudit(StringUtils.isNotBlank(datas.get(20)) ? new BigDecimal(datas.get(20)) : new BigDecimal(0));//  含税单价（累计审核）
                        }

                        if (StringUtils.isBlank(datas.get(21)) || datas.get(21) == null) {
                            designsubcontractnodedetailVO.setExTaxTotalCumulativeAudit(completeAmt.multiply(exTaxUnitAmt));
                        } else {
                            designsubcontractnodedetailVO.setExTaxTotalCumulativeAudit(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) : new BigDecimal(0));//含税合价（累计审核）
                        }

                        if (StringUtils.isBlank(datas.get(22)) || datas.get(22) == null) {
                            designsubcontractnodedetailVO.setInTaxTotalCumulativeAudit(completeAmt.multiply(inTaxUnitAmt));
                        } else {
                            designsubcontractnodedetailVO.setInTaxTotalCumulativeAudit(StringUtils.isNotBlank(datas.get(22)) ? new BigDecimal(datas.get(22)) : new BigDecimal(0)); // 含税合价（累计审核）
                        }

                    } else {
                        //往期数据为空

                        designsubcontractnodedetailVO.setCompleteLastAudit(null);

                        designsubcontractnodedetailVO.setExTaxUnitLastAudit(null);

                        designsubcontractnodedetailVO.setInTaxUnitLastAudit(null);

                        designsubcontractnodedetailVO.setExTaxTotalLastAudit(null);

                        designsubcontractnodedetailVO.setInTaxTotalLastAudit(null);

                        if (StringUtils.isBlank(datas.get(18)) || datas.get(18) == null) {
                            designsubcontractnodedetailVO.setCompleteCumulativeAudit(null);
                        } else {
                            designsubcontractnodedetailVO.setCompleteCumulativeAudit(StringUtils.isNotBlank(datas.get(18)) ? new BigDecimal(datas.get(18)) : new BigDecimal(0)); // 完成量（累计审核）
                        }

                        if (StringUtils.isBlank(datas.get(19)) || datas.get(19) == null) {
                            designsubcontractnodedetailVO.setExTaxUnitCumulativeAudit(null);
                        } else {
                            designsubcontractnodedetailVO.setExTaxUnitCumulativeAudit(StringUtils.isNotBlank(datas.get(19)) ? new BigDecimal(datas.get(19)) : new BigDecimal(0)); //除税单价（累计审核）
                        }

                        if (StringUtils.isBlank(datas.get(20)) || datas.get(20) == null) {
                            designsubcontractnodedetailVO.setInTaxUnitCumulativeAudit(null);
                        } else {
                            designsubcontractnodedetailVO.setInTaxUnitCumulativeAudit(StringUtils.isNotBlank(datas.get(20)) ? new BigDecimal(datas.get(20)) : new BigDecimal(0));//  含税单价（累计审核）
                        }

                        if (StringUtils.isBlank(datas.get(21)) || datas.get(21) == null) {
                            designsubcontractnodedetailVO.setExTaxTotalCumulativeAudit(null);
                        } else {
                            designsubcontractnodedetailVO.setExTaxTotalCumulativeAudit(StringUtils.isNotBlank(datas.get(21)) ? new BigDecimal(datas.get(21)) : new BigDecimal(0));//含税合价（累计审核）
                        }

                        if (StringUtils.isBlank(datas.get(22)) || datas.get(22) == null) {
                            designsubcontractnodedetailVO.setInTaxTotalCumulativeAudit(null);
                        } else {
                            designsubcontractnodedetailVO.setInTaxTotalCumulativeAudit(StringUtils.isNotBlank(datas.get(22)) ? new BigDecimal(datas.get(22)) : new BigDecimal(0)); // 含税合价（累计审核）
                        }

                    }

                    designsubcontractnodedetailVO.setRemarks(StringUtils.isNotBlank(datas.get(23)) ? String.valueOf(datas.get(23)) : null); // 备注

                    if (CollectionUtil.isEmpty(errorList)) {
                        successList.add(designsubcontractnodedetailVO);
                    }
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDesignsubcontractnodeFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody DesignsubcontractnodedetailVO
                                                              detailVo, HttpServletResponse response) {
        QueryWrapper<DesignsubcontractnodedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<DesignsubcontractnodedetailEntity> list = detailService.list(queryWrapper);
        List<DesignsubcontractnodedetailVO> designsubcontractnodedetailVOList = BeanMapper.mapList(list, DesignsubcontractnodedetailVO.class);
        if (designsubcontractnodedetailVOList != null && designsubcontractnodedetailVOList.size() > 0) {
            for (int i = 0; i < designsubcontractnodedetailVOList.size(); i++) {
                DesignsubcontractnodedetailVO designsubcontractnodedetailVO = designsubcontractnodedetailVOList.get(i);
                designsubcontractnodedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", designsubcontractnodedetailVOList);
        ExcelExport.getInstance().export("designsubcontractnode-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDesignsubcontractnodeFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage
    (@RequestBody List<DesignsubcontractnodedetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                DesignsubcontractnodedetailVO designsubcontractnodedetailVO = list.get(i);
                designsubcontractnodedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designsubcontractnode-export.xlsx", beans, response);
    }


}
