package com.ejianc.business.middlemeasurement.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.vo.CapitalinflowsVO;
import com.ejianc.business.middlemeasurement.vo.CreditorsrightsVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.middlemeasurement.mapper.CreditorsrightsMapper;
import com.ejianc.business.middlemeasurement.bean.CreditorsrightsEntity;
import com.ejianc.business.middlemeasurement.service.ICreditorsrightsService;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * 债权情况
 * 
 * @author generator
 * 
 */
@Service("creditorsrightsService")
public class CreditorsrightsServiceImpl extends BaseServiceImpl<CreditorsrightsMapper, CreditorsrightsEntity> implements ICreditorsrightsService{

    //日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Autowired
    private ICreditorsrightsService service;

    @Autowired
    private RestHighLevelClient client;


    private final static String ESSignStatistic = "ejc_creditorsrights_report";

    @Override
    public CommonResponse<String> saveSnapshotData() {
        String curDate = this.getLastMonth();
        //资金流入报表统计
        new Thread(() -> {
            try {
                service.saveESData("债权情况" + DateUtil.now());
            } catch (Exception e) {
                logger.error("债权情况报表数据异常，", e);
            }
        }).start();

        return CommonResponse.success("保存快照成功");
    }

    @Override
    public CommonResponse<String> saveESData(String reportName) {

        //获取当前mysql数据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        List<CreditorsrightsEntity> list = service.queryList(queryParam);

        //构建es请求
        BulkRequest bulkRequest = new BulkRequest();
        for (CreditorsrightsEntity entity : list) {
            try {
                CreditorsrightsVO vo = BeanMapper.map(entity, CreditorsrightsVO.class);
                Map<String, Object> dataMap = BeanMapper.map(vo, Map.class);
                dataMap.put("id",IdWorker.getId());
                dataMap.put("reportId", entity.getId().toString());
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
                dataMap.put("snapShotTime", format.format(new Date()));
                dataMap.put("snapShotVersion", reportName);
                IndexRequest indexRequest = new IndexRequest(ESSignStatistic);
                indexRequest.source(dataMap, XContentType.JSON);
                bulkRequest.add(indexRequest);
            } catch (Exception e) {
                logger.error("生成债权情况统计数据异常，", e);
                throw new BusinessException("生成债权情况统计数据异常");
            }
        }
        try {
            bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            client.bulk(bulkRequest, RequestOptions.DEFAULT);
        } catch (IOException e) {
            logger.info("生成ES数据失败:---->" + e.getMessage());
            throw new BusinessException("生成ES数据失败:---->" + e.getMessage());
        }

        logger.info("***********生成债权情况统计执行 完事 *********** ");
        return CommonResponse.success("生成债权情况统计成功");
    }

    @Override
    public IPage<CreditorsrightsVO> queryEsByPage(QueryParam param,String monthQuery,String reportItem) {

        // 搜索请求对象
        SearchRequest searchRequest = new SearchRequest(ESSignStatistic);
        // 指定类型
        searchRequest.searchType(SearchType.DEFAULT);

        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        Map<String, Parameter> parameterMap = param.getParams();
        List<QueryBuilder> listQuery = new ArrayList<>();
        List<QueryBuilder> mustQuery = new ArrayList<>();

        //筛选项配置
        if(param.getSearchText()!=null && StringUtils.isNotBlank(param.getSearchText()) ){
            for (String field : param.getFuzzyFields()) {
                listQuery.add(QueryBuilders.matchPhraseQuery(field,param.getSearchText()));
            }
        }
        if (reportItem != null && StringUtils.isNotBlank(reportItem)) {
            mustQuery.add(QueryBuilders.matchPhraseQuery("snapShotVersion", reportItem));
        }


        /*AggregationBuilder termsAggregationBuilder = AggregationBuilders.sum("projectNameAgg").field("projectName.keyword");
        sourceBuilder.aggregation(termsAggregationBuilder);*/

        //分页配置
        Integer pageIndex = param.getPageIndex();
        Integer pageSize = param.getPageSize();
        sourceBuilder.from(pageIndex <= 0 ? 0 : (pageIndex-1)*pageSize);
        sourceBuilder.size(pageSize);
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.timeout(new TimeValue(60, TimeUnit.SECONDS)); //设置超时时间


        //搜索源配置
        boolBuilder.should().addAll(listQuery);
        boolBuilder.must().addAll(mustQuery);
       // sourceBuilder.sort("projectName",SortOrder.ASC);
        sourceBuilder.query(boolBuilder);
        searchRequest.source(sourceBuilder);


        try {
            SearchResponse searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);

            // 搜索结果
            SearchHits hits = searchResponse.getHits();
            Integer count = 0;
            Integer idCount = 1;
            // 得到匹配度高的文档
            SearchHit[] searchHits = hits.getHits();
            if (searchHits.length <= 0) {
                return null;
            }
            Page<CreditorsrightsVO> voPage = new Page<>();
            ArrayList<CreditorsrightsVO> list = new ArrayList<>();
            for (SearchHit hit : searchHits) {
                idCount++;
                JSONObject json = new JSONObject(hit.getSourceAsMap());
                CreditorsrightsVO vo = JSONObject.toJavaObject(json, CreditorsrightsVO.class);
                vo.setId(Long.valueOf(idCount));
                if (vo.getSnapShotTime() != null) {
                    vo.setSnapShotTime(vo.getSnapShotTime());
                }
                if(vo.getSnapShotVersion().equals(reportItem)){

                    list.add(vo);
                }
                count++;
            }
            voPage.setTotal(count);
            voPage.setSize(pageSize);
            voPage.setPages(pageIndex <= 0 ? 0 : (pageIndex - 1) * pageSize);


            List<CreditorsrightsVO> collect = list.stream().filter(item -> item.getBillState() == 1 || item.getBillState() == 3).collect(Collectors.toList());
            HashMap<String, CreditorsrightsVO> map = new HashMap<>();
            for (int j = 0; j<collect.size(); j++) {
                CreditorsrightsVO creditorsrightsVO = collect.get(j);
                String projectName = creditorsrightsVO.getProjectName();
                if(map.containsKey(projectName)){
                    int i = map.get(projectName).getSaveTime().compareTo(collect.get(j).getSaveTime());
                    if(i<0){
                        map.put(projectName,creditorsrightsVO);
                    }
                }else{
                    map.put(projectName,creditorsrightsVO);
                }
            }
            List<CreditorsrightsVO> values = map.values().stream().collect(Collectors.toList());
            values.sort(((o1, o2) -> o1.getProjectName().compareTo(o2.getProjectName())));
            return voPage.setRecords(list);
        } catch (IOException e) {
            throw new RuntimeException("ES查询异常" + e);
        }

    }

    @Override
    public List<String> queryEsSnap(String monthQuery) {
        // 搜索请求对象
        SearchRequest searchRequest = new SearchRequest(ESSignStatistic);
        // 指定类型
        searchRequest.searchType(SearchType.DEFAULT);

        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolBuilder = QueryBuilders.boolQuery();
        List<QueryBuilder> listQuery = new ArrayList<>();
        List<QueryBuilder> mustQuery = new ArrayList<>();
        if(StringUtils.isNotEmpty(monthQuery) && monthQuery != null){
            mustQuery.add(QueryBuilders.matchPhraseQuery("snapShotTime",monthQuery));
        }
        //搜索源配置
        boolBuilder.should().addAll(listQuery);
        boolBuilder.must().addAll(mustQuery);
        sourceBuilder.query(boolBuilder);
        searchRequest.source(sourceBuilder);

        ArrayList<String> list = new ArrayList<>();
        try {
            SearchResponse  searchResponse = client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = searchResponse.getHits();
            SearchHit[] searchHits = hits.getHits();
            TreeSet<String> set = new TreeSet<>();
            for (SearchHit hit : searchHits) {
                // 源文档内容
                Map<String, Object> sourceAsMap = hit.getSourceAsMap();
                JSONObject json = new JSONObject(sourceAsMap);
                CreditorsrightsVO vo = JSONObject.toJavaObject(json, CreditorsrightsVO.class);
                if(vo.getSnapShotTime().equals(monthQuery)){
                    set.add(vo.getSnapShotVersion());
                }
            }
            list.addAll(set);
        } catch (IOException e) {
            throw new RuntimeException("ES查询失败" + e);
        }
        // 搜索结果
        return list;
    }

    //获取上一个月字符串
    public String getLastMonth() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date); // 设置为当前时间
        calendar.set(Calendar.MONTH, calendar.get(Calendar.MONTH) - 1); // 设置为上一个月
        date = calendar.getTime();
        String accDate = format.format(date);
        return accDate;
    }


}
