package com.ejianc.business.middlemeasurement.service.impl;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.SubcontractaccountEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractaccountdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumedetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumemdetailEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractingvolumeodetailEntity;
import com.ejianc.business.middlemeasurement.mapper.SubcontractaccountMapper;
import com.ejianc.business.middlemeasurement.service.ISubcontractaccountService;
import com.ejianc.business.middlemeasurement.service.ISubcontractaccountdetailService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.outcontract.api.IOutcontractApi;
import com.ejianc.foundation.outcontract.vo.OutcontractSubcontractUnitPriceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import cn.hutool.core.collection.CollectionUtil;

/**
 * 分包月度报量台账
 * 
 * @author generator
 * 
 */
@Service("subcontractaccountService")
public class SubcontractaccountServiceImpl extends BaseServiceImpl<SubcontractaccountMapper, SubcontractaccountEntity>
		implements ISubcontractaccountService {
	/**
	 * 新增和更新数据校验
	 */
	private void verificate(SubcontractaccountEntity entity) {
		// 1.校验（同一合同，如有未审批通过的单据，不允许新增）
		if (entity.getId() == null || entity.getId() == 0) {// 新增校验
			QueryWrapper<SubcontractaccountEntity> queryWrapper = new QueryWrapper<>();
			queryWrapper.eq("project_id", entity.getProjectId());
			queryWrapper.notIn("bill_state", 1, 3);// 1直审的已提交 3审批通过 ne（不等于） notIn
			List<SubcontractaccountEntity> pro = this.list(queryWrapper);
			if (pro != null && pro.size() > 0) {
				throw new BusinessException("同一项目只能存在一份自由态、审批中、审批驳回的\"分包月度报量台账\"!");
			}
		}

	}

	@Autowired
	private IOrgApi iOrgApi;
	@Autowired
	private ISubcontractaccountdetailService subcontractaccountdetailService;
	@Autowired
	private IOutcontractApi outcontractApi;

	private void setDefaultValue(SubcontractaccountdetailEntity entity) {
		QueryWrapper<SubcontractaccountdetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("application_no", entity.getApplicationNo());
		queryWrapper.eq("dr", 0);
		if (entity.getId() != null) {
			queryWrapper.notIn("id", entity.getId());

		}
		List<SubcontractaccountdetailEntity> list = subcontractaccountdetailService.list(queryWrapper);
		BigDecimal cumulativePayment = entity.getActualPayment();
		if (!CollectionUtil.isEmpty(list)) {
			for (SubcontractaccountdetailEntity line : list) {
				cumulativePayment.add(line.getActualPayment());
			}
		}
		entity.setCumulativePayment(cumulativePayment);
	}

	/**
	 * 新增赋默认值
	 * 
	 * @param entity
	 */
	private void setDefaultValue(SubcontractaccountEntity entity) {
		if (entity.getId() != null && entity.getId() > 0) {// 更新

		} else {
			entity.setOrgId(InvocationInfoProxy.getOrgId());
			entity.setOrgName(iOrgApi.getOneById(InvocationInfoProxy.getOrgId()).getData().getName());
		}
		for (SubcontractaccountdetailEntity line : entity.getSubcontractaccountdetailEntities()) {

			setDefaultValue(line);
		}

	}

	@Transactional
	@Override
	public boolean saveOrUpdate(SubcontractaccountEntity entity, boolean syncEs) {
		setDefaultValue(entity);
		verificate(entity);
		return super.saveOrUpdate(entity, syncEs);

	}
}
