package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.ISubcontractvisadetailService;
import com.ejianc.business.middlemeasurement.vo.RevolvingleaseVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasedetailVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractvisadetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.service.ISubcontractvisaService;
import com.ejianc.business.middlemeasurement.vo.SubcontractvisaVO;

/**
 * 分包经济签证月清确认单
 *
 * @author generator
 */
@Controller
@RequestMapping("subcontractvisa")
public class SubcontractvisaController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "middlemeasurement-subcontractvisa";//此处需要根据实际修改

    @Autowired
    private ISubcontractvisaService service;

    @Autowired
    private ISubcontractvisadetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> saveOrUpdate(@RequestBody SubcontractvisaVO saveorUpdateVO) {
        SubcontractvisaEntity entity = BeanMapper.map(saveorUpdateVO, SubcontractvisaEntity.class);


        //创建条件构造器
        QueryWrapper<SubcontractvisaEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", entity.getContractId());
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("bill_state",  0);//3审批不通过
        if(entity.getId()!=null && entity.getId()!=0){
            queryWrapper.ne("id",  entity.getId());//3审批不通过
        }
        List<SubcontractvisaEntity> pro = service.list(queryWrapper);
        if (pro != null && pro.size() > 0) {
            throw new BusinessException("同一合同只能存在一份自由态、审批中、审批驳回的\"签证索赔台账\"!");
        }

        //计算累计金额
        QueryWrapper<SubcontractvisaEntity> wrapper = new QueryWrapper<>();
        //本次签证金额含税
        BigDecimal inCurrentAmount1 = entity.getInCurrentAmount();
        //本次签证金额除税
        BigDecimal exCurrentAmount1 = entity.getExCurrentAmount();
        //本期签证零工含税
        BigDecimal inCurrentOddjob1 = entity.getInCurrentOddjob();
        //本期签证零工除税
        BigDecimal exCurrentOddjob1 = entity.getExCurrentOddjob();

        //累计含税
        BigDecimal amount = BigDecimal.valueOf(0);
        BigDecimal oddjob = BigDecimal.valueOf(0);
        //累计除税
        BigDecimal exAmount = BigDecimal.valueOf(0);
        BigDecimal exOddjob = BigDecimal.valueOf(0);
        Date currentDate = new Date(System.currentTimeMillis());
        SubcontractvisaVO pastTotalData = getPastTotalData(entity.getContractId(), currentDate, true);

        //含税
        BigDecimal inCumulativeAmount = pastTotalData.getInCumulativeAmount();
        if(inCumulativeAmount != null){
            amount = amount.add(inCumulativeAmount);
        }
        BigDecimal inCumulativeOddjob = pastTotalData.getInCumulativeOddjob();
        if(inCumulativeOddjob!=null){
            oddjob = oddjob.add(inCumulativeOddjob);
        }

        //除税

        BigDecimal exCumulativeAmount = pastTotalData.getExCumulativeAmount();
        if(exCumulativeAmount != null){
            exAmount = exAmount.add(exCumulativeAmount);
        }
        BigDecimal exCumulativeOddjob = pastTotalData.getExCumulativeOddjob();
        if(exCumulativeOddjob != null){
            exOddjob = exOddjob.add(exCumulativeOddjob);
        }

        if (inCurrentAmount1 != null) {
            amount = amount.add(inCurrentAmount1);
            entity.setInCumulativeAmount(amount);
        }
        if (inCurrentOddjob1 != null) {
            oddjob = oddjob.add(inCurrentOddjob1);
            entity.setInCumulativeOddjob(oddjob);
        }
        if (exCurrentAmount1 != null) {
            exAmount = exAmount.add(exCurrentAmount1);
            entity.setExCumulativeAmount(exAmount);
        }
        if (exCurrentOddjob1 != null) {
            exOddjob = exOddjob.add(exCurrentOddjob1);
            entity.setExCumulativeOddjob(exOddjob);
        }
        //计算合计
        BigDecimal total = new BigDecimal(0);

        List<SubcontractvisadetailVO> subcontractvisadetailEntities = saveorUpdateVO.getSubcontractvisadetailEntities();
        for(int i=0;i<subcontractvisadetailEntities.size();i++) {
            SubcontractvisadetailVO subcontractvisadetailVO = subcontractvisadetailEntities.get(i);
            if ("del".equals(subcontractvisadetailVO.getRowState())) {
                continue;
            }
            BigDecimal totalDetail = new BigDecimal(0);
            totalDetail = totalDetail.add(subcontractvisadetailVO.getTotalDetail());
            total = totalDetail.add(total);
        }
//        if (saveorUpdateVO.getInCurrentAmount() != null) {
//            total = saveorUpdateVO.getInCurrentAmount().add(saveorUpdateVO.getInCurrentOddjob());
//        }

        entity.setTotal(total);
        entity = checkBillCodeUniq(entity);
        service.saveOrUpdate(entity, false);
        SubcontractvisaVO vo = BeanMapper.map(entity, SubcontractvisaVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * 单据编码唯一性校验
     *
     * @param entity
     */
    private SubcontractvisaEntity checkBillCodeUniq(SubcontractvisaEntity entity) {
        if (entity.getCode() == null || StringUtils.isEmpty(entity.getCode())) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        } else {
            //单据编码唯一性
            QueryWrapper<SubcontractvisaEntity> queryWrapperBillCode = new QueryWrapper<>();
            queryWrapperBillCode.eq("code", entity.getCode());
            queryWrapperBillCode.eq("dr", "0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne("id", id);
            }
            List<SubcontractvisaEntity> proBillCode = service.list(queryWrapperBillCode);
            if (proBillCode != null && proBillCode.size() > 0) {
                throw new BusinessException("单据编码已存在，请重新录入!");
            }
        }

        return entity;
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> queryDetail(Long id) {
        SubcontractvisaEntity entity = service.selectById(id);
        SubcontractvisaVO vo = BeanMapper.map(entity, SubcontractvisaVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractvisaVO> vos) {
        service.removeByIds(vos.stream().map(SubcontractvisaVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubcontractvisaVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");

        /** 租户隔离 */
         param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        // param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<SubcontractvisaEntity> page = service.queryPage(param, false);
        IPage<SubcontractvisaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubcontractvisaVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<SubcontractvisaEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SubcontractvisaVO> subcontractvisaVOList = BeanMapper.mapList(list, SubcontractvisaVO.class);
        for (int i = 0; i < subcontractvisaVOList.size(); i++) {
            SubcontractvisaVO vo = subcontractvisaVOList.get(i);
            vo.setSort(String.valueOf(i + 1));
            if (vo.getHappenTime() != null) {
                vo.setHappenTime(DateUtil.date(vo.getHappenTime()));
            }
            if (vo.getStartTime() != null) {
                vo.setStartTime(DateUtil.date(vo.getStartTime()));
            }
            if (vo.getEndTime() != null) {
                vo.setEndTime(DateUtil.date(vo.getEndTime()));
            }

            String billStateStr = vo.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                vo.setBillStateStr(billStateStr);
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", subcontractvisaVOList);
        ExcelExport.getInstance().export("subcontractvisa-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSubcontractvisaData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubcontractvisaVO>> refSubcontractvisaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("contractId")!=null){
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
        }
        //审批通过
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, 0));

        IPage<SubcontractvisaEntity> page = service.queryPage(param, false);
        IPage<SubcontractvisaVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<SubcontractvisaEntity> records = page.getRecords();
        if (records != null && records.size() > 0){
            for (int i = 0; i < records.size(); i++) {
                SubcontractvisaEntity entity = records.get(i);
                QueryWrapper<SubcontractvisadetailEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("dr", 0);
                queryWrapper.eq("mid", entity.getId());

                //子表
                List<SubcontractvisadetailEntity> detailEntityList = detailService.list(queryWrapper);
                entity.setSubcontractvisadetailEntities(detailEntityList);
            }
        }
        pageData.setRecords(BeanMapper.mapList(records, SubcontractvisaVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * @param contractId
     * @Description 合同唯一性
     */
    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractvisaEntity> queryProject(Long id, Long contractId) {
        //判断该合同是否存在单据
        QueryWrapper<SubcontractvisaEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.notIn("bill_state", 1, 3);
        if (id != null && id != 0) {
            queryWrapper.ne("id", id);
        }
        List<SubcontractvisaEntity> entityList = service.list(queryWrapper);

        if (entityList != null && entityList.size() > 0) {
            throw new BusinessException("同一合同只能存在一份自由态或审批中的签证索赔台账");
        }

        return CommonResponse.success("查询成功");
    }

    /**
     * @param contractId
     * @Description 查询往期
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            SubcontractvisaEntity entity = service.selectById(id);
            currentDate = entity.getCreateTime();
        }

        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate, false));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId  合同id
     * @param currentDate 本期日期
     * @param isSave      true保存 false查询
     * @return
     */
    private SubcontractvisaVO getPastTotalData(Long contractId, Date currentDate, boolean isSave) {
        //创建条件构造器
        QueryWrapper<SubcontractvisaEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.eq("dr", 0);
        queryWrapperTotal.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）


        List<SubcontractvisaEntity> proTotal = service.list(queryWrapperTotal);
        List<SubcontractvisadetailEntity> subcontractvisadetailEntities = new ArrayList<>();

        //累计签证金额
        BigDecimal inCumulativeAmount = new BigDecimal(0);
        BigDecimal exCumulativeAmount = new BigDecimal(0);

        //累计签证零工
        BigDecimal inCumulativeOddjob = new BigDecimal(0);
        BigDecimal exCumulativeOddjob = new BigDecimal(0);

        if(proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); i++) {
                SubcontractvisaEntity subcontractvisaEntity = proTotal.get(i);

                BigDecimal InCumulativeOddjob =subcontractvisaEntity.getInCumulativeOddjob();
                BigDecimal ExCumulativeOddjob =subcontractvisaEntity.getExCumulativeOddjob();
                BigDecimal InCumulativeAmount =subcontractvisaEntity.getInCumulativeAmount();
                BigDecimal ExCumulativeAmount =subcontractvisaEntity.getExCumulativeAmount();
                if(i+1 == proTotal.size()){
                    inCumulativeOddjob=InCumulativeOddjob;
                    exCumulativeOddjob=ExCumulativeOddjob;
                    inCumulativeAmount=InCumulativeAmount;
                    exCumulativeAmount=ExCumulativeAmount;
                    break;
                }
                if(inCumulativeOddjob != null && InCumulativeOddjob != null)
                { inCumulativeOddjob = inCumulativeOddjob.add(subcontractvisaEntity.getInCumulativeOddjob());}
                if(exCumulativeOddjob != null && ExCumulativeOddjob != null)
                { exCumulativeOddjob = exCumulativeOddjob.add(subcontractvisaEntity.getExCumulativeOddjob());}
                if(inCumulativeAmount != null && InCumulativeAmount != null)
                {inCumulativeAmount = inCumulativeAmount.add(subcontractvisaEntity.getInCumulativeAmount());}
                if(exCumulativeAmount != null && ExCumulativeAmount != null)
                {exCumulativeAmount = exCumulativeAmount.add(subcontractvisaEntity.getExCumulativeAmount());}

                    if (isSave) {
                        QueryWrapper<SubcontractvisadetailEntity> detailWrapper = new QueryWrapper<>();
                        detailWrapper.eq("mid", subcontractvisaEntity.getId());
                        List<SubcontractvisadetailEntity> detailList = detailService.list(detailWrapper);
                        subcontractvisadetailEntities.addAll(detailList);
                    }

            }
        }


            SubcontractvisaVO vo = new SubcontractvisaVO();
            vo.setExCumulativeAmount(exCumulativeAmount);
            vo.setInCumulativeAmount(inCumulativeAmount);
            vo.setExCumulativeOddjob(exCumulativeOddjob);
            vo.setInCumulativeOddjob(inCumulativeOddjob);
            vo.setContractId(contractId);
            //往期所有子表 entity和vo转换
            vo.setSubcontractvisadetailEntities(BeanMapper.mapList(subcontractvisadetailEntities, SubcontractvisadetailVO.class));

            return vo;


    }

    /**
     * @param contractId
     * @Description 查询详情
     */
    @RequestMapping(value = "/queryAmount", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> queryAmount( Long contractId , Long projectId) {
        //本期
        BigDecimal exVisaOddJob = new BigDecimal(0);
        BigDecimal inVisaOddJob = new BigDecimal(0);
        BigDecimal exVisaAmount = new BigDecimal(0);
        BigDecimal inVisaAmount = new BigDecimal(0);
        //累计
        BigDecimal exVisaOddCount = new BigDecimal(0);
        BigDecimal inVisaOddCount = new BigDecimal(0);
        BigDecimal exVisaCount = new BigDecimal(0);
        BigDecimal inVisaCount = new BigDecimal(0);
        //主表查询
        QueryWrapper<SubcontractvisaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("project_id", projectId);
        wrapper.eq("contract_id", contractId);
        wrapper.eq("dr", 0);
        wrapper.in("bill_state", 1, 3);
        List<SubcontractvisaEntity> entityList = service.list(wrapper);
        for (SubcontractvisaEntity subcontractvisa : entityList) {

            inVisaCount = subcontractvisa.getInCumulativeAmount();
            exVisaCount = subcontractvisa.getExCumulativeAmount();
            inVisaOddCount = subcontractvisa.getInCumulativeOddjob();
            exVisaOddCount = subcontractvisa.getExCumulativeOddjob();
//
//            if (subcontractvisa.getInCumulativeAmount() != null) {
//                inVisaCount = inVisaCount.add(subcontractvisa.getInCumulativeAmount());
//            }
//            if (subcontractvisa.getExCumulativeAmount() != null) {
//                exVisaCount = exVisaCount.add(subcontractvisa.getExCumulativeAmount());
//            }
//            if (subcontractvisa.getInCumulativeOddjob() != null) {
//                inVisaOddCount = inVisaOddCount.add(subcontractvisa.getInCumulativeOddjob());
//            }
//            if (subcontractvisa.getExCumulativeOddjob() != null) {
//                exVisaOddCount = exVisaOddCount.add(subcontractvisa.getExCumulativeOddjob());
//            }

        }
            //子表属性合计
    /*        QueryWrapper<SubcontractvisadetailEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("mid",subcontractvisa.getId());
            queryWrapper.eq("dr",0);*/
       /*     List<SubcontractvisadetailEntity> subcontractvisadetailEntityList = detailService.list(queryWrapper);
            for (SubcontractvisadetailEntity subcontractvisadetail : subcontractvisadetailEntityList) {
                if(subcontractvisadetail.getExVisaAmount()!=null){
                    exVisaAmount = exVisaAmount.add(subcontractvisadetail.getExVisaAmount());
                }
                if(subcontractvisadetail.getInVisaAmount()!=null){
                    inVisaAmount = inVisaAmount.add(subcontractvisadetail.getInVisaAmount());
                }
                if(subcontractvisadetail.getExVisaOddjob()!=null){
                    exVisaOddJob = exVisaOddJob.add(subcontractvisadetail.getExVisaOddjob());
                }
                if(subcontractvisadetail.getInVisaOddjob()!=null){
                    inVisaOddJob = inVisaOddJob.add(subcontractvisadetail.getInVisaOddjob());
                }
            }
        }*/
            SubcontractvisaVO vo = new SubcontractvisaVO();
            vo.setInCumulativeOddjob(inVisaOddCount);
            vo.setExCumulativeOddjob(exVisaOddCount);
            vo.setInCumulativeAmount(inVisaCount);
            vo.setExCumulativeAmount(exVisaCount);
            return CommonResponse.success("查询往期审批通过的累计数据成功！", vo);
        }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


}
