package com.ejianc.business.middlemeasurement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementEntity;
import com.ejianc.business.middlemeasurement.bean.InterimsettlementdetailEntity;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementService;
import com.ejianc.business.middlemeasurement.service.IInterimsettlementdetailService;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementVO;
import com.ejianc.business.middlemeasurement.vo.InterimsettlementdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 项目期中结算台账Api
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/interimsettlement")
public class InterimsettlementApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IInterimsettlementService service;

    @Autowired
    private IInterimsettlementdetailService detailService;

    /**
     * @Description 根据合同id查询详情
     * @param
     * @Return void
     */
    @RequestMapping(value = "/queryDetailBycontractId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<InterimsettlementVO> queryDetailBycontractId(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<InterimsettlementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.in("bill_state", 1, 3);
        queryWrapper.eq("dr", 0);
        queryWrapper.orderByDesc("create_time");
        queryWrapper.last("limit 1");
        List<InterimsettlementEntity> list = service.list(queryWrapper);
        InterimsettlementVO result = new InterimsettlementVO();
        if(list!=null&&list.size()>0){
            result = BeanMapper.map(list.get(0), InterimsettlementVO.class);
            //查询单据子表
            QueryWrapper<InterimsettlementdetailEntity> queryWrapperDetailList = new QueryWrapper<>();
            queryWrapperDetailList.eq("mid", result.getId());
            queryWrapperDetailList.eq("dr", "0");
            queryWrapperDetailList.orderByAsc("sort");
            List<InterimsettlementdetailEntity> detailList = detailService.list(queryWrapperDetailList);

            List<InterimsettlementdetailVO> resDetailList = BeanMapper.mapList(detailList, InterimsettlementdetailVO.class);
            result.setInterimsettlementdetailEntities(resDetailList);
        }
        return CommonResponse.success("查询数据成功！",result);
    }
}
