package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.MechanicalleasedetotaldetailEntity;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetotaldetailService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedetotaldetailVO;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasesummarydetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 月度机械设备租赁结算汇总导入导出
 */
@Controller
@RequestMapping("mechanicalleasedetotalExport")
public class ExcelmechanicalleasedetotalController {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IMechanicalleasedetotaldetailService mechanicalleasedetotaldetailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadMechanicalleasedetotaldetail", method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "mechanicalleasedetotal-import.xlsx", "月度机械设备租赁结算汇总模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelMechanicalleasedetotal", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInterimsettlement(HttpServletRequest request, HttpServletResponse response, String mechanicalleaseDatotal) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<MechanicalleasedetotaldetailVO> successList = new ArrayList<>();
        List<MechanicalleasedetotaldetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            /*BigDecimal newApproval = new BigDecimal(0.0);
            BigDecimal newRetention =  new BigDecimal(0.0);
            BigDecimal newActual =  new BigDecimal(0.0);
            BigDecimal newUncollected =  new BigDecimal(0.0);
            BigDecimal newReceivable =  new BigDecimal(0.0);


            QueryWrapper<MechanicalleasedetotaldetailEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_state",3);
            List<MechanicalleasedetotaldetailEntity> list = mechanicalleasedetotaldetailService.list(wrapper);
            if(CollectionUtil.isEmpty(list)){
                throw new RuntimeException("暂无审批通过的数据");
            }*/

            HashMap<String, String> frontMap = new HashMap<>();

            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    MechanicalleasedetotaldetailVO mechanicalleasedetotaldetailVO = new MechanicalleasedetotaldetailVO();
                    List<MechanicalleasedetotaldetailVO> mechanicalleasedetotaldetailVOList = JSON.parseArray(mechanicalleaseDatotal, MechanicalleasedetotaldetailVO.class);

                    List<String> datas = result.get(i);

                    for (MechanicalleasedetotaldetailVO vo : mechanicalleasedetotaldetailVOList) {
                        StringBuffer materBuffer = new StringBuffer();
                        if (vo.getContractName() != null && StringUtils.isNotBlank(vo.getContractName())) {
                            materBuffer.append(vo.getContractName());
                        }
                        if (vo.getClassifyCode() != null && StringUtils.isNotBlank(vo.getClassifyCode())) {
                            materBuffer.append(vo.getClassifyCode());
                        }
                        if (vo.getClassifyName() != null && StringUtils.isNotBlank(vo.getClassifyName())) {
                            materBuffer.append(vo.getClassifyName());
                        }
                        if (vo.getSupplierName() != null && StringUtils.isNotBlank(vo.getSupplierName())) {
                            materBuffer.append(vo.getSupplierName());
                        }
//                        if (vo.getContractPaidRatio() != null) {
//                            materBuffer.append(vo.getContractPaidRatio());
//                        }
                        frontMap.put(materBuffer.toString(), materBuffer.toString());
                    }

                    mechanicalleasedetotaldetailVO.setId(IdWorker.getId());//id

                    mechanicalleasedetotaldetailVO.setContractName(StringUtils.isNotBlank(datas.get(0)) ? String.valueOf(datas.get(0)) : null); // 合同名称
                    mechanicalleasedetotaldetailVO.setClassifyCode(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 设备分类编码
                    mechanicalleasedetotaldetailVO.setClassifyName(StringUtils.isNotBlank(datas.get(2)) ? String.valueOf(datas.get(2)) : null); //设备分类名称
                    mechanicalleasedetotaldetailVO.setSupplierName(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 租赁商名称
                    mechanicalleasedetotaldetailVO.setContractPaidRatio(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null);// 合同付款比例

//                    String keyValue = frontMap.get(datas.get(0) + datas.get(1) + datas.get(2) + datas.get(3) + datas.get(8));
                    String keyValue = frontMap.get(datas.get(0) + datas.get(1) + datas.get(2) + datas.get(3));

                    if (keyValue != null && StringUtils.isNotBlank(keyValue)) {

                    } else {
                        mechanicalleasedetotaldetailVO.setErrorMsg("'合同名称,设备分类编码,设备分类名称,租赁商名称,合同付款比例'与参照内容不符,请检查!");
                        errorList.add(mechanicalleasedetotaldetailVO);
                    }

                    for (MechanicalleasedetotaldetailVO vos : mechanicalleasedetotaldetailVOList) {
                        if(vos.getContractPaidRatio()==null){
                            if(vos.getContractName().equals(datas.get(0)) && vos.getClassifyCode().equals(datas.get(1)) && vos.getClassifyName().equals(datas.get(2)) &&
                                    vos.getSupplierName().equals(datas.get(3))){
                                mechanicalleasedetotaldetailVO.setExTaxMonthSettlement(vos.getExTaxMonthSettlement()); //  本月结算金额(除税)
                                mechanicalleasedetotaldetailVO.setInTaxMonthSettlement(vos.getInTaxMonthSettlement()); // 本月结算金额(含税)
                                mechanicalleasedetotaldetailVO.setExTaxCumulativeSettlement(vos.getExTaxCumulativeSettlement()); //累计结算(除税)
                                mechanicalleasedetotaldetailVO.setInTaxCumulativeSettlement(vos.getInTaxCumulativeSettlement());//  累计结算(含税)
                            }
                        }else{
                            if((vos.getContractName()==null?"":vos.getContractName()).equals(datas.get(0)) && (vos.getClassifyCode()==null?"":vos.getClassifyCode()).equals(datas.get(1)) && (vos.getClassifyName()==null?"":vos.getClassifyName()).equals(datas.get(2)) &&
                                    vos.getSupplierName().equals(datas.get(3)) && vos.getContractPaidRatio().equals(datas.get(8))){
                                mechanicalleasedetotaldetailVO.setExTaxMonthSettlement(vos.getExTaxMonthSettlement()); //  本月结算金额(除税)
                                mechanicalleasedetotaldetailVO.setInTaxMonthSettlement(vos.getInTaxMonthSettlement()); // 本月结算金额(含税)
                                mechanicalleasedetotaldetailVO.setExTaxCumulativeSettlement(vos.getExTaxCumulativeSettlement()); //累计结算(除税)
                                mechanicalleasedetotaldetailVO.setInTaxCumulativeSettlement(vos.getInTaxCumulativeSettlement());//  累计结算(含税)
                            }
                        }
                    }

                    if (StringUtils.isBlank(datas.get(9)) || datas.get(9) == null) {
                        mechanicalleasedetotaldetailVO.setErrorMsg("'至本月累计应付款金额'不能为空");
                        errorList.add(mechanicalleasedetotaldetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(9))) {
                            mechanicalleasedetotaldetailVO.setErrorMsg("'至本月累计应付款金额'格式错误");
                            errorList.add(mechanicalleasedetotaldetailVO);
                        } else {
                            mechanicalleasedetotaldetailVO.setExTaxCumulativeDue(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : new BigDecimal(0)); //  至本月累计应付款金额
                        }
                    }

                    if (StringUtils.isBlank(datas.get(10)) || datas.get(10) == null) {
                        mechanicalleasedetotaldetailVO.setErrorMsg("'至本月累计付款金额'不能为空");
                        errorList.add(mechanicalleasedetotaldetailVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(10))) {
                            mechanicalleasedetotaldetailVO.setErrorMsg("'至本月累计付款金额'格式错误");
                            errorList.add(mechanicalleasedetotaldetailVO);
                        } else {
                            mechanicalleasedetotaldetailVO.setInTaxCumulativePaid(StringUtils.isNotBlank(datas.get(10)) ? new BigDecimal(datas.get(10)) : new BigDecimal(0)); // 至本月累计付款金额
                        }
                    }

                    if (StringUtils.isBlank(datas.get(11)) || datas.get(11) == null) {
                        mechanicalleasedetotaldetailVO.setErrorMsg("'联系人'不能为空");
                        errorList.add(mechanicalleasedetotaldetailVO);
                    } else {
                        mechanicalleasedetotaldetailVO.setLinker(StringUtils.isNotBlank(datas.get(11)) ? datas.get(11) : null); // 联系人
                    }

                    if (StringUtils.isBlank(datas.get(12)) || datas.get(12) == null) {
                        mechanicalleasedetotaldetailVO.setErrorMsg("'联系人电话'不能为空");
                        errorList.add(mechanicalleasedetotaldetailVO);
                    } else {
                        mechanicalleasedetotaldetailVO.setLinkerPhone(StringUtils.isNotBlank(datas.get(12)) ? datas.get(12) : null); // 联系人电话
                    }

                    mechanicalleasedetotaldetailVO.setRemarks(StringUtils.isNotBlank(datas.get(13)) ? datas.get(13) : null); // 备注

                    if (errorList.size() == 0) {
                        successList.add(mechanicalleasedetotaldetailVO);
                    }
                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMechanicalleasedetotalFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMechanicalleasedetotalFromDatabase(@RequestBody MechanicalleasedetotaldetailVO detailVo, HttpServletResponse response) {
        QueryWrapper<MechanicalleasedetotaldetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<MechanicalleasedetotaldetailEntity> list = mechanicalleasedetotaldetailService.list(queryWrapper);
        List<MechanicalleasedetotaldetailVO> mechanicalleasedetotaldetailVOS = BeanMapper.mapList(list, MechanicalleasedetotaldetailVO.class);
        if (mechanicalleasedetotaldetailVOS != null && mechanicalleasedetotaldetailVOS.size() > 0) {
            for (int i = 0; i < mechanicalleasedetotaldetailVOS.size(); i++) {
                MechanicalleasedetotaldetailVO mechanicalleasedetotaldetailVO = mechanicalleasedetotaldetailVOS.get(i);
                mechanicalleasedetotaldetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetotaldetailVO.getCreateTime() != null) {
                    mechanicalleasedetotaldetailVO.setCreateTime(DateUtil.date(mechanicalleasedetotaldetailVO.getCreateTime()));
                }
                if (mechanicalleasedetotaldetailVO.getUpdateTime() != null) {
                    mechanicalleasedetotaldetailVO.setUpdateTime(DateUtil.date(mechanicalleasedetotaldetailVO.getUpdateTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", mechanicalleasedetotaldetailVOS);
        ExcelExport.getInstance().export("mechanicalleasedetotal-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportMechanicalleasedetotaldetailFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportMechanicalleasedetotaldetailFromPage(@RequestBody List<MechanicalleasedetotaldetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                MechanicalleasedetotaldetailVO mechanicalleasedetotaldetailVO = list.get(i);
                mechanicalleasedetotaldetailVO.setSort(String.valueOf(i + 1));
                if (mechanicalleasedetotaldetailVO.getCreateTime() != null) {
                    mechanicalleasedetotaldetailVO.setCreateTime(DateUtil.date(mechanicalleasedetotaldetailVO.getCreateTime()));
                }
                if (mechanicalleasedetotaldetailVO.getUpdateTime() != null) {
                    mechanicalleasedetotaldetailVO.setUpdateTime(DateUtil.date(mechanicalleasedetotaldetailVO.getUpdateTime()));
                }
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("mechanicalleasedetotal-export.xlsx", beans, response);
    }

}
