package com.ejianc.business.middlemeasurement.bean;

import java.math.BigDecimal;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.middlemeasurement.bean.PurchasesummarydetatilEntity;
/**
 * 月度物资采购结算汇总
 * 
 * @author generator
 * 
 */
 @TableName("ejc_middlemeasurement_purchasesummary")
public class PurchasesummaryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目id
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="project_code")
    private java.lang.String projectCode; // 项目编号
    @TableField(value="org_id")
    private java.lang.Long orgId; // 所属组织id
    @TableField(value="org_name")
    private java.lang.String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private java.lang.Long projectDepartmentId; // 项目部id
    @TableField(value="statistical_time")
    private java.util.Date statisticalTime; // 统计时间
    @TableField(value="code")
    private java.lang.String code; // 编号
    @TableField(value="settlement_amount")
    private java.math.BigDecimal settlementAmount; // 本月结算金额(除税)
    @TableField(value="tax_settlement_amount")
    private java.math.BigDecimal taxSettlementAmount; // 本月结算金额(含税)
    @TableField(value="settlement_total")
    private java.math.BigDecimal settlementTotal; // 累计结算金额汇总(除税)
    @TableField(value="tax_settlement_total")
    private java.math.BigDecimal taxSettlementTotal; // 累计结算金额汇总(含税)
    @TableField(value="cumulative_payable")
    private java.math.BigDecimal cumulativePayable; // 本月累计应付款金额
    @TableField(value="cumulative_payment")
    private java.math.BigDecimal cumulativePayment; // 本月累计付款金额
    @TableField(value="remarks")
    private java.lang.String remarks; // 备注
    @TableField(value = "settlement_type")
    private java.lang.String settlementType; //结算类型
    @TableField(value = "payment_proportion_count")
    private java.math.BigDecimal paymentProportionCount; //累计合同付款比例
    
    @TableField(exist=false)
    @SubEntity(serviceName="purchasesummarydetatilService",pidName = "mid")
    private List<PurchasesummarydetatilEntity> purchasesummarydetatilEntities = new ArrayList<>(); // 月度物资采购结算汇总子表

    public BigDecimal getPaymentProportionCount() {
        return paymentProportionCount;
    }

    public void setPaymentProportionCount(BigDecimal paymentProportionCount) {
        this.paymentProportionCount = paymentProportionCount;
    }

    public String getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(String settlementType) {
        this.settlementType = settlementType;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 项目id
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编号
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编号
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 统计时间
     */
    public java.util.Date getStatisticalTime() {
        return statisticalTime;
    }

    /**
     * 统计时间
     */
    public void setStatisticalTime(java.util.Date statisticalTime) {
        this.statisticalTime = statisticalTime;
    }
    /**
     * 编号
     */
    public java.lang.String getCode() {
        return code;
    }

    /**
     * 编号
     */
    public void setCode(java.lang.String code) {
        this.code = code;
    }
    /**
     * 本月结算金额(除税)
     */
    public java.math.BigDecimal getSettlementAmount() {
        return settlementAmount;
    }

    /**
     * 本月结算金额(除税)
     */
    public void setSettlementAmount(java.math.BigDecimal settlementAmount) {
        this.settlementAmount = settlementAmount;
    }
    /**
     * 本月结算金额(含税)
     */
    public java.math.BigDecimal getTaxSettlementAmount() {
        return taxSettlementAmount;
    }

    /**
     * 本月结算金额(含税)
     */
    public void setTaxSettlementAmount(java.math.BigDecimal taxSettlementAmount) {
        this.taxSettlementAmount = taxSettlementAmount;
    }
    /**
     * 累计结算金额汇总(除税)
     */
    public java.math.BigDecimal getSettlementTotal() {
        return settlementTotal;
    }

    /**
     * 累计结算金额汇总(除税)
     */
    public void setSettlementTotal(java.math.BigDecimal settlementTotal) {
        this.settlementTotal = settlementTotal;
    }
    /**
     * 累计结算金额汇总(含税)
     */
    public java.math.BigDecimal getTaxSettlementTotal() {
        return taxSettlementTotal;
    }

    /**
     * 累计结算金额汇总(含税)
     */
    public void setTaxSettlementTotal(java.math.BigDecimal taxSettlementTotal) {
        this.taxSettlementTotal = taxSettlementTotal;
    }
    /**
     * 本月累计应付款金额
     */
    public java.math.BigDecimal getCumulativePayable() {
        return cumulativePayable;
    }

    /**
     * 本月累计应付款金额
     */
    public void setCumulativePayable(java.math.BigDecimal cumulativePayable) {
        this.cumulativePayable = cumulativePayable;
    }
    /**
     * 本月累计付款金额
     */
    public java.math.BigDecimal getCumulativePayment() {
        return cumulativePayment;
    }

    /**
     * 本月累计付款金额
     */
    public void setCumulativePayment(java.math.BigDecimal cumulativePayment) {
        this.cumulativePayment = cumulativePayment;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    
    /**
     * 月度物资采购结算汇总子表
     */
    public List<PurchasesummarydetatilEntity> getPurchasesummarydetatilEntities() {
        return purchasesummarydetatilEntities;
    }

    /**
     * 月度物资采购结算汇总子表
     */
    public void setPurchasesummarydetatilEntities(List<PurchasesummarydetatilEntity> purchasesummarydetatilEntities) {
        this.purchasesummarydetatilEntities = purchasesummarydetatilEntities;
    }
}
