/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.PurchasesettlementEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesummaryEntity;
import com.ejianc.business.middlemeasurement.bean.PurchasesummarydetatilEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementService;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.service.IPurchasesummaryService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesummaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"purchasesummary"})
public class PurchasesummaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "middlemeasurement-purchasesummary";
    @Autowired
    private IPurchasesummaryService service;
    @Autowired
    private IPurchasesettlementService purchasesettlementService;
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PurchasesummaryVO> saveOrUpdate(@RequestBody PurchasesummaryVO saveorUpdateVO) {
        List<String> referenceIdList;
        PurchasesummaryEntity entity = (PurchasesummaryEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), PurchasesummaryEntity.class));
        Calendar calendar = Calendar.getInstance();
        int month = calendar.getTime().getMonth() + 1;
        int year = 1900 + calendar.getTime().getYear();
        String dates = "";
        dates = month < 10 ? year + "-0" + month : year + "-" + month;
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getId() == null) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
            queryWrapper.in((Object)"bill_state", new Object[]{0, 2, 4, 5});
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("\u540c\u4e00\u9879\u76ee\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u6708\u5ea6\u91c7\u8d2d\u7ed3\u7b97\u6c47\u603b\u5355\"!");
            }
            QueryWrapper queryWrapper1 = new QueryWrapper();
            queryWrapper1.eq((Object)"project_id", (Object)entity.getProjectId());
            queryWrapper1.eq((Object)"dr", (Object)0);
            List proDate = this.service.list((Wrapper)queryWrapper1);
            if (proDate != null && proDate.size() > 0) {
                Iterator iterator = proDate.iterator();
                while (iterator.hasNext()) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
                    PurchasesummaryEntity purchasesummary = (PurchasesummaryEntity)((Object)iterator.next());
                    Date statisticalTime = purchasesummary.getStatisticalTime();
                    String format1 = format.format(statisticalTime);
                    if (!format1.equals(dates)) continue;
                    throw new BusinessException(entity.getProjectName() + "\u9879\u76ee\u8be5\u6708\u4efd\u5355\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa!");
                }
            }
        }
        if (entity.getId() != null && (referenceIdList = saveorUpdateVO.getReferenceIdList()) != null && referenceIdList.size() > 0) {
            for (int i = 0; i < referenceIdList.size(); ++i) {
                QueryWrapper referenceWrapper = new QueryWrapper();
                Object referenceEntities = (PurchasesettlementEntity)((Object)this.purchasesettlementService.selectById((Serializable)((Object)referenceIdList.get(i))));
                if (referenceEntities == null) continue;
                ((PurchasesettlementEntity)((Object)referenceEntities)).setIsReference(1);
                this.purchasesettlementService.saveOrUpdate(referenceEntities);
            }
        }
        if ((referenceIdList = saveorUpdateVO.getReferenceIdList()) != null && referenceIdList.size() > 0) {
            QueryWrapper queryWrapperByIdsNew = new QueryWrapper();
            queryWrapperByIdsNew.in((Object)"id", referenceIdList);
            queryWrapperByIdsNew.eq((Object)"dr", (Object)0);
            List newList = this.purchasesettlementService.list((Wrapper)queryWrapperByIdsNew);
            if (newList != null && newList.size() > 0) {
                for (PurchasesettlementEntity item : newList) {
                    item.setIsReference(1);
                    item.setReferenceCode(entity.getCode());
                }
                this.purchasesettlementService.saveOrUpdateBatch(newList);
            }
        }
        BigDecimal count = new BigDecimal(0);
        String type = "\u6708\u5ea6\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u5355";
        for (PurchasesummarydetatilEntity purchasesummarydetatil : entity.getPurchasesummarydetatilEntities()) {
            if (purchasesummarydetatil.getPaymentProportion() == null) continue;
            count = count.add(purchasesummarydetatil.getPaymentProportion());
        }
        entity.setPaymentProportionCount(count);
        entity.setSettlementType(type);
        this.service.saveOrUpdate((Object)entity, false);
        PurchasesummaryVO vo = (PurchasesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), PurchasesummaryVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesummaryVO> queryDetail(Long id) {
        PurchasesummaryEntity entity = (PurchasesummaryEntity)((Object)this.service.selectById(id));
        PurchasesummaryVO vo = (PurchasesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), PurchasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PurchasesummaryVO> vos) {
        List idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", idList);
        List purchasesummaryEntities = this.service.list((Wrapper)queryWrapper);
        ArrayList<String> codeList = new ArrayList<String>();
        for (PurchasesummaryEntity entity : purchasesummaryEntities) {
            codeList.add(entity.getCode());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.in((Object)"reference_code", codeList);
        List list = this.purchasesettlementService.list((Wrapper)wrapper);
        for (PurchasesettlementEntity entity : list) {
            entity.setIsReference(0);
            entity.setReferenceCode(null);
        }
        this.purchasesettlementService.saveOrUpdateBatch(list);
        this.service.removeByIds(idList, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PurchasesummaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List map = BeanMapper.mapList((Iterable)list, PurchasesummaryVO.class);
        int count = 1;
        for (PurchasesummaryVO entity : map) {
            String billStateStr;
            entity.setSort(String.valueOf(count));
            if (entity.getStatisticalTime() != null) {
                entity.setStatisticalTimeShow(DateUtils.dateSimple2(entity.getStatisticalTime()));
            }
            if ((billStateStr = entity.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            entity.setBillStateStr(billStateStr);
            ++count;
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", map);
        ExcelExport.getInstance().export("Purchasesummary-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPurchasesummaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasesummaryVO>> refPurchasesummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PurchasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refPurchasesettlementData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PurchasesettlementVO>> refPurchasesettlementData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"projectId") != null) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("isReference", new Parameter("eq", (Object)0));
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        IPage page = this.purchasesettlementService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List voList = BeanMapper.mapList((Iterable)page.getRecords(), PurchasesettlementVO.class);
        if (voList != null && voList.size() > 0) {
            for (int i = 0; i < voList.size(); ++i) {
                PurchasesettlementVO vo = (PurchasesettlementVO)((Object)voList.get(i));
                vo.setSort(String.valueOf(i + 1));
                Long id = vo.getId();
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.eq((Object)"mid", (Object)id);
                detailWrapper.eq((Object)"dr", (Object)0);
                List entityList = this.purchasesettlementdetailService.list((Wrapper)detailWrapper);
                if (entityList == null || entityList.size() <= 0) continue;
                List detailList = BeanMapper.mapList((Iterable)entityList, PurchasesettlementdetailVO.class);
                vo.setPurchasesettlementdetailEntities(detailList);
            }
        }
        pageData.setRecords(voList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PurchasesummaryVO> pastData(Long id, Long projectId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            PurchasesummaryEntity entity = (PurchasesummaryEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.lt((Object)"create_time", (Object)currentDate);
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        List list = this.service.list((Wrapper)wrapper);
        BigDecimal settlementTotal = new BigDecimal(0);
        BigDecimal taxSettlementTotal = new BigDecimal(0);
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PurchasesummaryEntity purchasesummaryEntity = (PurchasesummaryEntity)((Object)list.get(i));
                settlementTotal = settlementTotal.add(purchasesummaryEntity.getSettlementAmount());
                taxSettlementTotal = settlementTotal.add(purchasesummaryEntity.getTaxSettlementAmount());
            }
        }
        PurchasesummaryVO vo = new PurchasesummaryVO();
        vo.setSettlementTotal(settlementTotal);
        vo.setTaxSettlementTotal(taxSettlementTotal);
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/getSelectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Long>> getSelectId(Long id) {
        PurchasesummaryEntity purchasesummaryEntity = (PurchasesummaryEntity)((Object)this.service.selectById(id));
        String billCode = purchasesummaryEntity.getCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"reference_code", (Object)billCode);
        List list = this.purchasesettlementService.list((Wrapper)wrapper);
        ArrayList<Long> idList = new ArrayList<Long>();
        for (PurchasesettlementEntity entity : list) {
            idList.add(entity.getId());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", idList);
    }
}

