/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.SubcontractvisaEntity;
import com.ejianc.business.middlemeasurement.service.ISubcontractvisaService;
import com.ejianc.business.middlemeasurement.service.ISubcontractvisadetailService;
import com.ejianc.business.middlemeasurement.vo.SubcontractvisaVO;
import com.ejianc.business.middlemeasurement.vo.SubcontractvisadetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"subcontractvisa"})
public class SubcontractvisaController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "middlemeasurement-subcontractvisa";
    @Autowired
    private ISubcontractvisaService service;
    @Autowired
    private ISubcontractvisadetailService detailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> saveOrUpdate(@RequestBody SubcontractvisaVO saveorUpdateVO) {
        BigDecimal exCumulativeOddjob;
        BigDecimal exCumulativeAmount;
        BigDecimal inCumulativeOddjob;
        List pro;
        SubcontractvisaEntity entity = (SubcontractvisaEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), SubcontractvisaEntity.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"contract_id", (Object)entity.getContractId());
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"bill_state", (Object)0);
        if (entity.getId() != null && entity.getId() != 0L) {
            queryWrapper.ne((Object)"id", (Object)entity.getId());
        }
        if ((pro = this.service.list((Wrapper)queryWrapper)) != null && pro.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u7b7e\u8bc1\u7d22\u8d54\u53f0\u8d26\"!");
        }
        QueryWrapper wrapper = new QueryWrapper();
        BigDecimal inCurrentAmount1 = entity.getInCurrentAmount();
        BigDecimal exCurrentAmount1 = entity.getExCurrentAmount();
        BigDecimal inCurrentOddjob1 = entity.getInCurrentOddjob();
        BigDecimal exCurrentOddjob1 = entity.getExCurrentOddjob();
        BigDecimal amount = BigDecimal.valueOf(0L);
        BigDecimal oddjob = BigDecimal.valueOf(0L);
        BigDecimal exAmount = BigDecimal.valueOf(0L);
        BigDecimal exOddjob = BigDecimal.valueOf(0L);
        Date currentDate = new Date(System.currentTimeMillis());
        SubcontractvisaVO pastTotalData = this.getPastTotalData(entity.getContractId(), currentDate, true);
        BigDecimal inCumulativeAmount = pastTotalData.getInCumulativeAmount();
        if (inCumulativeAmount != null) {
            amount = amount.add(inCumulativeAmount);
        }
        if ((inCumulativeOddjob = pastTotalData.getInCumulativeOddjob()) != null) {
            oddjob = oddjob.add(inCumulativeOddjob);
        }
        if ((exCumulativeAmount = pastTotalData.getExCumulativeAmount()) != null) {
            exAmount = exAmount.add(exCumulativeAmount);
        }
        if ((exCumulativeOddjob = pastTotalData.getExCumulativeOddjob()) != null) {
            exOddjob = exOddjob.add(exCumulativeOddjob);
        }
        if (inCurrentAmount1 != null) {
            amount = amount.add(inCurrentAmount1);
            entity.setInCumulativeAmount(amount);
        }
        if (inCurrentOddjob1 != null) {
            oddjob = oddjob.add(inCurrentOddjob1);
            entity.setInCumulativeOddjob(oddjob);
        }
        if (exCurrentAmount1 != null) {
            exAmount = exAmount.add(exCurrentAmount1);
            entity.setExCumulativeAmount(exAmount);
        }
        if (exCurrentOddjob1 != null) {
            exOddjob = exOddjob.add(exCurrentOddjob1);
            entity.setExCumulativeOddjob(exOddjob);
        }
        BigDecimal total = new BigDecimal(0);
        List<SubcontractvisadetailVO> subcontractvisadetailEntities = saveorUpdateVO.getSubcontractvisadetailEntities();
        for (int i = 0; i < subcontractvisadetailEntities.size(); ++i) {
            SubcontractvisadetailVO subcontractvisadetailVO = subcontractvisadetailEntities.get(i);
            if ("del".equals(subcontractvisadetailVO.getRowState())) continue;
            BigDecimal totalDetail = new BigDecimal(0);
            totalDetail = totalDetail.add(subcontractvisadetailVO.getTotalDetail());
            total = totalDetail.add(total);
        }
        entity.setTotal(total);
        entity = this.checkBillCodeUniq(entity);
        this.service.saveOrUpdate((Object)entity, false);
        SubcontractvisaVO vo = (SubcontractvisaVO)((Object)BeanMapper.map((Object)((Object)entity), SubcontractvisaVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SubcontractvisaEntity checkBillCodeUniq(SubcontractvisaEntity entity) {
        if (entity.getCode() == null || StringUtils.isEmpty((CharSequence)entity.getCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"code", (Object)entity.getCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne((Object)"id", (Object)id);
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)) == null || proBillCode.size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> queryDetail(Long id) {
        SubcontractvisaEntity entity = (SubcontractvisaEntity)((Object)this.service.selectById(id));
        SubcontractvisaVO vo = (SubcontractvisaVO)((Object)BeanMapper.map((Object)((Object)entity), SubcontractvisaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubcontractvisaVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<SubcontractvisaVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), SubcontractvisaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        fuzzyFields.add("code");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("project_name");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List subcontractvisaVOList = BeanMapper.mapList((Iterable)list, SubcontractvisaVO.class);
        for (int i = 0; i < subcontractvisaVOList.size(); ++i) {
            String billStateStr;
            SubcontractvisaVO vo = (SubcontractvisaVO)((Object)subcontractvisaVOList.get(i));
            vo.setSort(String.valueOf(i + 1));
            if (vo.getHappenTime() != null) {
                vo.setHappenTime((Date)DateUtil.date((Date)vo.getHappenTime()));
            }
            if (vo.getStartTime() != null) {
                vo.setStartTime((Date)DateUtil.date((Date)vo.getStartTime()));
            }
            if (vo.getEndTime() != null) {
                vo.setEndTime((Date)DateUtil.date((Date)vo.getEndTime()));
            }
            if ((billStateStr = vo.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            vo.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", subcontractvisaVOList);
        ExcelExport.getInstance().export("subcontractvisa-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refSubcontractvisaData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<SubcontractvisaVO>> refSubcontractvisaData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition) && (_con = JSONObject.parseObject((String)condition)).get((Object)"contractId") != null) {
            param.getParams().put("contractId", new Parameter("eq", _con.get((Object)"contractId")));
        }
        param.getParams().put("billState", new Parameter("in", (Object)"1,3"));
        param.getParams().put("dr", new Parameter("eq", (Object)0));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = page.getRecords();
        if (records != null && records.size() > 0) {
            for (int i = 0; i < records.size(); ++i) {
                SubcontractvisaEntity entity = (SubcontractvisaEntity)((Object)records.get(i));
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"dr", (Object)0);
                queryWrapper.eq((Object)"mid", (Object)entity.getId());
                List detailEntityList = this.detailService.list((Wrapper)queryWrapper);
                entity.setSubcontractvisadetailEntities(detailEntityList);
            }
        }
        pageData.setRecords(BeanMapper.mapList((Iterable)records, SubcontractvisaVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractvisaEntity> queryProject(Long id, Long contractId) {
        List entityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"contract_id", (Object)contractId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        if (id != null && id != 0L) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapper)) != null && entityList.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u5408\u540c\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\u7b7e\u8bc1\u7d22\u8d54\u53f0\u8d26");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f");
    }

    @RequestMapping(value={"/pastData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> pastData(Long id, Long contractId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {
            SubcontractvisaEntity entity = (SubcontractvisaEntity)((Object)this.service.selectById(id));
            currentDate = entity.getCreateTime();
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)this.getPastTotalData(contractId, currentDate, false)));
    }

    private SubcontractvisaVO getPastTotalData(Long contractId, Date currentDate, boolean isSave) {
        QueryWrapper queryWrapperTotal = new QueryWrapper();
        queryWrapperTotal.eq((Object)"contract_id", (Object)contractId);
        queryWrapperTotal.eq((Object)"dr", (Object)0);
        queryWrapperTotal.in((Object)"bill_state", new Object[]{1, 3});
        queryWrapperTotal.lt((Object)"create_time", (Object)currentDate);
        List proTotal = this.service.list((Wrapper)queryWrapperTotal);
        ArrayList subcontractvisadetailEntities = new ArrayList();
        BigDecimal inCumulativeAmount = new BigDecimal(0);
        BigDecimal exCumulativeAmount = new BigDecimal(0);
        BigDecimal inCumulativeOddjob = new BigDecimal(0);
        BigDecimal exCumulativeOddjob = new BigDecimal(0);
        if (proTotal != null && proTotal.size() > 0) {
            for (int i = 0; i < proTotal.size(); ++i) {
                SubcontractvisaEntity subcontractvisaEntity = (SubcontractvisaEntity)((Object)proTotal.get(i));
                BigDecimal InCumulativeOddjob = subcontractvisaEntity.getInCumulativeOddjob();
                BigDecimal ExCumulativeOddjob = subcontractvisaEntity.getExCumulativeOddjob();
                BigDecimal InCumulativeAmount = subcontractvisaEntity.getInCumulativeAmount();
                BigDecimal ExCumulativeAmount = subcontractvisaEntity.getExCumulativeAmount();
                if (i + 1 == proTotal.size()) {
                    inCumulativeOddjob = InCumulativeOddjob;
                    exCumulativeOddjob = ExCumulativeOddjob;
                    inCumulativeAmount = InCumulativeAmount;
                    exCumulativeAmount = ExCumulativeAmount;
                    break;
                }
                if (inCumulativeOddjob != null && InCumulativeOddjob != null) {
                    inCumulativeOddjob = inCumulativeOddjob.add(subcontractvisaEntity.getInCumulativeOddjob());
                }
                if (exCumulativeOddjob != null && ExCumulativeOddjob != null) {
                    exCumulativeOddjob = exCumulativeOddjob.add(subcontractvisaEntity.getExCumulativeOddjob());
                }
                if (inCumulativeAmount != null && InCumulativeAmount != null) {
                    inCumulativeAmount = inCumulativeAmount.add(subcontractvisaEntity.getInCumulativeAmount());
                }
                if (exCumulativeAmount != null && ExCumulativeAmount != null) {
                    exCumulativeAmount = exCumulativeAmount.add(subcontractvisaEntity.getExCumulativeAmount());
                }
                if (!isSave) continue;
                QueryWrapper detailWrapper = new QueryWrapper();
                detailWrapper.eq((Object)"mid", (Object)subcontractvisaEntity.getId());
                List detailList = this.detailService.list((Wrapper)detailWrapper);
                subcontractvisadetailEntities.addAll(detailList);
            }
        }
        SubcontractvisaVO vo = new SubcontractvisaVO();
        vo.setExCumulativeAmount(exCumulativeAmount);
        vo.setInCumulativeAmount(inCumulativeAmount);
        vo.setExCumulativeOddjob(exCumulativeOddjob);
        vo.setInCumulativeOddjob(inCumulativeOddjob);
        vo.setContractId(contractId);
        vo.setSubcontractvisadetailEntities(BeanMapper.mapList(subcontractvisadetailEntities, SubcontractvisadetailVO.class));
        return vo;
    }

    @RequestMapping(value={"/queryAmount"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<SubcontractvisaVO> queryAmount(Long contractId, Long projectId) {
        BigDecimal exVisaOddJob = new BigDecimal(0);
        BigDecimal inVisaOddJob = new BigDecimal(0);
        BigDecimal exVisaAmount = new BigDecimal(0);
        BigDecimal inVisaAmount = new BigDecimal(0);
        BigDecimal exVisaOddCount = new BigDecimal(0);
        BigDecimal inVisaOddCount = new BigDecimal(0);
        BigDecimal exVisaCount = new BigDecimal(0);
        BigDecimal inVisaCount = new BigDecimal(0);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)projectId);
        wrapper.eq((Object)"contract_id", (Object)contractId);
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.in((Object)"bill_state", new Object[]{1, 3});
        List entityList = this.service.list((Wrapper)wrapper);
        for (SubcontractvisaEntity subcontractvisa : entityList) {
            inVisaCount = subcontractvisa.getInCumulativeAmount();
            exVisaCount = subcontractvisa.getExCumulativeAmount();
            inVisaOddCount = subcontractvisa.getInCumulativeOddjob();
            exVisaOddCount = subcontractvisa.getExCumulativeOddjob();
        }
        SubcontractvisaVO vo = new SubcontractvisaVO();
        vo.setInCumulativeOddjob(inVisaOddCount);
        vo.setExCumulativeOddjob(exVisaOddCount);
        vo.setInCumulativeAmount(inVisaCount);
        vo.setExCumulativeAmount(exVisaCount);
        return CommonResponse.success((String)"\u67e5\u8be2\u5f80\u671f\u5ba1\u6279\u901a\u8fc7\u7684\u7d2f\u8ba1\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

