package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.ConsultotherodetailEntity;
import com.ejianc.business.middlemeasurement.bean.ConsultotherdetailEntity;
import com.ejianc.business.middlemeasurement.service.IConsultotherodetailService;
import com.ejianc.business.middlemeasurement.service.IConsultotherdetailService;
import com.ejianc.business.middlemeasurement.vo.ConsultotherodetailVO;
import com.ejianc.business.middlemeasurement.vo.ConsultotherVO;
import com.ejianc.business.middlemeasurement.vo.ConsultotherdetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 咨询及其他类合同过程结算单导入导出
 */
@Controller
@RequestMapping("consultotherExport")
public class ExcelConsultotherController {

	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IConsultotherdetailService consultotherdetailService;
	@Autowired
	private IConsultotherodetailService consultotherodetailService;

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download", method = RequestMethod.POST)
	@ResponseBody
	public void download(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "consultotherdetail-import.xlsx", "咨询及其他类合同过程结算单-最终结算计价明表");
	}

	/**
	 * 导入模板下载
	 *
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/download3", method = RequestMethod.POST)
	@ResponseBody
	public void download3(HttpServletRequest request, HttpServletResponse response) {
		ImportTemplate.initialize(response);
		ImportTemplate.templetdownload(request, "consultotherodetail-import.xlsx", "其它扣款清单");
	}

	/**
	 * excel导入
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData(HttpServletRequest request, HttpServletResponse response, String contractId)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ConsultotherdetailVO> successList = new ArrayList<>();
		List<ConsultotherdetailVO> errorList = new ArrayList<>();
		Map<String, ConsultotherdetailVO> map = new HashMap<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 3; i < result.size(); i++) {
					List<String> datas = result.get(i);
					StringBuilder errorsMsgBuilder = new StringBuilder();

					String subitemCode = datas.get(0);//清单编号
					String subitemName = datas.get(1);//清单项目名称
					String unit = datas.get(2);//单位
					String quantity = datas.get(3);//数量（分包商上报：本期）
					String unitprice = datas.get(4);//除税单价（分包商上报：本期）
					String taxUnitprice = datas.get(5);//含税单价（分包商上报：本期）
					String amounts = datas.get(6);//除税金额（分包商上报：本期）
					String taxAmounts = datas.get(7);//含税金额（分包商上报：本期）
					String cumulativeQuantity = datas.get(8);//数量（分包商上报：累计）
					String cumulativeAmounts = datas.get(9);//除税金额（分包商上报：累计）
					String cumulativeTaxAmounts = datas.get(10);//含税金额（分包商上报：累计）
					String examineQuantity = datas.get(11);//数量（项目部审批：本期）
					String examineUnitprice = datas.get(12);//除税单价（项目部审批：本期）
					String examineTaxUnitprice = datas.get(13);//含税单价（项目部审批：本期）
					String examineAmounts = datas.get(14);//除税金额（项目部审批：本期）
					String examineTaxAmounts = datas.get(15);//含税金额（项目部审批：本期）
					String examineCumulativeQuantity = datas.get(16);//数量（项目部审批：累计）
					String examineCumulativeAmounts = datas.get(17);//除税金额（项目部审批：累计）
					String examineCumulativeTaxAmounts = datas.get(18);//含税金额（项目部审批：累计）
					String source = datas.get(19);//来源
					String memo = datas.get(20);//备注

					ConsultotherdetailVO detailVO = new ConsultotherdetailVO();
					detailVO.setId(IdWorker.getId());//id
					detailVO.setTid(String.valueOf(IdWorker.getId()));//tid
					detailVO.setContractId(Long.parseLong(contractId));//合同id

					detailVO.setSubitemCode(subitemCode); // 清单编号
					detailVO.setSubitemName(subitemName); // 清单项目名称
					detailVO.setUnit(unit); //单位

					if("合同内".equals(source)){
						detailVO.setSource("1"); //来源
					}else if("合同外".equals(source)){
						detailVO.setSource("2"); //来源
					}

					detailVO.setMemo(memo); //备注

					//必填项校验
					if (subitemCode == null || TextUtils.isEmpty(subitemCode)) {
						detailVO.setErrorMsg("清单编号不能为空！");
						errorsMsgBuilder.append("清单编号不能为空！");
					}
					if (subitemName == null || TextUtils.isEmpty(subitemName)) {
						detailVO.setErrorMsg("清单项目名称不能为空！");
						errorsMsgBuilder.append("清单项目名称不能为空！");
					}
					if (unit == null || TextUtils.isEmpty(unit)) {
						detailVO.setErrorMsg("单位不能为空！");
						errorsMsgBuilder.append("单位不能为空！");
					}
					if (quantity == null || TextUtils.isEmpty(quantity)) {
						detailVO.setErrorMsg("数量（分包商上报：本期）不能为空！");
						errorsMsgBuilder.append("数量（分包商上报：本期）不能为空！");
					}
					if (unitprice == null || TextUtils.isEmpty(unitprice)) {
						detailVO.setErrorMsg("除税单价（分包商上报：本期）不能为空！");
						errorsMsgBuilder.append("除税单价（分包商上报：本期）不能为空！");
					}
					if (taxUnitprice == null || TextUtils.isEmpty(taxUnitprice)) {
						detailVO.setErrorMsg("含税单价（分包商上报：本期）不能为空！");
						errorsMsgBuilder.append("含税单价（分包商上报：本期）不能为空！");
					}
					if (examineQuantity == null || TextUtils.isEmpty(examineQuantity)) {
						detailVO.setErrorMsg("数量（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("数量（项目部审批：本期）不能为空！");
					}
					if (examineUnitprice == null || TextUtils.isEmpty(examineUnitprice)) {
						detailVO.setErrorMsg("除税单价（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("除税单价（项目部审批：本期）不能为空！");
					}
					if (examineTaxUnitprice == null || TextUtils.isEmpty(examineTaxUnitprice)) {
						detailVO.setErrorMsg("含税单价（项目部审批：本期）不能为空！");
						errorsMsgBuilder.append("含税单价（项目部审批：本期）不能为空！");
					}

					if (StringUtils.isNotBlank(subitemCode)) {
						detailVO.setInnercode(subitemCode);//清单编号确定唯一性
						if ("01".equals(subitemCode) && subitemName != null && subitemName.contains("装饰")) {
							detailVO.setInnercode("a1");
						}
						//判断是否是装饰工程的子节点编码
						if (subitemCode.length() >= 4) {
							//0111、0112、0113、0114、0115这五个节点都是装饰工程下的
							String code = subitemCode.substring(0, 4);
							if ("0111".equals(code) || "0112".equals(code) || "0113".equals(code) || "0114".equals(code) || "0115".equals(code)) {
								//若是的话，将内码改为a1xx
								detailVO.setInnercode("a1" + subitemCode.substring(2, subitemCode.length()));
							}
						}
						//1、校验编码是否符合规则--2、4、6、9、9以上
						if (subitemCode == null || !(subitemCode.length() == 2 || subitemCode.length() == 4 || subitemCode.length() == 6 || subitemCode.length() >= 9)) {
							detailVO.setErrorMsg("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则");
							errorsMsgBuilder.append("清单编号必须符合：2位、4位、6位、9位或9位以上中任意一规则！");
						}
						detailVO.setSubitemCode(subitemCode);

						//重复性校验
						ConsultotherdetailVO mapVO = map.get(detailVO.getInnercode());
						if (mapVO == null) {
							map.put(detailVO.getInnercode(), detailVO);
						} else {
							detailVO.setErrorMsg("清单编号已存在！");
							errorsMsgBuilder.append("清单编号已存在！");
						}
						detailVO.setSubitemCode(subitemCode);
					}

					//格式校验
					if (StringUtils.isNotBlank(quantity)) {
						if(!NumberUtil.isNumber(quantity)){
							detailVO.setErrorMsg("数量（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("数量（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setQuantity(new BigDecimal(quantity));
						}
					}

					if (StringUtils.isNotBlank(unitprice)) {
						if(!NumberUtil.isNumber(unitprice)){
							detailVO.setErrorMsg("除税单价（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("除税单价（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setUnitprice(new BigDecimal(unitprice));
						}
					}

					if (StringUtils.isNotBlank(taxUnitprice)) {
						if(!NumberUtil.isNumber(taxUnitprice)){
							detailVO.setErrorMsg("含税单价（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("含税单价（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setTaxUnitprice(new BigDecimal(taxUnitprice));
						}
					}

					if (StringUtils.isNotBlank(amounts)) {
						if(!NumberUtil.isNumber(amounts)){
							detailVO.setErrorMsg("除税金额（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("除税金额（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setAmounts(new BigDecimal(amounts));
						}
					} else {
						BigDecimal quantityB = detailVO.getQuantity();
						BigDecimal unitpriceB = detailVO.getUnitprice();
						if(quantityB != null && unitpriceB != null){
							detailVO.setAmounts(quantityB.multiply(unitpriceB));
						}
					}

					if (StringUtils.isNotBlank(taxAmounts)) {
						if(!NumberUtil.isNumber(taxAmounts)){
							detailVO.setErrorMsg("含税金额（分包商上报：本期）格式不正确！");
							errorsMsgBuilder.append("含税金额（分包商上报：本期）格式不正确！");
						}else {
							detailVO.setTaxAmounts(new BigDecimal(taxAmounts));
						}
					} else {
						BigDecimal quantityB = detailVO.getQuantity();
						BigDecimal taxUnitpriceB = detailVO.getTaxUnitprice();
						if(quantityB != null && taxUnitpriceB != null){
							detailVO.setTaxAmounts(quantityB.multiply(taxUnitpriceB));
						}
					}

					if (StringUtils.isNotBlank(examineQuantity)) {
						if(!NumberUtil.isNumber(examineQuantity)){
							detailVO.setErrorMsg("数量（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("数量（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineQuantity(new BigDecimal(examineQuantity));
						}
					}

					if (StringUtils.isNotBlank(examineUnitprice)) {
						if(!NumberUtil.isNumber(examineUnitprice)){
							detailVO.setErrorMsg("除税单价（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("除税单价（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineUnitprice(new BigDecimal(examineUnitprice));
						}
					}

					if (StringUtils.isNotBlank(examineTaxUnitprice)) {
						if(!NumberUtil.isNumber(examineTaxUnitprice)){
							detailVO.setErrorMsg("含税单价（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("含税单价（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineTaxUnitprice(new BigDecimal(examineTaxUnitprice));
						}
					}

					if (StringUtils.isNotBlank(examineAmounts)) {
						if(!NumberUtil.isNumber(examineAmounts)){
							detailVO.setErrorMsg("除税金额（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("除税金额（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineAmounts(new BigDecimal(examineAmounts));
						}
					} else {
						BigDecimal examineQuantityB = detailVO.getExamineQuantity();
						BigDecimal examineUnitpriceB = detailVO.getExamineUnitprice();
						if(examineQuantityB != null && examineUnitpriceB != null){
							detailVO.setExamineAmounts(examineQuantityB.multiply(examineUnitpriceB));
						}
					}

					if (StringUtils.isNotBlank(examineTaxAmounts)) {
						if(!NumberUtil.isNumber(examineTaxAmounts)){
							detailVO.setErrorMsg("含税金额（项目部审批：本期）格式不正确！");
							errorsMsgBuilder.append("含税金额（项目部审批：本期）格式不正确！");
						}else {
							detailVO.setExamineTaxAmounts(new BigDecimal(examineTaxAmounts));
						}
					} else {
						BigDecimal examineQuantityB = detailVO.getExamineQuantity();
						BigDecimal examineTaxUnitpriceB = detailVO.getExamineTaxUnitprice();
						if(examineQuantityB != null && examineTaxUnitpriceB != null){
							detailVO.setExamineTaxAmounts(examineQuantityB.multiply(examineTaxUnitpriceB));
						}
					}

					//抓取子表累计值
					if(StringUtils.isNotBlank(subitemCode)){
						//导入的本期
						BigDecimal quantityB = detailVO.getQuantity();
						BigDecimal amountsB = detailVO.getAmounts();
						BigDecimal taxAmountsB = detailVO.getTaxAmounts();
						BigDecimal examineQuantityB = detailVO.getExamineQuantity();
						BigDecimal examineAmountsB = detailVO.getExamineAmounts();
						BigDecimal examineTaxAmountsB = detailVO.getExamineTaxAmounts();

						//查询该清单编码往期累计
						//创建条件构造器
						QueryWrapper<ConsultotherdetailEntity> queryWrapper = new QueryWrapper<>();
						queryWrapper.eq("contract_id", contractId);
						queryWrapper.eq("subitem_code", subitemCode);
						queryWrapper.in("bill_state", 1, 3);//1直审 3审批通过
						queryWrapper.eq("dr", "0");
						queryWrapper.orderByDesc("create_time");//最新往期
						queryWrapper.last("limit 1");
						List<ConsultotherdetailEntity> pastDetails = consultotherdetailService.list(queryWrapper);
						if(pastDetails != null && pastDetails.size() > 0){
							ConsultotherdetailEntity pastConsultotherdetail = pastDetails.get(0);
							BigDecimal pastQuantityB = pastConsultotherdetail.getCumulativeQuantity();
							BigDecimal pastAmountsB = pastConsultotherdetail.getCumulativeAmounts();
							BigDecimal pastTaxAmountsB = pastConsultotherdetail.getCumulativeTaxAmounts();
							BigDecimal pastExamineQuantityB = pastConsultotherdetail.getExamineCumulativeQuantity();
							BigDecimal pastExamineAmountsB = pastConsultotherdetail.getExamineCumulativeAmounts();
							BigDecimal pastExamineTaxAmountsB = pastConsultotherdetail.getExamineCumulativeTaxAmounts();
							if(quantityB != null){
								pastQuantityB = pastQuantityB.add(quantityB);
							}
							if(amountsB != null){
								pastAmountsB = pastAmountsB.add(amountsB);
							}
							if(taxAmountsB != null){
								pastTaxAmountsB = pastTaxAmountsB.add(taxAmountsB);
							}
							if(examineQuantityB != null){
								pastExamineQuantityB = pastExamineQuantityB.add(examineQuantityB);
							}
							if(examineAmountsB != null){
								pastExamineAmountsB = pastExamineAmountsB.add(examineAmountsB);
							}
							if(examineTaxAmountsB != null){
								pastExamineTaxAmountsB = pastExamineTaxAmountsB.add(examineTaxAmountsB);
							}
							//数量（分包商上报累计）
							detailVO.setCumulativeQuantity(pastQuantityB);
							//除税金额（分包商上报累计）
							detailVO.setCumulativeAmounts(pastAmountsB);
							//含税金额（分包商上报累计）
							detailVO.setCumulativeTaxAmounts(pastTaxAmountsB);
							//数量（项目部审核累计）
							detailVO.setExamineCumulativeQuantity(pastExamineQuantityB);
							//除税金额（项目部审核累计）
							detailVO.setExamineCumulativeAmounts(pastExamineAmountsB);
							//含税金额（项目部审核累计）
							detailVO.setExamineCumulativeTaxAmounts(pastExamineTaxAmountsB);
						}else {
							if(quantityB != null){
								detailVO.setCumulativeQuantity(quantityB);
							}
							if(amountsB != null){
								detailVO.setCumulativeAmounts(amountsB);
							}
							if(taxAmountsB != null){
								detailVO.setCumulativeTaxAmounts(taxAmountsB);
							}
							if(examineQuantityB != null){
								detailVO.setExamineCumulativeQuantity(examineQuantityB);
							}
							if(examineAmountsB != null){
								detailVO.setExamineCumulativeAmounts(examineAmountsB);
							}
							if(examineTaxAmountsB != null){
								detailVO.setExamineCumulativeTaxAmounts(examineTaxAmountsB);
							}
						}
					}

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(detailVO);
					} else {
						successList.add(detailVO);
					}
				}
			}
		}

		//按子目编码排序
		Collections.sort(successList, new Comparator<ConsultotherdetailVO>() {
			@Override
			public int compare(ConsultotherdetailVO o1, ConsultotherdetailVO o2) {
				return o1.getSubitemCode().compareTo(o2.getSubitemCode());
			}
		});

		//设置tid和tpid
		List<ConsultotherdetailVO> resList = setTidAndTpid(successList, map);
		//构建树
		resList = createTreeData(resList);

		//统计父级的合计数值
//		getChildrenUnitTotalAmount(resList);

		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", resList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导入其它扣款清单
	 *
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/import3", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<Object> importData3(HttpServletRequest request, HttpServletResponse response)
			throws ParseException {
		MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
		Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
		List<ConsultotherodetailVO> successList = new ArrayList<>();
		List<ConsultotherodetailVO> errorList = new ArrayList<>();
		DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
		boolean isFailed = false;
		MultipartFile mf = null;
		for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
			mf = entity.getValue();
			String originalFileName = mf.getOriginalFilename();
			String extName = null;
			originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
			originalFileName.replaceAll("00.", "");
			extName = FileUtils.getFileExt(originalFileName, false);
			if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
				isFailed = true;
				break;
			}
		}
		if (isFailed) {
			return CommonResponse.error("文件格式不合法");
		} else {
			List<List<String>> result = ExcelReader.readExcel(mf);
			if (result != null && result.size() > 0) {
				for (int i = 1; i < result.size(); i++) {
					StringBuilder errorsMsgBuilder = new StringBuilder();
					ConsultotherodetailVO vo = new ConsultotherodetailVO();

					List<String> datas = result.get(i);
					String expenseName = datas.get(0);//费用名称
					String unit = datas.get(1);//单位
					String quantity = datas.get(2);//数量
					String unitPrice = datas.get(3);//单价
					String amounts = datas.get(4);//金额
					String remarks = datas.get(5);//备注

					vo.setId(IdWorker.getId());
					vo.setExpenseName(expenseName);
					vo.setUnit(unit);
					vo.setRemarks(remarks);

					//格式校验
					if(StringUtils.isNotBlank(quantity)){
						if(NumberUtil.isNumber(quantity)){
							vo.setoQuantity(new BigDecimal(quantity));
						}else {
							vo.setErrorMsg("数量格式不正确！");
							errorsMsgBuilder.append("数量格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(unitPrice)){
						if(NumberUtil.isNumber(unitPrice)){
							vo.setoUnitPrice(new BigDecimal(unitPrice));
						}else {
							vo.setErrorMsg("单价格式不正确！");
							errorsMsgBuilder.append("单价格式不正确！");
						}
					}

					if(StringUtils.isNotBlank(amounts)){
						if(NumberUtil.isNumber(amounts)){
							vo.setAmounts(new BigDecimal(amounts));
						}else {
							vo.setErrorMsg("金额格式不正确！");
							errorsMsgBuilder.append("金额格式不正确！");
						}
					}else {
						BigDecimal quantityB = vo.getoQuantity();
						BigDecimal unitPriceB = vo.getoUnitPrice();
						if(quantityB != null && unitPriceB != null){
							BigDecimal amountsB = quantityB.multiply(unitPriceB);
							vo.setAmounts(amountsB);
						}
					}

					if (errorsMsgBuilder.length() > 0) {
						errorList.add(vo);
					} else {
						successList.add(vo);
					}
				}
			}
		}
		JSONObject json = new JSONObject();
		json.put("successNum", successList.size());
		json.put("successList", successList);
		json.put("errorList", errorList);
		json.put("errorNum", errorList.size());
		return CommonResponse.success(json);
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export", method = RequestMethod.POST)
	@ResponseBody
	public void export(@RequestBody ConsultotherVO consultotherVO, HttpServletResponse response) {
		QueryWrapper<ConsultotherdetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", consultotherVO.getId());
		queryWrapper.eq("dr", 0);
		List<ConsultotherdetailEntity> list = consultotherdetailService.list(queryWrapper);
		List<ConsultotherdetailVO> voList = BeanMapper.mapList(list, ConsultotherdetailVO.class);
		List<ConsultotherdetailVO> records = new ArrayList<>();

		//构建树
		voList = createTreeData(voList);

		for(ConsultotherdetailVO vo : voList){
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("consultotherdetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage(@RequestBody List<ConsultotherdetailVO> list, HttpServletResponse response) {
		List<ConsultotherdetailVO> records = new ArrayList<>();
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				ConsultotherdetailVO vo = list.get(i);
				String source = vo.getSource();
				if("1".equals(source)){//来源：1合同内 2合同外
					source = "合同内";
				}else if("2".equals(source)){
					source = "合同外";
				}
				vo.setSource(source);
				records.add(vo);
				if(vo.getChildren()!=null&&vo.getChildren().size()>0){
					this.splitList(vo.getChildren(),records);
				}
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", records);
		ExcelExport.getInstance().export("consultotherdetail-export.xlsx", beans, response);
	}

	/**
	 * 导出遍历加上所有子表
	 * @param list
	 * @param records
	 */
	private void splitList(List<ConsultotherdetailVO> list,List<ConsultotherdetailVO> records) {
		for(ConsultotherdetailVO vo : list){
			String source = vo.getSource();
			if("1".equals(source)){//来源：1合同内 2合同外
				source = "合同内";
			}else if("2".equals(source)){
				source = "合同外";
			}
			vo.setSource(source);
			records.add(vo);
			if(vo.getChildren()!=null&&vo.getChildren().size()>0){
				this.splitList(vo.getChildren(),records);
			}
		}
	}

	/**
	 * excel导出数据库数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/export3", method = RequestMethod.POST)
	@ResponseBody
	public void export3(@RequestBody ConsultotherVO vo, HttpServletResponse response) {
		QueryWrapper<ConsultotherodetailEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("mid", vo.getId());
		queryWrapper.eq("dr", 0);
		List<ConsultotherodetailEntity> list = consultotherodetailService.list(queryWrapper);
		List<ConsultotherodetailVO> vOList = BeanMapper.mapList(list, ConsultotherodetailVO.class);
		if (!CollectionUtil.isEmpty(vOList)) {
			for (int i = 0; i < vOList.size(); i++) {
				ConsultotherodetailVO linevo = vOList.get(i);
				linevo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", vOList);
		ExcelExport.getInstance().export("consultotherodetail-export.xlsx", beans, response);
	}

	/**
	 * excel导出页面数据
	 *
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "/exportFromPage3", method = RequestMethod.POST)
	@ResponseBody
	public void exportFromPage3(@RequestBody List<ConsultotherodetailVO> list, HttpServletResponse response) {
		if (list != null && list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				ConsultotherodetailVO vo = list.get(i);
				vo.setSort(String.valueOf(i + 1));
			}
		}
		Map<String, Object> beans = new HashMap<String, Object>();
		beans.put("records", list);
		ExcelExport.getInstance().export("consultotherodetail-export.xlsx", beans, response);
	}

	/**
	 * 设置tid和tpid
	 *
	 * @param vos
	 * @param map
	 * @return
	 */
	private List<ConsultotherdetailVO> setTidAndTpid(List<ConsultotherdetailVO> vos, Map<String, ConsultotherdetailVO> map) {
		if(vos == null){
			return null;
		}

		for (int i = 0; i < vos.size(); i++) {
			ConsultotherdetailVO consultotherdetailVO = vos.get(i);
			//设置父级id
			String innercode = consultotherdetailVO.getInnercode();
			if(innercode == null){
				continue;
			}
			Long pid = null;
			if (innercode.length() == 2) {
				//最上级
			} else if (innercode.length() == 4) {
				String pcode = innercode.substring(0, 2);
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercode.length() == 6) {
				String pcode = innercode.substring(0, 4);
				//有父节点
				pid = this.setPid(pcode, map);
			} else if (innercode.length() > 6) {
				String pcode = innercode.substring(0, 6);
				//有父节点
				pid = this.setPid(pcode, map);
			}

			if (pid != null) {
				consultotherdetailVO.setTpid(pid.toString());
			} else {
				consultotherdetailVO.setTpid("");
			}
		}

		return vos;
	}

	//子目编码规则定死------分别是2位/4位/6位/6为以上
	private Long setPid(String pcode, Map<String, ConsultotherdetailVO> map) {
		if (map.get(pcode) != null) {
			return Long.valueOf(map.get(pcode).getTid());
		} else {
			//父级没有找到，则继续往上找

			if (pcode.length() == 2) {
				//最上级
				return null;
			} else if (pcode.length() == 4) {
				String ppcode = pcode.substring(0, 2);
				return this.setPid(ppcode, map);
			} else if (pcode.length() == 6) {
				String ppcode = pcode.substring(0, 4);
				return this.setPid(ppcode, map);
			} else if (pcode.length() > 6) {
				String ppcode = pcode.substring(0, 6);
				return this.setPid(ppcode, map);
			} else {
				return null;
			}
		}
	}

	/**
	 * 构建树
	 *
	 * @param list
	 * @return
	 */
	public static List<ConsultotherdetailVO> createTreeData(List<ConsultotherdetailVO> list) {
		List<ConsultotherdetailVO> resp = new ArrayList<>();
		List<String> rootItems = new ArrayList<String>();

		//循环list，放入listMap重
		Map<String, ConsultotherdetailVO> listMap = new HashMap<>();
		for (ConsultotherdetailVO item : list) {
			listMap.put(item.getTid().toString(), item);
		}

		for (int i = 0; i < list.size(); i++) {
			ConsultotherdetailVO item = list.get(i);
			String parentId = (item.getTpid() != null) ? item.getTpid().toString() : "";
			ConsultotherdetailVO parent = listMap.get(parentId);
			if (parent != null) {
				List<ConsultotherdetailVO> child = (List<ConsultotherdetailVO>) parent.getChildren();
				if (child != null) {
					child.add(item);
				} else {
					List<ConsultotherdetailVO> children = new ArrayList<ConsultotherdetailVO>();
					children.add(item);
					parent.setChildren(children);
				}
			} else {
				rootItems.add(item.getTid());
			}
		}

		for (String rootId : rootItems) {
			resp.add(listMap.get(rootId));
		}

		return resp;
	}
}
