package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.DesignsubcontractnodedetailEntity;
import com.ejianc.business.middlemeasurement.service.IDesignsubcontractnodedetailService;
import com.ejianc.business.middlemeasurement.vo.DesignsubcontractnodedetailVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("designsubcontractnodeExport")
public class ExceldesignsubcontractnodeController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IDesignsubcontractnodedetailService detailService;

    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadDesignsubcontractnode", method = RequestMethod.POST)
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "designsubcontractnode-import.xlsx", "设计分包节点报量申请模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportDesignsubcontractnode", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportInterimsettlement(HttpServletRequest request, HttpServletResponse response, Long contract, Long projectId) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<DesignsubcontractnodedetailVO> successList = new ArrayList<>();
        List<DesignsubcontractnodedetailVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);

            if (result != null && result.size() > 0) {
                //查询子表累计
                QueryWrapper<DesignsubcontractnodedetailEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("dr", 0);
                wrapper.eq("contract", contract);
                wrapper.eq("project_id", projectId);
                wrapper.in("bill_state", 1, 3);
                wrapper.orderByDesc("create_time");
                wrapper.last("limit 0,1");
                List<DesignsubcontractnodedetailEntity> pastDetailEntityList = detailService.list(wrapper);

                for (int i = 2; i < result.size(); i++) {
                    StringBuilder errorsMsgBuilder = new StringBuilder();

                    DesignsubcontractnodedetailVO designsubcontractnodedetailVO = new DesignsubcontractnodedetailVO();
                    List<String> datas = result.get(i);
                    designsubcontractnodedetailVO.setSort(String.valueOf(IdWorker.getId()));//id
                    //设置子表合同id
                    designsubcontractnodedetailVO.setContract(contract);
                    //设置子表项目id
                    designsubcontractnodedetailVO.setProjectId(projectId);

                    //累计审核
                    BigDecimal completeAmt = new BigDecimal(0);
                    BigDecimal exTaxUnitAmt = new BigDecimal(0);
                    BigDecimal inTaxUnitAmt = new BigDecimal(0);

                    String completeContent = datas.get(0);//完成内容
                    String projectName = datas.get(1);//项目名称
                    String measuringUnit = datas.get(2);//计量单位
                    String completeThisDeclare = datas.get(3);//完成内容
                    String exTaxUnitThisDeclare = datas.get(4);//除税单价（本期申报）
                    String inTaxUnitThisDeclare = datas.get(5);//含税单价（本期申报）
                    String exTaxTotalThisDeclare = datas.get(6);//除税合价（本期申报）
                    String inTaxTotalThisDeclare = datas.get(7);//含税合价（本期申报）

                    String completeThisAudit = datas.get(13);//完成量（本期审核）
                    String exTaxUnitThisAudit = datas.get(14);//除税单价（本期审核）
                    String inTaxUnitThisAudit = datas.get(15);//含税单价（本期审核）
                    String exTaxTotalThisAudit = datas.get(16);//除税合价（本期审核）
                    String inTaxTotalThisAudit = datas.get(17);//含税合价（本期审核）

                    String completeCumulativeAudit = datas.get(18);//累计完成
                    String exTaxUnitCumulativeAudit = datas.get(19);//累计除税单价（累计审核）
                    String inTaxUnitCumulativeAudit = datas.get(20);//累计含税单价（累计审核）
                    String exTaxTotalCumulativeAudit = datas.get(21);//除税合价（累计审核）
                    String inTaxTotalCumulativeAudit = datas.get(22);//含税合价（累计审核）
                    String remarks = datas.get(23);//完成内容

                    //先导入与往期无关的列
                    designsubcontractnodedetailVO.setId(IdWorker.getId());
                    designsubcontractnodedetailVO.setCompleteContent(completeContent); // 完成内容

                    if (StringUtils.isBlank(projectName)) {
                        designsubcontractnodedetailVO.setErrorMsg("项目名称不能为空！");
                        errorsMsgBuilder.append("项目名称不能为空");
                    } else {
                        designsubcontractnodedetailVO.setProjectName(projectName); // 项目名称
                    }

                    if (StringUtils.isBlank(measuringUnit)) {
                        designsubcontractnodedetailVO.setErrorMsg("计量单位不能为空！");
                        errorsMsgBuilder.append("计量单位不能为空");
                    } else {
                        designsubcontractnodedetailVO.setMeasuringUnit(measuringUnit); //计量单位
                    }

                    if (StringUtils.isBlank(completeThisDeclare)) {
                        designsubcontractnodedetailVO.setErrorMsg("完成量（本期申报）不能为空！");
                        errorsMsgBuilder.append("完成量（本期申报）不能为空");
                    } else {
                        if (!NumberUtil.isNumber(completeThisDeclare)) {
                            designsubcontractnodedetailVO.setErrorMsg("完成量（本期申报）格式错误！");
                            errorsMsgBuilder.append("完成量（本期申报）格式错误");
                        } else {
                            designsubcontractnodedetailVO.setCompleteThisDeclare(new BigDecimal(completeThisDeclare)); //  完成量（本期申报）
                        }
                    }
                    if (StringUtils.isBlank(exTaxUnitThisDeclare)) {
                        designsubcontractnodedetailVO.setErrorMsg("除税单价（本期申报）不能为空！");
                        errorsMsgBuilder.append("除税单价（本期申报）不能为空");
                    } else {
                        if (!NumberUtil.isNumber(exTaxUnitThisDeclare)) {
                            designsubcontractnodedetailVO.setErrorMsg("除税单价（本期申报）格式错误！");
                            errorsMsgBuilder.append("除税单价（本期申报）格式错误");
                        } else {
                            designsubcontractnodedetailVO.setExTaxUnitThisDeclare(new BigDecimal(exTaxUnitThisDeclare)); // 除税单价（本期申报）
                        }
                    }

                    if (StringUtils.isBlank(inTaxUnitThisDeclare)) {
                        designsubcontractnodedetailVO.setErrorMsg("含税单价（本期申报）不能为空！");
                        errorsMsgBuilder.append("含税单价（本期申报）不能为空");
                    } else {
                        if (!NumberUtil.isNumber(inTaxUnitThisDeclare)) {
                            designsubcontractnodedetailVO.setErrorMsg("含税单价（本期申报）格式错误！");
                            errorsMsgBuilder.append("含税单价（本期申报）格式错误");
                        } else {
                            designsubcontractnodedetailVO.setInTaxUnitThisDeclare(new BigDecimal(inTaxUnitThisDeclare)); // 含税单价（本期申报）
                        }
                    }

                    if (StringUtils.isBlank(exTaxTotalThisDeclare)) {
                        BigDecimal completeThisDeclareB = designsubcontractnodedetailVO.getCompleteThisDeclare();
                        BigDecimal exTaxUnitThisDeclareB = designsubcontractnodedetailVO.getExTaxUnitThisDeclare();
                        if(completeThisDeclareB != null && exTaxUnitThisDeclareB != null){
                            designsubcontractnodedetailVO.setExTaxTotalThisDeclare(completeThisDeclareB.multiply(exTaxUnitThisDeclareB));
                        }
                    } else {
                        designsubcontractnodedetailVO.setExTaxTotalThisDeclare(new BigDecimal(exTaxTotalThisDeclare)); //除税合价（本期申报）
                    }

                    if (StringUtils.isBlank(inTaxTotalThisDeclare)) {
                        BigDecimal completeThisDeclareB = designsubcontractnodedetailVO.getCompleteThisDeclare();
                        BigDecimal inTaxUnitThisDeclareB = designsubcontractnodedetailVO.getInTaxUnitThisDeclare();
                        if(completeThisDeclareB != null && inTaxUnitThisDeclareB != null){
                            designsubcontractnodedetailVO.setInTaxTotalThisDeclare(completeThisDeclareB.multiply(inTaxUnitThisDeclareB));
                        }
                    } else {
                        designsubcontractnodedetailVO.setInTaxTotalThisDeclare(new BigDecimal(inTaxUnitThisDeclare));// 含税合价（本期申报）
                    }

                    if (StringUtils.isBlank(completeThisAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("完成量（本期审核）不能为空！");
                        errorsMsgBuilder.append("完成量（本期审核）不能为空！");
                    } else {
                        if (!NumberUtil.isNumber(completeThisAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("完成量（本期审核）格式错误！");
                            errorsMsgBuilder.append("完成量（本期审核）格式错误！");
                        } else {
                            designsubcontractnodedetailVO.setCompleteThisAudit(new BigDecimal(completeThisAudit)); // 完成量（本期审核）
                        }
                    }

                    if (StringUtils.isBlank(exTaxUnitThisAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("除税单价（本期审核）不能为空！");
                        errorsMsgBuilder.append("除税单价（本期审核）不能为空！");
                    } else {
                        if (!NumberUtil.isNumber(exTaxUnitThisAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("除税单价（本期审核）格式错误！");
                            errorsMsgBuilder.append("除税单价（本期审核）不能为空！");
                        } else {
                            designsubcontractnodedetailVO.setExTaxUnitThisAudit(new BigDecimal(exTaxUnitThisAudit)); // 除税单价（本期审核）
                        }
                    }

                    if (StringUtils.isBlank(inTaxUnitThisAudit)) {
                        designsubcontractnodedetailVO.setErrorMsg("含税单价（本期审核）不能为空！");
                        errorsMsgBuilder.append("含税单价（本期审核）不能为空！");
                    } else {
                        if (!NumberUtil.isNumber(inTaxUnitThisAudit)) {
                            designsubcontractnodedetailVO.setErrorMsg("含税单价（本期审核）格式错误！");
                            errorsMsgBuilder.append("含税单价（本期审核）格式错误！");
                        } else {
                            designsubcontractnodedetailVO.setInTaxUnitThisAudit(new BigDecimal(inTaxUnitThisAudit));// 含税单价（本期审核）
                        }
                    }

                    if (StringUtils.isBlank(exTaxTotalThisAudit)) {
                        BigDecimal completeThisAuditB = designsubcontractnodedetailVO.getCompleteThisAudit();
                        BigDecimal exTaxUnitThisAuditB = designsubcontractnodedetailVO.getExTaxUnitThisAudit();
                        if(completeThisAuditB != null && exTaxUnitThisAuditB != null){
                            designsubcontractnodedetailVO.setExTaxTotalThisAudit(completeThisAuditB.multiply(exTaxUnitThisAuditB));
                        }
                    } else {
                        designsubcontractnodedetailVO.setExTaxTotalThisAudit(new BigDecimal(exTaxTotalThisAudit));// 除税合价（本期审核）
                    }

                    if (StringUtils.isBlank(inTaxTotalThisAudit)) {
                        BigDecimal completeThisAuditB = designsubcontractnodedetailVO.getCompleteThisAudit();
                        BigDecimal inTaxUnitThisAuditB = designsubcontractnodedetailVO.getInTaxUnitThisAudit();
                        if(completeThisAuditB != null && inTaxUnitThisAuditB != null){
                            designsubcontractnodedetailVO.setInTaxTotalThisAudit(completeThisAuditB.multiply(inTaxUnitThisAuditB));
                        }
                    } else {
                        designsubcontractnodedetailVO.setInTaxTotalThisAudit(new BigDecimal(inTaxTotalThisAudit)); // 含税合价（本期审核）
                    }


                    //导入与往期有关的列
                    if (CollectionUtil.isNotEmpty(pastDetailEntityList)) {
                        //-------------------往期数据------------------------------
                        //往期数据不为空
                        DesignsubcontractnodedetailEntity data = pastDetailEntityList.get(0);

                        //完成量（累计审核）
                        BigDecimal completeThisAuditB = data.getCompleteThisAudit() == null ? new BigDecimal(0) : data.getCompleteThisAudit();
                        //除税单价（累计审核）
                        BigDecimal exTaxUnitThisAuditB = data.getExTaxUnitThisAudit() == null ? new BigDecimal(0) : data.getExTaxUnitThisAudit();
                        //含税单价（累计审核）
                        BigDecimal inTaxUnitThisAuditB = data.getInTaxUnitThisAudit() == null ? new BigDecimal(0) : data.getInTaxUnitThisAudit();


                        //上期累计带入
                        designsubcontractnodedetailVO.setCompleteLastAudit(completeThisAuditB);

                        designsubcontractnodedetailVO.setExTaxUnitLastAudit(exTaxUnitThisAuditB);

                        designsubcontractnodedetailVO.setInTaxUnitLastAudit(inTaxUnitThisAuditB);

                        designsubcontractnodedetailVO.setExTaxTotalLastAudit(completeThisAuditB.multiply(exTaxUnitThisAuditB));

                        designsubcontractnodedetailVO.setInTaxTotalLastAudit(completeThisAuditB.multiply(inTaxUnitThisAuditB));

                        //-------------------往期数据------------------------------

                        //-------------------本期数据------------------------------
                        //完成量（累计审核）本期
                        BigDecimal currentCompleteThisAuditB = designsubcontractnodedetailVO.getCompleteThisAudit();
                        //除税单价（累计审核）
                        BigDecimal currentExTaxUnitThisAuditB = designsubcontractnodedetailVO.getExTaxUnitThisAudit();
                        //含税单价（累计审核）
                        BigDecimal currentInTaxUnitThisAuditB = designsubcontractnodedetailVO.getInTaxUnitThisAudit();
                        //-------------------本期数据------------------------------

                        if(currentCompleteThisAuditB != null){
                            completeAmt = currentCompleteThisAuditB.add(completeThisAuditB);  //累计完成 = 本期完成+上期审核完成
                            designsubcontractnodedetailVO.setCompleteCumulativeAudit(completeAmt);
                        }else {
                            designsubcontractnodedetailVO.setCompleteCumulativeAudit(completeThisAuditB);
                        }

                        if (currentExTaxUnitThisAuditB != null) {
                            exTaxUnitAmt = currentExTaxUnitThisAuditB.add(exTaxUnitThisAuditB);  //累计除税 = 本期除税+上期审核除税
                            designsubcontractnodedetailVO.setExTaxUnitCumulativeAudit(exTaxUnitAmt);
                        }else {
                            designsubcontractnodedetailVO.setExTaxUnitCumulativeAudit(exTaxUnitThisAuditB);
                        }

                        if (currentInTaxUnitThisAuditB != null) {
                            inTaxUnitAmt = currentInTaxUnitThisAuditB.add(inTaxUnitThisAuditB);  //累计含税 = 本期含税+上期审核含税
                            designsubcontractnodedetailVO.setInTaxUnitCumulativeAudit(inTaxUnitAmt);
                        }else {
                            designsubcontractnodedetailVO.setInTaxUnitCumulativeAudit(inTaxUnitThisAuditB);
                        }

                        designsubcontractnodedetailVO.setExTaxTotalCumulativeAudit(completeAmt.multiply(exTaxUnitAmt));
                        designsubcontractnodedetailVO.setInTaxTotalCumulativeAudit(completeAmt.multiply(inTaxUnitAmt));

                    } else {
                        //往期数据为空
                        //上期
                        designsubcontractnodedetailVO.setCompleteLastAudit(null);

                        designsubcontractnodedetailVO.setExTaxUnitLastAudit(null);

                        designsubcontractnodedetailVO.setInTaxUnitLastAudit(null);

                        designsubcontractnodedetailVO.setExTaxTotalLastAudit(null);

                        designsubcontractnodedetailVO.setInTaxTotalLastAudit(null);

                        //累计
                        designsubcontractnodedetailVO.setCompleteCumulativeAudit(designsubcontractnodedetailVO.getCompleteThisAudit());

                        designsubcontractnodedetailVO.setExTaxUnitCumulativeAudit(designsubcontractnodedetailVO.getExTaxUnitThisAudit());

                        designsubcontractnodedetailVO.setInTaxUnitCumulativeAudit(designsubcontractnodedetailVO.getInTaxUnitThisAudit());

                        designsubcontractnodedetailVO.setExTaxTotalCumulativeAudit(designsubcontractnodedetailVO.getExTaxTotalThisAudit());

                        designsubcontractnodedetailVO.setInTaxTotalCumulativeAudit(designsubcontractnodedetailVO.getInTaxTotalThisAudit());
                    }

                    designsubcontractnodedetailVO.setRemarks(remarks); // 备注

                    if (errorsMsgBuilder.length() > 0) {
                        errorList.add(designsubcontractnodedetailVO);
                    } else {
                        successList.add(designsubcontractnodedetailVO);
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDesignsubcontractnodeFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody DesignsubcontractnodedetailVO
                                                              detailVo, HttpServletResponse response) {
        QueryWrapper<DesignsubcontractnodedetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", detailVo.getId());
        queryWrapper.eq("dr", 0);
        List<DesignsubcontractnodedetailEntity> list = detailService.list(queryWrapper);
        List<DesignsubcontractnodedetailVO> designsubcontractnodedetailVOList = BeanMapper.mapList(list, DesignsubcontractnodedetailVO.class);
        if (designsubcontractnodedetailVOList != null && designsubcontractnodedetailVOList.size() > 0) {
            for (int i = 0; i < designsubcontractnodedetailVOList.size(); i++) {
                DesignsubcontractnodedetailVO designsubcontractnodedetailVO = designsubcontractnodedetailVOList.get(i);
                designsubcontractnodedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", designsubcontractnodedetailVOList);
        ExcelExport.getInstance().export("designsubcontractnode-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportDesignsubcontractnodeFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage
    (@RequestBody List<DesignsubcontractnodedetailVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                DesignsubcontractnodedetailVO designsubcontractnodedetailVO = list.get(i);
                designsubcontractnodedetailVO.setSort(String.valueOf(i + 1));
            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("designsubcontractnode-export.xlsx", beans, response);
    }


}
