package com.ejianc.business.middlemeasurement.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.*;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 成本管理
 */
@Controller
@RequestMapping("api/cost/")
public class CostApiController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ISubcontractingvolumeService subcontractingvolumeService;

    @Autowired
    private IVisaclaimaccountService iVisaclaimaccountService;

    @Autowired
    private IEngineermeasurementService iEngineermeasurementService;

    @Autowired
    private ISubcontractaccountService iSubcontractaccountService;

    @Autowired
    private IPurchasesummaryService iPurchasesummaryService;

    @Autowired
    private IRevolvingleasesummaryService iRevolvingleasesummaryService;

    @Autowired
    private  IMechanicalleasedetotalService iMechanicalleasedetotalService;
    /**
     * 成本核算的人工费、分包费
     *
     * @return
     */
    @RequestMapping(value = "queryCostaccountLabor", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryCostaccountLabor(@RequestParam(value = "projectId") Long projectId, @RequestParam String costaccountTime) {
        QueryWrapper<SubcontractingvolumeEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("project_id", projectId);
        queryWrapper.le("create_time", costaccountTime);
        List<SubcontractingvolumeEntity> list = subcontractingvolumeService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for (int i = 0; i < list.size(); i++) {
            SubcontractingvolumeEntity subcontractingvolume = list.get(i);
            if(subcontractingvolume.getTaxCurrentTotal() != null){
                total = total.add(subcontractingvolume.getTaxCurrentTotal());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 项目部商务经理月度报告-合同延长天数
     */
    @RequestMapping(value = "queryProjectreportExtendday", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<Integer> queryProjectreportExtendday(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<VisaclaimaccountEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract", contractId);
        queryWrapper.eq("dr",0);
        List<VisaclaimaccountEntity> visaclaimaccountList = iVisaclaimaccountService.list(queryWrapper);
        Integer total = 0;
        for(int j = 0; j < visaclaimaccountList.size(); j++){
            List<VisaclaimaccountdetailEntity> visaclaimaccountDetailList = iVisaclaimaccountService.selectById(visaclaimaccountList.get(j).getId()).getVisaclaimaccountdetailEntities();
            for (int i = 0; i < visaclaimaccountDetailList.size(); i++) {
                VisaclaimaccountdetailEntity visaclaimaccountdetailEntity = visaclaimaccountDetailList.get(i);
                if(visaclaimaccountdetailEntity.getDeferredDays() != null){
                    total = total + visaclaimaccountdetailEntity.getDeferredDays();
                }
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 项目部商务经理月度报告-合同期内已获索赔的签证份数
     */
    @RequestMapping(value = "queryProjectreportNum", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<Integer> queryProjectreportNum(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<VisaclaimaccountEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract", contractId);
        queryWrapper.eq("dr",0);
        List<VisaclaimaccountEntity> visaclaimaccountList = iVisaclaimaccountService.list(queryWrapper);
        return CommonResponse.success("查询数据成功", visaclaimaccountList.size());
    }

    /**
     * 项目部商务经理月度报告-合同期内已获批准的费用索赔费用金额
     */
    @RequestMapping(value = "queryProjectreportMoney", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryProjectreportMoney(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<VisaclaimaccountEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract", contractId);
        queryWrapper.eq("dr",0);
        List<VisaclaimaccountEntity> list = iVisaclaimaccountService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for(int i = 0; i < list.size(); i++){
            if(list.get(i).getInConfirmAmountOpposite() != null){
                total = total.add(list.get(i).getInConfirmAmountOpposite());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 项目部商务经理月度报告-建设方核定工程量
     */
    @RequestMapping(value = "queryProjectreportBulider", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryProjectreportBulider(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr",0);
        List<EngineermeasurementEntity> list = iEngineermeasurementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for(int i = 0; i < list.size(); i++){
            if(list.get(i).getCurrentBatch() != null){
                total = total.add(list.get(i).getCurrentBatch());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 项目部商务经理月度报告-已申报工程量
     */
    @RequestMapping(value = "queryProjectreportDeclared", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryProjectreportDeclared(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr",0);
        List<EngineermeasurementEntity> list = iEngineermeasurementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for(int i = 0; i < list.size(); i++){
            if(list.get(i).getActualCompletedThisPeriod() != null){
                total = total.add(list.get(i).getActualCompletedThisPeriod());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }
    /**
     * 项目部商务经理月度报告-已完成工程到款总计
     */
    @RequestMapping(value = "queryProjectreportFinishprojectmoneytotal", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryProjectreportFinishprojectmoneytotal(@RequestParam(value = "contractId") Long contractId) {
        QueryWrapper<EngineermeasurementEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", contractId);
        queryWrapper.eq("dr",0);
        List<EngineermeasurementEntity> list = iEngineermeasurementService.list(queryWrapper);
        BigDecimal total = new BigDecimal("0.00");
        for(int i = 0; i < list.size(); i++){
            if(list.get(i).getCurrentCollection() != null){
                total = total.add(list.get(i).getCurrentCollection());
            }
        }
        return CommonResponse.success("查询数据成功", total);
    }

    /**
     * 债务分析-项目债务
     */
    @RequestMapping(value = "queryDebtanalysisProjectdebt", method = RequestMethod.GET)
    @ResponseBody
    private CommonResponse<BigDecimal> queryDebtanalysisProjectdebt(@RequestParam(value = "projectId") Long projectId,@RequestParam String time) {
        BigDecimal totalSub1 = new BigDecimal("0.00");
        BigDecimal totalSub2 = new BigDecimal("0.00");
        QueryWrapper<SubcontractaccountEntity> queryWrapperSub = new QueryWrapper<>();
        queryWrapperSub.eq("project_id", projectId);
        queryWrapperSub.le("create_time", time);
        queryWrapperSub.eq("dr",0);
        List<SubcontractaccountEntity> listSub = iSubcontractaccountService.list(queryWrapperSub);
        for(int j = 0; j < listSub.size(); j++){
            List<SubcontractaccountdetailEntity> detailListSub = iSubcontractaccountService.selectById(listSub.get(j).getId()).getSubcontractaccountdetailEntities();
            for(int i = 0; i < detailListSub.size(); i++){
                if(detailListSub.get(i).getTaxCumulativeApproval()!=null){
                    totalSub1 = totalSub1.add(detailListSub.get(i).getTaxCumulativeApproval());
                }
                if(detailListSub.get(i).getCumulativePayment()!=null){
                    totalSub2 = totalSub2.add(detailListSub.get(i).getCumulativePayment());
                }
            }
        }

        BigDecimal totalPur1 = new BigDecimal("0.00");
        BigDecimal totalPur2 = new BigDecimal("0.00");
        QueryWrapper<PurchasesummaryEntity> queryWrapperPur = new QueryWrapper<>();
        queryWrapperPur.eq("project_id", projectId);
        queryWrapperPur.le("create_time", time);
        queryWrapperPur.eq("dr",0);
        List<PurchasesummaryEntity> listPur = iPurchasesummaryService.list(queryWrapperPur);
        for(int j = 0; j < listPur.size(); j++){
            if(listPur.get(j).getTaxSettlementAmount()!=null){
                totalPur1 = totalPur1.add(listPur.get(j).getTaxSettlementAmount());
            }
            if(listPur.get(j).getCumulativePayment()!=null){
                totalPur2 = totalPur2.add(listPur.get(j).getCumulativePayment());
            }
        }

        BigDecimal totalRev1 = new BigDecimal("0.00");
        BigDecimal totalRev2 = new BigDecimal("0.00");
        QueryWrapper<RevolvingleasesummaryEntity> queryWrapperRev = new QueryWrapper<>();
        queryWrapperRev.eq("project_id", projectId);
        queryWrapperRev.le("create_time", time);
        queryWrapperRev.eq("dr",0);
        List<RevolvingleasesummaryEntity> listRev = iRevolvingleasesummaryService.list(queryWrapperRev);
        for(int j = 0; j < listRev.size(); j++){
            if(listRev.get(j).getTaxSettleAccount()!=null){
                totalRev1 = totalRev1.add(listRev.get(j).getTaxSettleAccount());
            }
            if(listRev.get(j).getCumulativePayment()!=null){
                totalRev2 = totalRev2.add(listRev.get(j).getCumulativePayment());
            }
        }

        BigDecimal totalMec1 = new BigDecimal("0.00");
        BigDecimal totalMec2 = new BigDecimal("0.00");
        QueryWrapper<MechanicalleasedetotalEntity> queryWrapperMec = new QueryWrapper<>();
        queryWrapperMec.eq("project_id", projectId);
        queryWrapperMec.le("create_time", time);
        queryWrapperMec.eq("dr",0);
        List<MechanicalleasedetotalEntity> listMec = iMechanicalleasedetotalService.list(queryWrapperMec);
        for(int j = 0; j < listMec.size(); j++){
            if(listMec.get(j).getInTaxMonthSettlement()!=null){
                totalMec1 = totalMec1.add(listMec.get(j).getInTaxMonthSettlement());
            }
            if(listMec.get(j).getInTaxCumulativePaid()!=null){
                totalMec2 = totalMec2.add(listMec.get(j).getInTaxCumulativePaid());
            }
        }
        BigDecimal total1 = totalSub1.add(totalPur1).add(totalRev1).add(totalMec1);
        BigDecimal total2 = totalSub2.add(totalPur2).add(totalRev2).add(totalMec2);

        return CommonResponse.success("查询数据成功", total1.subtract(total2));
    }
}