package com.ejianc.business.middlemeasurement.controller;

import java.io.Serializable;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.*;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedataService;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedetailService;
import com.ejianc.business.middlemeasurement.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.middlemeasurement.service.IMechanicalleaseService;

/**
 * 月度机械设备租赁单
 *
 * @author generator
 */
@Controller
@RequestMapping("mechanicallease")
public class MechanicalleaseController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "middlemeasurement-mechanicallease";//此处需要根据实际修改

    @Autowired
    private IMechanicalleaseService service;

    @Autowired
    private IMechanicalleasedetailService detailService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMechanicalleasedataService dataService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> saveOrUpdate(@RequestBody MechanicalleaseVO saveorUpdateVO) {
        MechanicalleaseEntity entity = BeanMapper.map(saveorUpdateVO, MechanicalleaseEntity.class);
        entity.setSaveTime(new Date());
        if (entity.getId() == null || entity.getId() == 0) {
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
                Date currentDate = new Date(System.currentTimeMillis());
                if (saveorUpdateVO.getCreateTime() != null) {
                    currentDate = saveorUpdateVO.getCreateTime();
                }
            } else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setIsReference(0);
        }
        QueryWrapper<MechanicalleaseEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("contract_id", entity.getContractId());
        queryWrapper.notIn("bill_state", 1, 3);//1直审 3审批通过
        queryWrapper.eq("dr", "0");
        if (entity.getId() != null) {
            queryWrapper.ne("id", entity.getId());
        }
        List<MechanicalleaseEntity> pro = service.list(queryWrapper);
        if (pro != null && pro.size() > 0) {
            throw new BusinessException("同一合同只能存在一份自由态或审批中的\"月度机械设备租赁单\"!");
        }
        //3.累计（包含本期）
        Date currentDate = new Date(System.currentTimeMillis());
        if(saveorUpdateVO.getCreateTime() != null){
            currentDate = saveorUpdateVO.getCreateTime();
        }
        //获取往期
        MechanicalleaseVO pastVo = getPastTotal(saveorUpdateVO.getContractId(), currentDate, true);
        //本期 + 往期（主表）
        BigDecimal occurrenceTotal = new BigDecimal(0);
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);
        if(saveorUpdateVO.getExTaxCumulative()!=null){
            if (saveorUpdateVO.getExTaxThisMonthTotal()!=null) {
                occurrenceTotal = saveorUpdateVO.getExTaxThisMonthTotal().add(pastVo.getExTaxCumulative());
            }
        }
        if(saveorUpdateVO.getInTaxCumulative()!=null){
            if (saveorUpdateVO.getInTaxThisMonthTotal()!=null) {
                taxOccurrenceTotal = saveorUpdateVO.getInTaxThisMonthTotal().add(pastVo.getInTaxCumulative());
            }
        }

        entity.setExTaxCumulative(occurrenceTotal);
        entity.setInTaxCumulative(taxOccurrenceTotal);

        //本期 + 往期（子表）
        List<MechanicalleasedetailVO> voMechanicalleasedetailEntities = saveorUpdateVO.getMechanicalleasedetailEntities();
        List<MechanicalleasedetailVO> mechanicalleasedetailVOList =  pastVo.getMechanicalleasedetailEntities();
        if(voMechanicalleasedetailEntities != null && mechanicalleasedetailVOList != null){
            //本期
            for (int i = 0; i < voMechanicalleasedetailEntities.size(); i++) {
                MechanicalleasedetailVO mechanicalleasedetail = voMechanicalleasedetailEntities.get(i);
                //物料编码
                String equipmentCode = mechanicalleasedetail.getEquipmentCode();
                //月度结算费用((除税)(元)
                BigDecimal saveMonthlyExpenses = mechanicalleasedetail.getExTaxSettlementMonth();
                //月度结算费用（含税）（元）
                BigDecimal saveTaxMonthlyExpenses = mechanicalleasedetail.getInTaxSettlementMonth();

                //往期
                for (int j = 0; j < mechanicalleasedetailVOList.size(); j++) {
                   MechanicalleasedetailVO mechanicalleasedetailVO = mechanicalleasedetailVOList.get(j);
                    String equipmentCodes = mechanicalleasedetailVO.getEquipmentCode();
                    if(equipmentCodes.equals(equipmentCode)){
                        if( mechanicalleasedetailVO.getExTaxSettlementMonth()!=null){
                            //月度结算费用((除税)(元)
                            BigDecimal monthlyExpenses = mechanicalleasedetailVO.getExTaxSettlementMonth();
                            if (saveMonthlyExpenses!=null) {
                                saveMonthlyExpenses = saveMonthlyExpenses.add(monthlyExpenses);
                            }
                        }

                        if(mechanicalleasedetailVO.getInTaxSettlementMonth() != null){
                            //月度结算费用(含税)(元)
                            BigDecimal taxMonthlyExpenses = mechanicalleasedetailVO.getInTaxSettlementMonth();
                            if (saveTaxMonthlyExpenses!=null) {
                                saveTaxMonthlyExpenses = saveTaxMonthlyExpenses.add(taxMonthlyExpenses);
                            }
                        }
                    }
                }

                mechanicalleasedetail.setExTaxCumulative(saveMonthlyExpenses);
                mechanicalleasedetail.setInTaxCumulative(saveTaxMonthlyExpenses);
            }

            entity.setMechanicalleasedetailEntities(BeanMapper.mapList(voMechanicalleasedetailEntities, MechanicalleasedetailEntity.class));
        }


        entity.setSaveTime(currentDate);
        service.saveOrUpdate(entity, false);
        MechanicalleaseVO vo = BeanMapper.map(entity, MechanicalleaseVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> queryDetail(Long id) {
        MechanicalleaseEntity entity = service.selectById(id);
        MechanicalleaseVO vo = BeanMapper.map(entity, MechanicalleaseVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MechanicalleaseVO> vos) {
        service.removeByIds(vos.stream().map(MechanicalleaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");


        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        IPage<MechanicalleaseEntity> page = service.queryPage(param, false);
        IPage<MechanicalleaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MechanicalleaseVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("supplierName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        List<MechanicalleaseEntity> list = service.queryList(param);
        //时间转换
        List<MechanicalleaseVO> mechanicalleaseVOList = BeanMapper.mapList(list, MechanicalleaseVO.class);
        for (int i = 0; i < mechanicalleaseVOList.size(); i++) {
            MechanicalleaseVO mechanicalleaseVO = mechanicalleaseVOList.get(i);
            mechanicalleaseVO.setSort(String.valueOf(i + 1));
            if (mechanicalleaseVO.getSettlementTime() != null) {
                mechanicalleaseVO.setSettlementTime(DateUtil.date(mechanicalleaseVO.getSettlementTime()));
            }
            if (mechanicalleaseVO.getBillingStartTime() != null) {
                mechanicalleaseVO.setBillingStartTime(DateUtil.date(mechanicalleaseVO.getBillingStartTime()));
            }
            if (mechanicalleaseVO.getBillingEndTime() != null) {
                mechanicalleaseVO.setBillingEndTime(DateUtil.date(mechanicalleaseVO.getBillingEndTime()));
            }
            String billStateStr = mechanicalleaseVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }
                mechanicalleaseVO.setBillStateStr(billStateStr);
            }
        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", mechanicalleaseVOList);
        ExcelExport.getInstance().export("mechanicalleaseList-export.xlsx", beans, response);

    }

    /**
     * 参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refMechanicalleaseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MechanicalleaseVO>> refMechanicalleaseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("project_name");
        fuzzyFields.add("supplier_name");
        fuzzyFields.add("contract_name");
        fuzzyFields.add("bill_code");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
        }

        //未被引用
        param.getParams().put("isReference", new Parameter(QueryParam.EQ, 0));

        //审批通过
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));

        IPage<MechanicalleaseEntity> page = service.queryPage(param,false);
        IPage<MechanicalleaseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());

        List<MechanicalleaseVO> mechanicalleaseVOList = BeanMapper.mapList(page.getRecords(), MechanicalleaseVO.class);
        for (int i = 0; i < mechanicalleaseVOList.size(); i++) {
            MechanicalleaseVO mechanicalleaseVO = mechanicalleaseVOList.get(i);
            mechanicalleaseVO.setSort(String.valueOf(i + 1));

            QueryWrapper<MechanicalleasedetailEntity> detailWrapper = new QueryWrapper<>();
            detailWrapper.eq("mid", mechanicalleaseVO.getId());
            List<MechanicalleasedetailEntity> entityList = detailService.list(detailWrapper);
            if (entityList != null && entityList.size() > 0) {

                List<MechanicalleasedetailVO> detailList = BeanMapper.mapList(entityList, MechanicalleasedetailVO.class);
                mechanicalleaseVO.setMechanicalleasedetailEntities(detailList);
            }
        }
        pageData.setRecords(mechanicalleaseVOList);
        return CommonResponse.success("查询参照数据成功！", pageData);
    }

    /**
     * 明细参照
     *
     * @param pageNumber
     * @param pageSize
     * @param condition
     * @param searchObject
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/refMechanicalleasedetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MechanicalleasedataVO>> refMechanicalleasedetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                           String condition,
                                                                           String searchObject,
                                                                           String searchText) {

        List<MechanicalleasedataVO> mechanicalleasedataVOList = new ArrayList<>();
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            String projectIdStr = _con.getString("projectId");
            String settleTimeStr = _con.getString("settleTime");

            if(projectIdStr!=null && settleTimeStr!=null ){
                Long projectId = Long.parseLong(projectIdStr);

                DateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'",Locale.CHINA);
                format.setTimeZone(TimeZone.getTimeZone("UTC"));
                try {
                    Date date = format.parse(settleTimeStr);
                    SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
                    String strDate1 = sdf1.format(date);

                    mechanicalleasedataVOList = dataService.listData(projectId, strDate1);
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        }

        return CommonResponse.success("查询参照数据成功！", mechanicalleasedataVOList);

    }

    /**
     * @param contractId
     * @Description 查询详情
     */
    @RequestMapping(value = "/pastData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MechanicalleaseVO> pastData(Long id, Long contractId, Long projectId) {
        Date currentDate = new Date(System.currentTimeMillis());
        if (id != null && "".equals(id)) {//更新
            MechanicalleaseEntity mechanicalleaseEntity = service.selectById(id);
            currentDate = mechanicalleaseEntity.getCreateTime();
        }
        return CommonResponse.success("查询往期审批通过的累计数据成功！", getPastTotalData(contractId, currentDate, projectId));
    }

    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId 合同id
     * @param currentDate 本期日期
     * @param isSave true保存 false查询
     * @return
     */
    private MechanicalleaseVO getPastTotal(Long contractId, Date currentDate, boolean isSave) {
        //创建条件构造器
        QueryWrapper<MechanicalleaseEntity> queryWrapperTotal = new QueryWrapper<>();
        queryWrapperTotal.eq("contract_id", contractId);
        queryWrapperTotal.in("bill_state", 1, 3);//1直审 3审批通过
        queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
        List<MechanicalleaseEntity> proTotal = service.list(queryWrapperTotal);
        List<MechanicalleasedetailEntity> mechanicalleasedetailEntityList = new ArrayList<>();

        //累计发生(除税)
        BigDecimal occurrenceTotal = new BigDecimal(0);
        //累计发生(含税)
        BigDecimal taxOccurrenceTotal = new BigDecimal(0);

        if(proTotal != null && proTotal.size() > 0){
            for (int i = 0; i < proTotal.size(); i++) {
                MechanicalleaseEntity mechanicalleaseEntity = proTotal.get(i);
                occurrenceTotal = occurrenceTotal.add(mechanicalleaseEntity.getExTaxCumulative());
                taxOccurrenceTotal = taxOccurrenceTotal.add(mechanicalleaseEntity.getInTaxCumulative());

                if(isSave){
                    QueryWrapper<MechanicalleasedetailEntity> detailWrapper = new QueryWrapper<>();
                    detailWrapper.eq("mid", mechanicalleaseEntity.getId());
                    List<MechanicalleasedetailEntity> detailList = detailService.list(detailWrapper);
                    mechanicalleasedetailEntityList.addAll(detailList);
                }
            }
        }

        MechanicalleaseVO vo = new MechanicalleaseVO();
        vo.setExTaxCumulative(occurrenceTotal);
        vo.setInTaxCumulative(taxOccurrenceTotal);

        vo.setContractId(contractId);
        //往期所有子表 entity和vo转换
        vo.setMechanicalleasedetailEntities(BeanMapper.mapList(mechanicalleasedetailEntityList, MechanicalleasedetailVO.class));

        return vo;
    }


    /**
     * 获取往期审批通过的合计数据
     *
     * @param contractId  合同id
     * @param currentDate 本期日期
     */
    private MechanicalleaseVO getPastTotalData(Long contractId, Date currentDate, Long projectId) {
        //创建条件构造器-子表数据筛选
        QueryWrapper<MechanicalleaseEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("contract_id", contractId);
        wrapper.eq("project_id", projectId);
        wrapper.eq("dr", 0);
        wrapper.in("bill_state", 1, 3);
        BigDecimal exTaxCumulative = new BigDecimal(0);
        BigDecimal inTaxCumulative = new BigDecimal(0);

        List<MechanicalleaseEntity> list = service.list(wrapper);

         /*   QueryWrapper<MechanicalleasedetailEntity> queryWrapperTotal = new QueryWrapper<>();
            queryWrapperTotal.eq("mid", entity.getId());
            queryWrapperTotal.eq("dr",0);
            queryWrapperTotal.lt("create_time", currentDate);//往期 lt（小于）
            List<MechanicalleasedetailEntity> list = detailService.list(queryWrapperTotal);*/

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                MechanicalleaseEntity entitys = list.get(i);
                exTaxCumulative = exTaxCumulative.add(entitys.getExTaxThisMonthTotal() == null ? BigDecimal.valueOf(0) : entitys.getExTaxThisMonthTotal());
                inTaxCumulative = inTaxCumulative.add(entitys.getInTaxThisMonthTotal() == null ? BigDecimal.valueOf(0) : entitys.getInTaxThisMonthTotal());
            }

        }

        MechanicalleaseVO vo = new MechanicalleaseVO();
        vo.setExTaxCumulative(exTaxCumulative);
        vo.setInTaxCumulative(inTaxCumulative);
        return vo;
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

}
