/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.bean.RevolvingleasesummaryEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;
import com.ejianc.business.middlemeasurement.service.IRevolvingleasesummaryService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.RevolvingleasesummaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"revolvingleasesummary"})
public class RevolvingleasesummaryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "middlemeasurement-revolvingleasesummary";
    @Autowired
    private IRevolvingleasesummaryService service;
    @Autowired
    private IRevolvingleaseService revolvingleaseService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RevolvingleasesummaryVO> saveOrUpdate(@RequestBody RevolvingleasesummaryVO saveorUpdateVO) {
        List<String> referenceIdList;
        RevolvingleasesummaryEntity entity = (RevolvingleasesummaryEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), RevolvingleasesummaryEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"project_id", (Object)entity.getProjectId());
            queryWrapper.in((Object)"bill_state", new Object[]{0, 2, 4, 5});
            List pro = this.service.list((Wrapper)queryWrapper);
            if (pro != null && pro.size() > 0) {
                throw new BusinessException("\u540c\u4e00\u9879\u76ee\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u3001\u5ba1\u6279\u4e2d\u3001\u5ba1\u6279\u9a73\u56de\u7684\"\u6708\u5ea6\u5468\u8f6c\u79df\u8d41\u7ed3\u7b97\u6c47\u603b\u5355\"!");
            }
        }
        entity = this.checkBillCodeUniq(entity);
        this.service.saveOrUpdate((Object)entity, false);
        if (entity.getId() != null) {
            QueryWrapper queryWrapperOld = new QueryWrapper();
            queryWrapperOld.in((Object)"reference_code", new Object[]{saveorUpdateVO.getBillCode()});
            queryWrapperOld.eq((Object)"dr", (Object)0);
            List oldList = this.revolvingleaseService.list((Wrapper)queryWrapperOld);
            if (oldList != null && oldList.size() > 0) {
                for (RevolvingleaseEntity item : oldList) {
                    item.setIsReference(0);
                    item.setReferenceCode(null);
                }
                this.revolvingleaseService.saveOrUpdateBatch(oldList);
            }
        }
        if ((referenceIdList = saveorUpdateVO.getReferenceIdList()) != null && referenceIdList.size() > 0) {
            QueryWrapper queryWrapperByIdsNew = new QueryWrapper();
            queryWrapperByIdsNew.in((Object)"id", referenceIdList);
            queryWrapperByIdsNew.eq((Object)"dr", (Object)0);
            List newList = this.revolvingleaseService.list((Wrapper)queryWrapperByIdsNew);
            if (newList != null && newList.size() > 0) {
                for (RevolvingleaseEntity item : newList) {
                    item.setIsReference(1);
                    item.setReferenceCode(entity.getBillCode());
                }
                this.revolvingleaseService.saveOrUpdateBatch(newList);
            }
        }
        RevolvingleasesummaryVO vo = (RevolvingleasesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), RevolvingleasesummaryVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RevolvingleasesummaryEntity checkBillCodeUniq(RevolvingleasesummaryEntity entity) {
        if (entity.getBillCode() == null || StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            entity.setBillCode((String)billCode.getData());
            return entity;
        } else {
            List proBillCode;
            QueryWrapper queryWrapperBillCode = new QueryWrapper();
            queryWrapperBillCode.eq((Object)"bill_code", (Object)entity.getBillCode());
            queryWrapperBillCode.eq((Object)"dr", (Object)"0");
            Long id = entity.getId();
            if (id != null) {
                queryWrapperBillCode.ne((Object)"id", (Object)id);
            }
            if ((proBillCode = this.service.list((Wrapper)queryWrapperBillCode)) == null || proBillCode.size() <= 0) return entity;
            throw new BusinessException("\u5355\u636e\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u5f55\u5165!");
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RevolvingleasesummaryVO> queryDetail(Long id) {
        RevolvingleasesummaryEntity entity = (RevolvingleasesummaryEntity)((Object)this.service.selectById(id));
        RevolvingleasesummaryVO vo = (RevolvingleasesummaryVO)((Object)BeanMapper.map((Object)((Object)entity), RevolvingleasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RevolvingleasesummaryVO> vos) {
        List idList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.in((Object)"id", idList);
        List revolvingleasesummaryEntityList = this.service.list((Wrapper)queryWrapper);
        ArrayList<String> codeList = new ArrayList<String>();
        for (RevolvingleasesummaryEntity entity : revolvingleasesummaryEntityList) {
            codeList.add(entity.getBillCode());
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.in((Object)"reference_code", codeList);
        List list = this.revolvingleaseService.list((Wrapper)wrapper);
        for (RevolvingleaseEntity entity : list) {
            entity.setIsReference(0);
            entity.setReferenceCode(null);
        }
        if (list.size() > 0) {
            this.revolvingleaseService.saveOrUpdateBatch(list);
        }
        this.service.removeByIds(idList, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RevolvingleasesummaryVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RevolvingleasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List revolvingleasesummaryVOList = BeanMapper.mapList((Iterable)list, RevolvingleasesummaryVO.class);
        for (int i = 0; i < revolvingleasesummaryVOList.size(); ++i) {
            String billStateStr;
            RevolvingleasesummaryVO revolvingleasesummaryVO = (RevolvingleasesummaryVO)((Object)revolvingleasesummaryVOList.get(i));
            revolvingleasesummaryVO.setSort(String.valueOf(i + 1));
            if (revolvingleasesummaryVO.getStatisticalTime() != null) {
                revolvingleasesummaryVO.setStatisticalTimeShow(DateUtils.dateSimple3(revolvingleasesummaryVO.getStatisticalTime()));
            }
            if ((billStateStr = revolvingleasesummaryVO.getBillState().toString()) == null) continue;
            if ("0".equals(billStateStr)) {
                billStateStr = "\u81ea\u7531\u6001";
            } else if ("1".equals(billStateStr)) {
                billStateStr = "\u5df2\u63d0\u4ea4";
            } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u4e2d";
            } else if ("3".equals(billStateStr)) {
                billStateStr = "\u5ba1\u6279\u901a\u8fc7";
            } else if ("4".equals(billStateStr)) {
                billStateStr = "\u9a73\u56de";
            }
            revolvingleasesummaryVO.setBillStateStr(billStateStr);
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", revolvingleasesummaryVOList);
        ExcelExport.getInstance().export("RevolvingleasesummaryMain-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRevolvingleasesummaryData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RevolvingleasesummaryVO>> refRevolvingleasesummaryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RevolvingleasesummaryVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryProject"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        List entityList;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"project_id", (Object)projectId);
        queryWrapper.notIn((Object)"bill_state", new Object[]{1, 3});
        if (id != null && id != 0L) {
            queryWrapper.ne((Object)"id", (Object)id);
        }
        if ((entityList = this.service.list((Wrapper)queryWrapper)) != null && entityList.size() > 0) {
            throw new BusinessException("\u540c\u4e00\u9879\u76ee\u53ea\u80fd\u5b58\u5728\u4e00\u4efd\u81ea\u7531\u6001\u6216\u5ba1\u6279\u4e2d\u7684\u6708\u5ea6\u5468\u8f6c\u79df\u8d41\u7ed3\u7b97\u6c47\u603b\u5355");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)"0");
    }

    @RequestMapping(value={"/getSelectId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<Long>> getSelectId(Long id) {
        RevolvingleasesummaryEntity revolvingleasesummary = (RevolvingleasesummaryEntity)((Object)this.service.selectById(id));
        String billCode = revolvingleasesummary.getBillCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"reference_code", (Object)billCode);
        List list = this.revolvingleaseService.list((Wrapper)wrapper);
        ArrayList<Long> idList = new ArrayList<Long>();
        for (RevolvingleaseEntity entity : list) {
            idList.add(entity.getId());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", idList);
    }
}

