/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.middlemeasurement.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.service.IPurchasesettlementdetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementVO;
import com.ejianc.business.middlemeasurement.vo.PurchasesettlementdetailVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"purchasesettlementExport"})
public class ExcelPurchasesettlementController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchasesettlementdetailService purchasesettlementdetailService;
    @Autowired
    private IShareMaterialApi shareMaterialApi;

    @RequestMapping(value={"/downloadPurchasesettlement"})
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"purchasesettlementdetail-import.xlsx", (String)"\u6708\u5ea6\u7269\u8d44\u91c7\u8d2d\u7ed3\u7b97\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportPurchasesettlement"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<PurchasesettlementdetailVO> successList = new ArrayList<PurchasesettlementdetailVO>();
        ArrayList<PurchasesettlementdetailVO> errorList = new ArrayList<PurchasesettlementdetailVO>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        HashMap<String, String> map = new HashMap<String, String>();
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                int errorCount = 0;
                List datas = (List)result.get(i);
                PurchasesettlementdetailVO purchasesettlementdetailVO = new PurchasesettlementdetailVO();
                purchasesettlementdetailVO.setId(IdWorker.getId());
                purchasesettlementdetailVO.setSource(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(0))) ? (String)datas.get(0) : null);
                if (datas.get(1) == null && StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u6750\u6599\u7f16\u7801'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                purchasesettlementdetailVO.setBillCode(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(1))) ? (String)datas.get(1) : null);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2))) && datas.get(2) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u6750\u6599\u540d\u79f0'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                purchasesettlementdetailVO.setBillName(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(2))) ? (String)datas.get(2) : null);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(3))) && datas.get(3) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u54c1\u724c/\u89c4\u683c\u578b\u53f7'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                purchasesettlementdetailVO.setBrandModel(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3))) ? (String)datas.get(3) : null);
                CommonResponse back0 = this.shareMaterialApi.queryMaterialByCode((String)datas.get(1));
                if (back0.getCode() == 1 || back0.getData() == null) {
                    purchasesettlementdetailVO.setErrorMsg("\u672a\u67e5\u8be2\u5230\u8be5\u6750\u6599\u7f16\u7801\u4e0b\u7684\u7269\u8d44\u8be6\u60c5");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((MaterialVO)back0.getData()).getName()) && !((MaterialVO)back0.getData()).getName().equals(datas.get(2))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u6750\u6599\u540d\u79f0'\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5\uff01");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((MaterialVO)back0.getData()).getSpec()) && !((MaterialVO)back0.getData()).getSpec().equals(datas.get(3))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u54c1\u724c/\u89c4\u683c\u578b\u53f7'\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5\uff01");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)((MaterialVO)back0.getData()).getUnitName())) {
                    if (!((MaterialVO)back0.getData()).getUnitName().equals(datas.get(4))) {
                        purchasesettlementdetailVO.setErrorMsg("'\u5355\u4f4d'\u672a\u5728\u5e93\u4e2d,\u8bf7\u68c0\u67e5\uff01");
                        ++errorCount;
                        errorList.add(purchasesettlementdetailVO);
                        continue;
                    }
                } else {
                    purchasesettlementdetailVO.setUnit(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4))) ? (String)datas.get(4) : null);
                }
                StringBuffer materConcat = new StringBuffer();
                if (datas.get(3) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(3)))) {
                    materConcat.append(((MaterialVO)back0.getData()).getCode()).append(((MaterialVO)back0.getData()).getName()).append(((MaterialVO)back0.getData()).getSpec());
                }
                if (datas.get(4) != null && StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(4)))) {
                    materConcat.append(((MaterialVO)back0.getData()).getUnitName());
                }
                map.put(materConcat.toString(), materConcat.toString());
                purchasesettlementdetailVO.setBillCode(((MaterialVO)back0.getData()).getCode());
                purchasesettlementdetailVO.setBillName(((MaterialVO)back0.getData()).getName());
                purchasesettlementdetailVO.setBrandModel(((MaterialVO)back0.getData()).getSpec());
                purchasesettlementdetailVO.setUnit(((MaterialVO)back0.getData()).getUnitName());
                BigDecimal supplyNumber = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(5))) || datas.get(5) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u4f9b\u8d27\u6570\u91cf'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(5)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u4f9b\u8d27\u6570\u91cf'\u683c\u5f0f\u9519\u8bef");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    supplyNumber = supplyNumber.add(new BigDecimal((String)datas.get(5)));
                    purchasesettlementdetailVO.setSupplyQuantity(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(5))) ? new BigDecimal((String)datas.get(5)) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(6))) || datas.get(6) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u4f9b\u8d27\u65f6\u95f4'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else if (!DateUtils.grepDate((String)datas.get(6))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u4f9b\u8d27\u65f6\u95f4'\u683c\u5f0f\u9519\u8bef");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    purchasesettlementdetailVO.setSupplyTime(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(6))) ? DateUtils.Dates((String)datas.get(6)) : null);
                }
                if (!StringUtils.isBlank((CharSequence)((CharSequence)datas.get(7))) && datas.get(7) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(7)))) {
                        purchasesettlementdetailVO.setErrorMsg("'\u7f51\u4ef7'\u683c\u5f0f\u9519\u8bef");
                        ++errorCount;
                        errorList.add(purchasesettlementdetailVO);
                    } else {
                        purchasesettlementdetailVO.setNetPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(7))) ? new BigDecimal((String)datas.get(7)) : null);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)((CharSequence)datas.get(8))) && datas.get(8) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(8)))) {
                        purchasesettlementdetailVO.setErrorMsg("'\u6d6e\u52a8\u4ef7'\u683c\u5f0f\u9519\u8bef");
                        ++errorCount;
                        errorList.add(purchasesettlementdetailVO);
                    } else {
                        purchasesettlementdetailVO.setFloatPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(8))) ? new BigDecimal((String)datas.get(8)) : null);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)((CharSequence)datas.get(9))) && datas.get(9) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(9)))) {
                        purchasesettlementdetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7\u9664\u7a0e(\u5143)'\u683c\u5f0f\u9519\u8bef");
                        ++errorCount;
                        errorList.add(purchasesettlementdetailVO);
                    } else {
                        purchasesettlementdetailVO.setUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(9))) ? new BigDecimal((String)datas.get(9)) : null);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)((CharSequence)datas.get(10))) && datas.get(10) != null) {
                    if (!NumberUtil.isNumber((String)((String)datas.get(10)))) {
                        purchasesettlementdetailVO.setErrorMsg("'\u5408\u540c\u5355\u4ef7\u542b\u7a0e(\u5143)'\u683c\u5f0f\u9519\u8bef");
                        ++errorCount;
                        errorList.add(purchasesettlementdetailVO);
                    } else {
                        purchasesettlementdetailVO.setTaxUnitPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(10))) ? new BigDecimal((String)datas.get(10)) : null);
                    }
                }
                BigDecimal exPrice = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(11))) || datas.get(11) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(11)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    exPrice = exPrice.add(new BigDecimal((String)datas.get(11)));
                    purchasesettlementdetailVO.setSettlementPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(11))) ? new BigDecimal((String)datas.get(11)) : null);
                }
                BigDecimal inPrice = new BigDecimal(0);
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(12))) || datas.get(12) == null) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u4e0d\u80fd\u4e3a\u7a7a");
                    errorList.add(purchasesettlementdetailVO);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(12)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u5355\u4ef7(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef");
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    inPrice = inPrice.add(new BigDecimal((String)datas.get(12)));
                    purchasesettlementdetailVO.setTaxSettlementPrice(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(12))) ? new BigDecimal((String)datas.get(12)) : null);
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(13))) || datas.get(13) == null) {
                    BigDecimal settlementAmout = supplyNumber.multiply(exPrice);
                    purchasesettlementdetailVO.setSettlementAmount(settlementAmout);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(13)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u91d1\u989d(\u9664\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    purchasesettlementdetailVO.setSettlementAmount(new BigDecimal((String)datas.get(13)));
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(14))) || datas.get(14) == null) {
                    BigDecimal taxSettlementAmout = supplyNumber.multiply(inPrice);
                    purchasesettlementdetailVO.setTaxSettlementAmount(taxSettlementAmout);
                } else if (!NumberUtil.isNumber((String)((String)datas.get(14)))) {
                    purchasesettlementdetailVO.setErrorMsg("'\u7ed3\u7b97\u91d1\u989d(\u542b\u7a0e)(\u5143)'\u683c\u5f0f\u9519\u8bef");
                    ++errorCount;
                    errorList.add(purchasesettlementdetailVO);
                } else {
                    purchasesettlementdetailVO.setTaxSettlementAmount(new BigDecimal((String)datas.get(14)));
                }
                purchasesettlementdetailVO.setRemarks(StringUtils.isNotBlank((CharSequence)((CharSequence)datas.get(15))) ? (String)datas.get(15) : null);
                if (errorCount != 0) continue;
                successList.add(purchasesettlementdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportPurchasesettlementFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody PurchasesettlementVO purchasesettlementVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)purchasesettlementVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.purchasesettlementdetailService.list((Wrapper)queryWrapper);
        List purchasesettlementdetailVOList = BeanMapper.mapList((Iterable)list, PurchasesettlementdetailVO.class);
        if (purchasesettlementdetailVOList != null && purchasesettlementdetailVOList.size() > 0) {
            for (int i = 0; i < purchasesettlementdetailVOList.size(); ++i) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = (PurchasesettlementdetailVO)((Object)purchasesettlementdetailVOList.get(i));
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if (purchasesettlementdetailVO.getSupplyTime() == null) continue;
                purchasesettlementdetailVO.setSupplyTimeShow(DateUtils.dateSimple(purchasesettlementdetailVO.getSupplyTime()));
            }
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", purchasesettlementdetailVOList);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportPurchasesettlementFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<PurchasesettlementdetailVO> list, HttpServletResponse response) {
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                PurchasesettlementdetailVO purchasesettlementdetailVO = list.get(i);
                purchasesettlementdetailVO.setSort(String.valueOf(i + 1));
                if (purchasesettlementdetailVO.getSupplyTime() == null) continue;
                purchasesettlementdetailVO.setSupplyTimeShow(DateUtils.dateSimple(purchasesettlementdetailVO.getSupplyTime()));
            }
        }
        HashMap<String, List<PurchasesettlementdetailVO>> beans = new HashMap<String, List<PurchasesettlementdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchasesettlementdetail-export.xlsx", beans, response);
    }
}

