package com.ejianc.business.change.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.change.bean.ChangeVisaclaimaccountEntity;
import com.ejianc.business.change.bean.ChangeVisaclaimaccountdetailEntity;
import com.ejianc.business.change.mapper.ChangeVisaclaimaccountMapper;
import com.ejianc.business.change.service.IChangeVisaclaimaccountService;
import com.ejianc.business.change.vo.ChangeVisaclaimaccountVO;
import com.ejianc.business.middlemeasurement.bean.VisaclaimaccountEntity;
import com.ejianc.business.middlemeasurement.service.IVisaclaimaccountService;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 总包签证索赔台账变更
 * 
 * @author generator
 * 
 */
@Service("changeVisaclaimaccountService")
public class ChangeVisaclaimaccountServiceImpl extends BaseServiceImpl<ChangeVisaclaimaccountMapper, ChangeVisaclaimaccountEntity> implements IChangeVisaclaimaccountService{



    @Autowired
    private IVisaclaimaccountService visaclaimaccountService;

    @Override
    public CommonResponse<ChangeVisaclaimaccountVO> saveChange(ChangeVisaclaimaccountVO saveOrUpdateVO) {
        //检验该单据是否存在
        boolean exitBill = false;
        if(saveOrUpdateVO.getId()!=null){
            ChangeVisaclaimaccountEntity e = this.getById(saveOrUpdateVO);
            if(e!=null){
                exitBill = true;
            }
        }
        ChangeVisaclaimaccountEntity entity = BeanMapper.map(saveOrUpdateVO, ChangeVisaclaimaccountEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<ChangeVisaclaimaccountEntity> queryWrapper = new QueryWrapper<ChangeVisaclaimaccountEntity>();
        queryWrapper.eq("original_id", saveOrUpdateVO.getOriginalId());
        queryWrapper.eq("dr", 0);
        queryWrapper.notIn("bill_state", 1, 3);
        if(saveOrUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveOrUpdateVO.getId());
        }
        List<ChangeVisaclaimaccountEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        List<ChangeVisaclaimaccountdetailEntity> children = entity.getChangeVisaclaimaccountdetailEntities();
        for (int i = 0; i < children.size(); i++) {
            ChangeVisaclaimaccountdetailEntity visaclaimaccountdetail = children.get(i);
            visaclaimaccountdetail.setSort(String.valueOf(i + 1));
        }

        //处理子表数据
        this.saveOrUpdate(entity, false);

        ChangeVisaclaimaccountVO vo = BeanMapper.map(entity, ChangeVisaclaimaccountVO.class);
        vo.setVisaclaimaccountdetailEntities(saveOrUpdateVO.getVisaclaimaccountdetailEntities());
        vo.setRecordvisaclaimaccountList(saveOrUpdateVO.getRecordvisaclaimaccountList());
        if(!exitBill){
            //查询当前单据信息，将状态改为变更中
            VisaclaimaccountEntity visaclaimaccountEntity = visaclaimaccountService.selectById(vo.getOriginalId());
            visaclaimaccountEntity.setChangeState("2");//状态改为变更中
            visaclaimaccountEntity.setChangeId(vo.getId());
            visaclaimaccountService.saveOrUpdate(visaclaimaccountEntity, false);
        }
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    
}
