package com.ejianc.business.middlemeasurement.excel;


import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.PurchasesummarydetatilEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractvisadetailEntity;
import com.ejianc.business.middlemeasurement.service.IPurchasesummarydetatilService;
import com.ejianc.business.middlemeasurement.service.ISubcontractvisadetailService;
import com.ejianc.business.middlemeasurement.utils.DateUtils;
import com.ejianc.business.middlemeasurement.vo.*;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 月度物资采购结算汇总导入导出
 */
@Controller
@RequestMapping("purchasesummaryExport")
public class ExcelPurchasesummaryController {

    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IPurchasesummarydetatilService purchasesummarydetatilService;


    /**
     * 导入模板下载
     *
     * @param request
     * @param response
     */
    @RequestMapping(value = "/downloadPurchasesummary")
    @ResponseBody
    public void downloadConsdrawbudget(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize(response);
        ImportTemplate.templetdownload(request, "purchasesummarydetail-import.xlsx", "月度物资采购结算汇总模板");
    }

    /**
     * excel导入
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelImportPurchasesummary", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> excelImportConsdrawbudget(HttpServletRequest request, HttpServletResponse response,String purchaseSummaryDetailVo) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        List<PurchasesummarydetatilVO> successList = new ArrayList<>();
        List<PurchasesummarydetatilVO> errorList = new ArrayList<>();
        DateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            HashMap<String, String> frontMap = new HashMap<>();
            List<List<String>> result = ExcelReader.readExcel(mf);
            if (result != null && result.size() > 0) {
                for (int i = 1; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    PurchasesummarydetatilVO purchasesummarydetatilVO = new PurchasesummarydetatilVO();
                    List<PurchasesummarydetatilVO> purchasesummarydetatilVOList = JSON.parseArray(purchaseSummaryDetailVo, PurchasesummarydetatilVO.class);

                    for (PurchasesummarydetatilVO vo : purchasesummarydetatilVOList) {
                        StringBuffer materBuffer = new StringBuffer();
                        if (vo.getContractName() != null && StringUtils.isNotBlank(vo.getContractName())) {
                            materBuffer.append(vo.getContractName());
                        }
                        if (vo.getCategoryCode() != null && StringUtils.isNotBlank(vo.getCategoryCode())) {
                            materBuffer.append(vo.getCategoryCode());
                        }
                        if (vo.getMaterialCategory() != null && StringUtils.isNotBlank(vo.getMaterialCategory())) {
                            materBuffer.append(vo.getMaterialCategory());
                        }
                        if (vo.getSupplierName() != null && StringUtils.isNotBlank(vo.getSupplierName())) {
                            materBuffer.append(vo.getSupplierName());
                        }
                        if (vo.getPaymentProportion() != null) {
                            materBuffer.append(vo.getPaymentProportion());
                        }
                        frontMap.put(materBuffer.toString(), materBuffer.toString());
                    }

                    purchasesummarydetatilVO.setId(IdWorker.getId());//id

                    purchasesummarydetatilVO.setContractName(StringUtils.isNotBlank(datas.get(0)) ? datas.get(0) : null); // 合同名称
                    purchasesummarydetatilVO.setCategoryCode(StringUtils.isNotBlank(datas.get(1)) ? datas.get(1) : null); // 类别编码
                    purchasesummarydetatilVO.setMaterialCategory(StringUtils.isNotBlank(datas.get(2)) ? datas.get(2) : null); // 物资类别名称
                    purchasesummarydetatilVO.setSupplierName(StringUtils.isNotBlank(datas.get(3)) ? datas.get(3) : null); // 供应商名称
                    purchasesummarydetatilVO.setPaymentProportion(StringUtils.isNotBlank(datas.get(8)) ? new BigDecimal(datas.get(8)) : null); // 合同付款比例

                    String keyValue = frontMap.get(datas.get(0) + datas.get(1) + datas.get(2) + datas.get(3) + datas.get(8));
                    if (keyValue != null && StringUtils.isNotBlank(keyValue)) {

                    } else {
                        purchasesummarydetatilVO.setErrorMsg("'合同名称,类别编码,物资类别名称,供应商名称,合同付款比例'与参照内容不符,请检查!");
                        errorList.add(purchasesummarydetatilVO);
                    }

                    for (PurchasesummarydetatilVO vos : purchasesummarydetatilVOList) {
                        if(vos.getPaymentProportion()==null){
                            if(vos.getContractName().equals(datas.get(0)) && vos.getCategoryCode().equals(datas.get(1)) && vos.getMaterialCategory().equals(datas.get(2)) &&
                                    vos.getSupplierName().equals(datas.get(3))){
                                purchasesummarydetatilVO.setSettlementAmount(vos.getSettlementAmount()); // 本月结算金额(除税)
                                purchasesummarydetatilVO.setTaxSettlementAmount(vos.getTaxSettlementAmount()); // 本月结算金额(含税)
                                purchasesummarydetatilVO.setSettlementTotal(vos.getSettlementTotal()); //累计结算金额(除税)
                                purchasesummarydetatilVO.setTaxSettlementTotal(vos.getTaxSettlementTotal()); // 累计结算金额(含税)
                            }
                        }else{
                            if(vos.getContractName().equals(datas.get(0)) && vos.getCategoryCode().equals(datas.get(1)) && vos.getMaterialCategory().equals(datas.get(2)) &&
                                    vos.getSupplierName().equals(datas.get(3))&& vos.getPaymentProportion().equals(datas.get(8))){
                                purchasesummarydetatilVO.setSettlementAmount(vos.getSettlementAmount()); // 本月结算金额(除税)
                                purchasesummarydetatilVO.setTaxSettlementAmount(vos.getTaxSettlementAmount()); // 本月结算金额(含税)
                                purchasesummarydetatilVO.setSettlementTotal(vos.getSettlementTotal()); //累计结算金额(除税)
                                purchasesummarydetatilVO.setTaxSettlementTotal(vos.getTaxSettlementTotal()); // 累计结算金额(含税)
                            }
                        }
                    }

                    int count = 0;
                    if (StringUtils.isBlank(datas.get(9)) || datas.get(9) == null) {
                        purchasesummarydetatilVO.setErrorMsg("'至本月累计应付款金额'不能为空");
                        count ++;
                        errorList.add(purchasesummarydetatilVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(9))) {
                            purchasesummarydetatilVO.setErrorMsg("'至本月累计应付款金额'格式错误");
                            count ++;
                            errorList.add(purchasesummarydetatilVO);
                        } else {
                            purchasesummarydetatilVO.setCumulativePayable(StringUtils.isNotBlank(datas.get(9)) ? new BigDecimal(datas.get(9)) : null); // 至本月累计应付款金额
                        }
                    }

                    if (StringUtils.isBlank(datas.get(10)) || datas.get(10) == null) {
                        purchasesummarydetatilVO.setErrorMsg("'至本月累计付款金额'不能为空");
                        count ++;
                        errorList.add(purchasesummarydetatilVO);
                    } else {
                        if (!NumberUtil.isNumber(datas.get(10))) {
                            purchasesummarydetatilVO.setErrorMsg("'至本月累计付款金额'格式错误");
                            count ++;
                            errorList.add(purchasesummarydetatilVO);
                        } else {
                            purchasesummarydetatilVO.setCumulativePayment(StringUtils.isNotBlank(datas.get(10)) ?new BigDecimal(datas.get(10)) : null); // 至本月累计付款金额
                        }
                    }

                    if (StringUtils.isBlank(datas.get(11)) || datas.get(11) == null) {
                        purchasesummarydetatilVO.setErrorMsg("'联系人'不能为空");
                        count ++;
                        errorList.add(purchasesummarydetatilVO);
                    } else {
                        purchasesummarydetatilVO.setContacts(StringUtils.isNotBlank(datas.get(11)) ? datas.get(11) : null); //  联系人
                    }

                    if (StringUtils.isBlank(datas.get(12)) || datas.get(12) == null) {
                        purchasesummarydetatilVO.setErrorMsg("'联系人电话'不能为空");
                        count ++;
                        errorList.add(purchasesummarydetatilVO);
                    } else {
                        purchasesummarydetatilVO.setContactsWay(StringUtils.isNotBlank(datas.get(12)) ? datas.get(12) : null); //  联系方式
                    }

                    purchasesummarydetatilVO.setRemarks(StringUtils.isNotBlank(datas.get(13)) ? (datas.get(13)) : null); // 备注
                    if(count == 0){
                        successList.add(purchasesummarydetatilVO);
                    }

                }

            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", errorList.size());
        return CommonResponse.success(json);
    }

    /**
     * excel导出数据库数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPurchasesummaryFromDatabase", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromDatabase(@RequestBody PurchasesummaryVO purchasesummaryVO, HttpServletResponse response) {
        QueryWrapper<PurchasesummarydetatilEntity> queryWrapper=new QueryWrapper<>();
        queryWrapper.eq("mid", purchasesummaryVO.getId());
        queryWrapper.eq("dr", 0);
        List<PurchasesummarydetatilEntity> list = purchasesummarydetatilService.list(queryWrapper);
        List<PurchasesummarydetatilVO> purchasesummarydetatilVOList = BeanMapper.mapList(list, PurchasesummarydetatilVO.class);
        if (purchasesummarydetatilVOList != null && purchasesummarydetatilVOList.size() > 0) {
            for (int i = 0; i < purchasesummarydetatilVOList.size(); i++) {
                PurchasesummarydetatilVO purchasesummarydetatilVO = purchasesummarydetatilVOList.get(i);
                purchasesummarydetatilVO.setSotr(String.valueOf(i + 1));

            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", purchasesummarydetatilVOList);
        ExcelExport.getInstance().export("purchasesummarydetail-export.xlsx", beans, response);
    }

    /**
     * excel导出页面数据
     *
     * @param response
     * @return
     */
    @RequestMapping(value = "/excelExportPurchasesummaryFromPage", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportConsdrawbudgetFromPage(@RequestBody List<PurchasesummarydetatilVO> list, HttpServletResponse response) {

        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); i++) {
                PurchasesummarydetatilVO purchasesummarydetatilVO = list.get(i);
                purchasesummarydetatilVO.setSotr(String.valueOf(i + 1));

            }
        }
        Map<String, Object> beans = new HashMap<String, Object>();
        beans.put("records", list);
        ExcelExport.getInstance().export("purchasesummarydetail-export.xlsx", beans, response);
    }

}
