package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.middlemeasurement.mapper.MechanicalleasedataMapper;
import com.ejianc.business.middlemeasurement.service.IMechanicalleasedataService;
import com.ejianc.business.middlemeasurement.vo.MechanicalleasedataVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service("mechanicalleasedataService")
public class MechanicalleasedataSeriviceImpl extends BaseServiceImpl<MechanicalleasedataMapper, MechanicalleasedataVO> implements IMechanicalleasedataService {

    @Resource
    MechanicalleasedataMapper mechanicalleasedataMapper;
    @Override
    public IPage<MechanicalleasedataVO> listData(String searchText, String month, Long projectId, Integer pageNumber, Integer pageSize) {
        IPage<MechanicalleasedataVO> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setPages(pageSize);
        page.setSize(pageSize);
        Long count = mechanicalleasedataMapper.listDataCount(searchText, month, projectId);
        page.setTotal(count);
        List<MechanicalleasedataVO> records =
                mechanicalleasedataMapper.listData(searchText, month, projectId, (pageNumber - 1) * pageSize, pageSize);
        page.setRecords(records);
        return page;
    }

}
