package com.ejianc.business.middlemeasurement.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.middlemeasurement.bean.RevolvingleaseEntity;
import com.ejianc.business.middlemeasurement.bean.SubcontractvisaEntity;
import com.ejianc.business.middlemeasurement.service.IRevolvingleaseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("revolvinglease") 
public class RevolvingleaseBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private IRevolvingleaseService service;
	
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		RevolvingleaseEntity entity = service.selectById(billId);
		Long contractId = entity.getContractId();//合同id

		//只能弃审最新的单据
		QueryWrapper<RevolvingleaseEntity> queryWrapper = new QueryWrapper<>();
		queryWrapper.eq("contract_id", contractId);
		queryWrapper.eq("dr", 0);
		queryWrapper.orderByDesc("create_time");
		queryWrapper.last("limit 1");
		List<RevolvingleaseEntity> pro = service.list(queryWrapper);
		if(pro != null && pro.size() > 0){
			RevolvingleaseEntity resEntity = pro.get(0);
			Integer billState = resEntity.getBillState();
			if(!billId.equals(resEntity.getId())){//本单据不是最新
				if(billState == 1 || billState == 3){
					return CommonResponse.error("只能弃审该合同下最后一次做的已生效单据！");
				}else {
					return CommonResponse.error("已存在一个审批中或自由态的最新单据，不允许弃审！");
				}
			}else{
				if(resEntity.getIsReference() == 1){
					return CommonResponse.error("被汇总单引用的单据不允许撤回！");
				}
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
